/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassEnvironment;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.ConfigurationBuilder;
import org.compass.core.config.builder.DTDConfigurationBuilder;
import org.compass.core.config.builder.SchemaConfigurationBuilder;

public class SmartConfigurationBuilder
implements ConfigurationBuilder {
    private static final Log log = LogFactory.getLog((Class)SmartConfigurationBuilder.class);
    public static final int VALIDATION_DTD = 1;
    public static final int VALIDATION_XSD = 2;
    private static final int MAX_PEEK_LINES = 5;

    public void configure(String resource, CompassConfiguration config) throws ConfigurationException {
        InputStream stream = CompassEnvironment.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new ConfigurationException("Failed to open config resource [" + resource + "]");
        }
        int mode = this.detectValidationMode(stream, resource);
        if (mode == 2) {
            new SchemaConfigurationBuilder().configure(resource, config);
        } else {
            new DTDConfigurationBuilder().configure(resource, config);
        }
    }

    public void configure(URL url, CompassConfiguration config) throws ConfigurationException {
        InputStream stream;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to open url [" + url.toExternalForm() + "]", e);
        }
        int mode = this.detectValidationMode(stream, url.toExternalForm());
        if (mode == 2) {
            new SchemaConfigurationBuilder().configure(url, config);
        } else {
            new DTDConfigurationBuilder().configure(url, config);
        }
    }

    public void configure(File file, CompassConfiguration config) throws ConfigurationException {
        FileInputStream stream;
        try {
            stream = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not find configuration file [" + file.getAbsolutePath() + "]", e);
        }
        int mode = this.detectValidationMode(stream, file.getAbsolutePath());
        if (mode == 2) {
            new SchemaConfigurationBuilder().configure(file, config);
        } else {
            new DTDConfigurationBuilder().configure(file, config);
        }
    }

    private int detectValidationMode(InputStream stream, String resourceName) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream));
            boolean isDtdValidated = false;
            for (int x = 0; x < 5 && (line = reader.readLine()) != null; ++x) {
                if (line.indexOf("DOCTYPE") <= -1) continue;
                isDtdValidated = true;
                break;
            }
            int n = isDtdValidated ? 1 : 2;
            return n;
        }
        catch (IOException ex) {
            throw new ConfigurationException("Unable to determine validation mode for [" + resourceName + "]. Did you attempt to load directly from a SAX InputSource?", ex);
        }
        finally {
            block11: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn((Object)("Unable to close BufferedReader for [" + resourceName + "]."), (Throwable)ex);
                    }
                }
            }
        }
    }
}

