/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.accessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.accessor.BasicPropertyAccessor;
import org.compass.core.accessor.DirectPropertyAccessor;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.mapping.MappingException;
import org.compass.core.util.ClassUtils;

public class PropertyAccessorFactory
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog((Class)PropertyAccessorFactory.class);
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
    private Map propertyAccessorsRegistry = new HashMap();

    public void configure(CompassSettings settings) throws CompassException {
        this.propertyAccessorsRegistry.put("property", BASIC_PROPERTY_ACCESSOR);
        this.propertyAccessorsRegistry.put("field", DIRECT_PROPERTY_ACCESSOR);
        Map paGroups = settings.getSettingGroups("compass.propertyAccessor");
        Iterator it = paGroups.keySet().iterator();
        while (it.hasNext()) {
            PropertyAccessor propertyAccessor;
            CompassSettings paSettings;
            String paType;
            String paName = (String)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property Accessor [" + paName + "] building..."));
            }
            if ((paType = (paSettings = (CompassSettings)paGroups.get(paName)).getSetting("type")) == null) {
                throw new ConfigurationException("Must define type for property accessor [" + paName + "]");
            }
            try {
                propertyAccessor = (PropertyAccessor)ClassUtils.forName(paType).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create property accessor [" + paName + "] type", e);
            }
            if (propertyAccessor instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)propertyAccessor)).configure(paSettings);
            }
            this.propertyAccessorsRegistry.put(paName, propertyAccessor);
        }
    }

    public PropertyAccessor getPropertyAccessor(String type) throws MappingException {
        Class accessorClass;
        if (type == null) {
            PropertyAccessor propertyAccessor = (PropertyAccessor)this.propertyAccessorsRegistry.get("default");
            if (propertyAccessor != null) {
                return propertyAccessor;
            }
            return BASIC_PROPERTY_ACCESSOR;
        }
        PropertyAccessor propertyAccessor = (PropertyAccessor)this.propertyAccessorsRegistry.get(type);
        if (propertyAccessor != null) {
            return propertyAccessor;
        }
        try {
            accessorClass = ClassUtils.forName(type);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("Could not find PropertyAccessor class [" + type + "]", cnfe);
        }
        try {
            return (PropertyAccessor)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate PropertyAccessor class [" + type + "]", e);
        }
    }
}

