/*
 * Decompiled with CFR 0.152.
 */
package org.compass.annotations.config.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.compass.annotations.AnalyzerType;
import org.compass.annotations.SearchAnalyzer;
import org.compass.annotations.SearchAnalyzerFilter;
import org.compass.annotations.SearchAnalyzerFilters;
import org.compass.annotations.SearchAnalyzers;
import org.compass.annotations.SearchConverter;
import org.compass.annotations.SearchConverters;
import org.compass.annotations.SearchSetting;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableAllMetaData;
import org.compass.annotations.SearchableAnalyzerProperty;
import org.compass.annotations.SearchableClassConverter;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableConstant;
import org.compass.annotations.SearchableConstants;
import org.compass.annotations.SearchableDynamicMetaData;
import org.compass.annotations.SearchableDynamicMetaDatas;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableMetaData;
import org.compass.annotations.SearchableMetaDatas;
import org.compass.annotations.SearchableParent;
import org.compass.annotations.SearchableProperty;
import org.compass.annotations.SearchableReference;
import org.compass.annotations.SearchableSubIndexHash;
import org.compass.annotations.SupportUnmarshall;
import org.compass.annotations.config.binding.AnnotationsBindingUtils;
import org.compass.core.config.CommonMetaDataLookup;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.binding.MappingBindingSupport;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.osem.MetaDataFormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyAnalyzerController;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsMappingBinding
extends MappingBindingSupport {
    public static final Log log = LogFactory.getLog(AnnotationsMappingBinding.class);
    private CommonMetaDataLookup valueLookup;
    private CompassMapping mapping;
    private ClassMapping classMapping;
    private CompassSettings settings;

    @Override
    public void setUpBinding(CompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        this.mapping = mapping;
        this.valueLookup = new CommonMetaDataLookup(metaData);
        this.settings = settings;
    }

    @Override
    public boolean addPackage(String packageName) throws ConfigurationException, MappingException {
        Package pckg;
        try {
            pckg = ClassUtils.forName(packageName + ".package-info").getPackage();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (pckg.isAnnotationPresent(SearchConverter.class)) {
            this.bindConverter(pckg.getAnnotation(SearchConverter.class));
        }
        if (pckg.isAnnotationPresent(SearchConverters.class)) {
            SearchConverters searchConverters = pckg.getAnnotation(SearchConverters.class);
            for (Annotation annotation : searchConverters.value()) {
                this.bindConverter((SearchConverter)annotation);
            }
        }
        if (pckg.isAnnotationPresent(SearchAnalyzer.class)) {
            this.bindAnalyzer(pckg.getAnnotation(SearchAnalyzer.class));
        }
        if (pckg.isAnnotationPresent(SearchAnalyzers.class)) {
            SearchAnalyzers searchAnalyzers = pckg.getAnnotation(SearchAnalyzers.class);
            for (Annotation annotation : searchAnalyzers.value()) {
                this.bindAnalyzer((SearchAnalyzer)annotation);
            }
        }
        if (pckg.isAnnotationPresent(SearchAnalyzerFilter.class)) {
            this.bindAnalyzerFilter(pckg.getAnnotation(SearchAnalyzerFilter.class));
        }
        if (pckg.isAnnotationPresent(SearchAnalyzerFilters.class)) {
            SearchAnalyzerFilters searchAnalyzerFilters = pckg.getAnnotation(SearchAnalyzerFilters.class);
            for (Annotation annotation : searchAnalyzerFilters.value()) {
                this.bindAnalyzerFilter((SearchAnalyzerFilter)annotation);
            }
        }
        return true;
    }

    private void bindAnalyzerFilter(SearchAnalyzerFilter searchAnalyzerFilter) throws ConfigurationException, MappingException {
        ArrayList<String> settingsNames = new ArrayList<String>();
        ArrayList<String> settingsValues = new ArrayList<String>();
        settingsNames.add("type");
        settingsValues.add(searchAnalyzerFilter.type().getName());
        for (SearchSetting setting : searchAnalyzerFilter.settings()) {
            settingsNames.add(setting.name());
            settingsValues.add(setting.value());
        }
        this.settings.setGroupSettings("compass.engine.analyzerfilter", searchAnalyzerFilter.name(), settingsNames.toArray(new String[settingsNames.size()]), settingsValues.toArray(new String[settingsValues.size()]));
    }

    private void bindAnalyzer(SearchAnalyzer searchAnalyzer) throws ConfigurationException, MappingException {
        StringBuffer sb;
        ArrayList<String> settingsNames = new ArrayList<String>();
        ArrayList<String> settingsValues = new ArrayList<String>();
        settingsNames.add("type");
        if (searchAnalyzer.type() == AnalyzerType.CustomAnalyzer) {
            if (Analyzer.class.equals(searchAnalyzer.analyzerClass())) {
                throw new ConfigurationException("SearchableAnalyzer [" + searchAnalyzer.name() + "] has " + "type of [" + (Object)((Object)AnalyzerType.CustomAnalyzer) + "] but does not set analyzerClass");
            }
            settingsValues.add(searchAnalyzer.analyzerClass().getName());
        } else {
            settingsValues.add(searchAnalyzer.type().toString());
        }
        if (searchAnalyzer.type() == AnalyzerType.Snowball) {
            settingsNames.add("name");
            settingsValues.add(searchAnalyzer.snowballType().toString());
        }
        if (searchAnalyzer.stopWords().length > 0) {
            sb = new StringBuffer();
            if (searchAnalyzer.addStopWords()) {
                sb.append("+");
            }
            for (String stopword : searchAnalyzer.stopWords()) {
                sb.append(stopword).append(",");
            }
            settingsNames.add("stopwords");
            settingsValues.add(sb.toString());
        }
        if (searchAnalyzer.filters().length > 0) {
            sb = new StringBuffer();
            for (String filter : searchAnalyzer.filters()) {
                sb.append(filter).append(",");
            }
            settingsNames.add("filters");
            settingsValues.add(sb.toString());
        }
        for (SearchSetting setting : searchAnalyzer.settings()) {
            settingsNames.add(setting.name());
            settingsValues.add(setting.value());
        }
        this.settings.setGroupSettings("compass.engine.analyzer", searchAnalyzer.name(), settingsNames.toArray(new String[settingsNames.size()]), settingsValues.toArray(new String[settingsValues.size()]));
    }

    private void bindConverter(SearchConverter searchConverter) throws ConfigurationException, MappingException {
        String[] settingsNames = new String[searchConverter.settings().length + 1];
        String[] settingsValues = new String[searchConverter.settings().length + 1];
        for (int i = 0; i < searchConverter.settings().length; ++i) {
            SearchSetting setting = searchConverter.settings()[i];
            settingsNames[i] = setting.name();
            settingsValues[i] = setting.value();
        }
        settingsNames[i] = "type";
        settingsValues[i] = searchConverter.type().getName();
        this.settings.setGroupSettings("compass.converter", searchConverter.name(), settingsNames, settingsValues);
    }

    @Override
    public boolean addClass(Class clazz) throws ConfigurationException, MappingException {
        SearchableSubIndexHash searchableSubIndexHash;
        Class annotationClass = clazz;
        Searchable searchable = annotationClass.getAnnotation(Searchable.class);
        if (searchable == null) {
            return false;
        }
        String alias = searchable.alias();
        if (!StringUtils.hasLength(alias)) {
            alias = ClassUtils.getShortName(clazz);
        } else {
            Alias aliasLookup = this.valueLookup.lookupAlias(alias);
            if (aliasLookup != null) {
                alias = aliasLookup.getName();
            }
        }
        boolean newClassMapping = false;
        AliasMapping aliasMapping = this.mapping.getAliasMapping(alias);
        if (aliasMapping != null) {
            if (!(aliasMapping instanceof ClassMapping)) {
                throw new MappingException("Defined searchable annotation on a class with alias [" + alias + "] which" + " has other mapping definitions, but it not of type class mapping");
            }
            this.classMapping = (ClassMapping)aliasMapping;
        } else {
            this.classMapping = new ClassMapping();
            newClassMapping = true;
        }
        this.classMapping.setAlias(alias);
        this.classMapping.setName(clazz.getName());
        this.classMapping.setClazz(clazz);
        String subIndex = searchable.subIndex();
        if (!StringUtils.hasLength(subIndex)) {
            subIndex = alias;
        }
        if ((searchableSubIndexHash = annotationClass.getAnnotation(SearchableSubIndexHash.class)) == null) {
            this.classMapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        } else {
            SubIndexHash subIndexHash = null;
            try {
                subIndexHash = searchableSubIndexHash.value().newInstance();
            }
            catch (Exception e) {
                throw new MappingException("Failed to create sub index hash [" + searchableSubIndexHash.value().getName() + "]", e);
            }
            if (subIndexHash instanceof CompassConfigurable) {
                CompassSettings settings = new CompassSettings();
                for (int i = 0; i < searchableSubIndexHash.settings().length; ++i) {
                    SearchSetting setting = searchableSubIndexHash.settings()[i];
                    settings.setSetting(setting.name(), setting.value());
                }
                ((CompassConfigurable)((Object)subIndexHash)).configure(settings);
            }
            this.classMapping.setSubIndexHash(subIndexHash);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Alias [" + this.classMapping.getAlias() + "] is mapped to sub index hash [" + this.classMapping.getSubIndexHash() + "]"));
        }
        this.classMapping.setAllSupported(searchable.enableAll());
        SearchableAllMetaData allMetaData = annotationClass.getAnnotation(SearchableAllMetaData.class);
        if (allMetaData != null) {
            if (StringUtils.hasLength(allMetaData.name())) {
                this.classMapping.setAllProperty(allMetaData.name());
            }
            if (StringUtils.hasLength(allMetaData.analyzer())) {
                this.classMapping.setAllAnalyzer(allMetaData.analyzer());
            }
            this.classMapping.setAllTermVector(AnnotationsBindingUtils.convert(allMetaData.termVector()));
        }
        this.classMapping.setBoost(searchable.boost());
        this.classMapping.setRoot(searchable.root());
        this.classMapping.setPoly(searchable.poly());
        if (!Object.class.equals((Object)searchable.polyClass())) {
            this.classMapping.setPolyClass(searchable.polyClass());
        }
        if (StringUtils.hasLength(searchable.analyzer())) {
            this.classMapping.setAnalyzer(searchable.analyzer());
        }
        if (searchable.supportUnmsarshll() == SupportUnmarshall.TRUE) {
            this.classMapping.setSupportUnmarshall(true);
        } else if (searchable.supportUnmsarshll() == SupportUnmarshall.FALSE) {
            this.classMapping.setSupportUnmarshall(false);
        }
        this.bindConverter(this.classMapping, searchable.converter());
        this.processAnnotatedClass(annotationClass);
        if (newClassMapping) {
            this.mapping.addMapping(this.classMapping);
        }
        this.classMapping = null;
        return true;
    }

    private void processAnnotatedClass(Class<?> clazz) {
        Searchable searchable;
        String[] extend;
        SearchableDynamicMetaDatas searchableDynamicMetaDatas;
        SearchableDynamicMetaData searchableDynamicMetaData;
        SearchableConstants searchableConstants;
        Class<?>[] interfaces;
        if (clazz.equals(Class.class)) {
            return;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            this.processAnnotatedClass(superClazz);
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            this.processAnnotatedClass(anInterface);
        }
        SearchableConstant searchableConstant = clazz.getAnnotation(SearchableConstant.class);
        if (searchableConstant != null) {
            this.bindConstantMetaData(searchableConstant);
        }
        if ((searchableConstants = clazz.getAnnotation(SearchableConstants.class)) != null) {
            for (SearchableConstant metaData : searchableConstants.value()) {
                this.bindConstantMetaData(metaData);
            }
        }
        if ((searchableDynamicMetaData = clazz.getAnnotation(SearchableDynamicMetaData.class)) != null) {
            this.bindDynamicMetaData(searchableDynamicMetaData);
        }
        if ((searchableDynamicMetaDatas = clazz.getAnnotation(SearchableDynamicMetaDatas.class)) != null) {
            SearchableDynamicMetaData[] arr$ = searchableDynamicMetaDatas.value();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SearchableDynamicMetaData searchableDynamicMetaData2 = arr$[i$];
                this.bindDynamicMetaData(searchableDynamicMetaData2);
            }
        }
        if (clazz.isAnnotationPresent(Searchable.class) && (extend = (searchable = clazz.getAnnotation(Searchable.class)).extend()).length != 0) {
            ArrayList<String> extendedMappings = new ArrayList<String>();
            if (this.classMapping.getExtendedAliases() != null) {
                for (String extendedAlias : this.classMapping.getExtendedAliases()) {
                    extendedMappings.add(extendedAlias);
                }
            }
            for (String extendedAlias : extend) {
                Alias extendedAliasLookup = this.valueLookup.lookupAlias(extendedAlias);
                if (extendedAliasLookup == null) {
                    extendedMappings.add(extendedAlias);
                    continue;
                }
                extendedMappings.add(extendedAliasLookup.getName());
            }
            this.classMapping.setExtendedAliases(extendedMappings.toArray(new String[extendedMappings.size()]));
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                this.processsAnnotatedElement(clazz, ClassUtils.getShortNameForField(field), "field", field.getType(), field.getGenericType(), annotation, field);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge() || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).getReturnType() == Void.TYPE || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is")) continue;
            for (Annotation annotation : accessibleObject.getAnnotations()) {
                this.processsAnnotatedElement(clazz, ClassUtils.getShortNameForMethod((Method)accessibleObject), "property", ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getGenericReturnType(), annotation, accessibleObject);
            }
        }
    }

    private void processsAnnotatedElement(Class<?> searchableClass, String name, String accessor, Class<?> clazz, Type type, Annotation annotation, AnnotatedElement annotatedElement) {
        if (annotation instanceof SearchableId) {
            ClassIdPropertyMapping classPropertyMapping = new ClassIdPropertyMapping();
            SearchableId searchableId = (SearchableId)annotation;
            this.bindObjectMapping(classPropertyMapping, accessor, name, searchableId.accessor(), searchableClass);
            this.bindClassPropertyIdMapping(searchableId, classPropertyMapping, clazz, type, annotatedElement);
            this.classMapping.addMapping(classPropertyMapping);
        } else if (annotation instanceof SearchableProperty) {
            ClassPropertyMapping classPropertyMapping = new ClassPropertyMapping();
            SearchableProperty searchableProperty = (SearchableProperty)annotation;
            this.bindObjectMapping(classPropertyMapping, accessor, name, searchableProperty.accessor(), searchableClass);
            this.bindClassPropertyMapping(searchableProperty, classPropertyMapping, annotatedElement, clazz, type);
            this.classMapping.addMapping(classPropertyMapping);
        } else if (annotation instanceof SearchableComponent) {
            ComponentMapping componentMapping = new ComponentMapping();
            SearchableComponent searchableComponent = (SearchableComponent)annotation;
            this.bindObjectMapping(componentMapping, accessor, name, searchableComponent.accessor(), searchableClass);
            this.bindComponent(searchableComponent, componentMapping, clazz, type);
            this.classMapping.addMapping(componentMapping);
        } else if (annotation instanceof SearchableReference) {
            ReferenceMapping referenceMapping = new ReferenceMapping();
            SearchableReference searchableReference = (SearchableReference)annotation;
            this.bindObjectMapping(referenceMapping, accessor, name, searchableReference.accessor(), searchableClass);
            this.bindReference(searchableReference, referenceMapping, clazz, type);
            this.classMapping.addMapping(referenceMapping);
        } else if (annotation instanceof SearchableAnalyzerProperty) {
            ClassPropertyAnalyzerController analyzerMapping = new ClassPropertyAnalyzerController();
            SearchableAnalyzerProperty searchableAnalyzerProperty = (SearchableAnalyzerProperty)annotation;
            this.bindObjectMapping(analyzerMapping, accessor, name, searchableAnalyzerProperty.accessor(), searchableClass);
            this.bindAnalyzer(searchableAnalyzerProperty, analyzerMapping, clazz, type);
            this.classMapping.addMapping(analyzerMapping);
        } else if (annotation instanceof SearchableParent) {
            ParentMapping parentMapping = new ParentMapping();
            SearchableParent searchableParent = (SearchableParent)annotation;
            this.bindObjectMapping(parentMapping, accessor, name, searchableParent.accessor(), searchableClass);
            this.bindParent(searchableParent, parentMapping, clazz, type);
            this.classMapping.addMapping(parentMapping);
        } else if ((annotation instanceof SearchableMetaData || annotation instanceof SearchableMetaDatas) && !annotatedElement.isAnnotationPresent(SearchableProperty.class) && !annotatedElement.isAnnotationPresent(SearchableId.class)) {
            throw new MappingException("SearchableMetaData/s annotation exists without a SearchableProperty/Id, it will be ignored");
        }
    }

    private void bindParent(SearchableParent searchableParent, ParentMapping parentMapping, Class<?> clazz, Type type) {
        this.bindConverter(parentMapping, searchableParent.converter(), clazz, type);
    }

    private void bindAnalyzer(SearchableAnalyzerProperty searchableAnalyzerProperty, ClassPropertyAnalyzerController analyzerMapping, Class<?> clazz, Type type) {
        this.bindConverter(analyzerMapping, searchableAnalyzerProperty.converter(), clazz, type);
        if (StringUtils.hasLength(searchableAnalyzerProperty.nullAnalyzer())) {
            analyzerMapping.setNullAnalyzer(searchableAnalyzerProperty.nullAnalyzer());
        }
    }

    private void bindReference(SearchableReference searchableReference, ReferenceMapping referenceMapping, Class<?> clazz, Type type) {
        this.bindConverter(referenceMapping, searchableReference.converter(), clazz, type);
        if (StringUtils.hasLength(searchableReference.refAlias())) {
            referenceMapping.setRefAliases(this.getAliases(searchableReference.refAlias()));
        } else {
            referenceMapping.setRefClass(AnnotationsBindingUtils.getCollectionParameterClass(clazz, type));
        }
        if (StringUtils.hasLength(searchableReference.refComponentAlias())) {
            referenceMapping.setRefCompAlias(searchableReference.refComponentAlias());
        }
    }

    private void bindComponent(SearchableComponent searchableComponent, ComponentMapping componentMapping, Class<?> clazz, Type type) {
        this.bindConverter(componentMapping, searchableComponent.converter(), clazz, type);
        if (StringUtils.hasLength(searchableComponent.refAlias())) {
            componentMapping.setRefAliases(this.getAliases(searchableComponent.refAlias()));
        } else {
            componentMapping.setRefClass(AnnotationsBindingUtils.getCollectionParameterClass(clazz, type));
        }
        componentMapping.setMaxDepth(searchableComponent.maxDepth());
        componentMapping.setOverrideByName(searchableComponent.override());
    }

    private void bindClassPropertyIdMapping(SearchableId searchableProp, ClassIdPropertyMapping classPropertyMapping, Class<?> clazz, Type type, AnnotatedElement annotatedElement) throws MappingException {
        this.bindConverter(classPropertyMapping, searchableProp.idConverter());
        classPropertyMapping.setBoost(searchableProp.boost());
        classPropertyMapping.setManagedId(AnnotationsBindingUtils.convert(searchableProp.managedId()));
        classPropertyMapping.setManagedIdIndex(AnnotationsBindingUtils.convert(searchableProp.managedIdIndex()));
        classPropertyMapping.setOverrideByName(searchableProp.override());
        SearchableMetaData metaData = annotatedElement.getAnnotation(SearchableMetaData.class);
        SearchableMetaDatas metaDatas = annotatedElement.getAnnotation(SearchableMetaDatas.class);
        if (StringUtils.hasLength(searchableProp.converter())) {
            classPropertyMapping.setManagedIdConverterName(searchableProp.converter());
        } else {
            classPropertyMapping.setManagedIdConverter(this.getConverter(clazz, type));
        }
        if (StringUtils.hasLength(searchableProp.name())) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            String name = searchableProp.name();
            if (!StringUtils.hasLength(name)) {
                name = classPropertyMapping.getName();
            }
            mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
            mdMapping.setBoost(classPropertyMapping.getBoost());
            mdMapping.setAccessor(classPropertyMapping.getAccessor());
            mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
            this.bindConverter(mdMapping, searchableProp.converter(), clazz, type);
            mdMapping.setStore(AnnotationsBindingUtils.convert(searchableProp.store()));
            mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableProp.index()));
            mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableProp.termVector()));
            mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableProp.reverse()));
            this.handleFormat(mdMapping, name, searchableProp.format());
            if (StringUtils.hasLength(searchableProp.analyzer())) {
                mdMapping.setAnalyzer(searchableProp.analyzer());
            }
            mdMapping.setExcludeFromAll(searchableProp.excludeFromAll());
            classPropertyMapping.addMapping(mdMapping);
        }
        if (metaData != null) {
            this.bindMetaData(metaData, classPropertyMapping, clazz, type);
        }
        if (metaDatas != null) {
            for (SearchableMetaData searchableMetaData : metaDatas.value()) {
                this.bindMetaData(searchableMetaData, classPropertyMapping, clazz, type);
            }
        }
    }

    private void bindClassPropertyMapping(SearchableProperty searchableProp, ClassPropertyMapping classPropertyMapping, AnnotatedElement annotatedElement, Class<?> clazz, Type type) throws MappingException {
        boolean hasMetaDataAnnotations;
        this.bindConverter(classPropertyMapping, searchableProp.propertyConverter());
        if (!searchableProp.type().equals(Object.class)) {
            classPropertyMapping.setClassName(searchableProp.type().getName());
        } else {
            classPropertyMapping.setClassName(AnnotationsBindingUtils.getCollectionParameterClassName(clazz, type));
        }
        if (StringUtils.hasLength(searchableProp.converter())) {
            classPropertyMapping.setManagedIdConverterName(searchableProp.converter());
        } else {
            classPropertyMapping.setManagedIdConverter(this.getConverter(clazz, type));
        }
        classPropertyMapping.setBoost(searchableProp.boost());
        classPropertyMapping.setManagedId(AnnotationsBindingUtils.convert(searchableProp.managedId()));
        classPropertyMapping.setManagedIdIndex(AnnotationsBindingUtils.convert(searchableProp.managedIdIndex()));
        classPropertyMapping.setOverrideByName(searchableProp.override());
        SearchableMetaData metaData = annotatedElement.getAnnotation(SearchableMetaData.class);
        SearchableMetaDatas metaDatas = annotatedElement.getAnnotation(SearchableMetaDatas.class);
        boolean bl = hasMetaDataAnnotations = metaData != null || metaDatas != null;
        if (StringUtils.hasLength(searchableProp.name()) || !hasMetaDataAnnotations) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            String name = searchableProp.name();
            if (!StringUtils.hasLength(name)) {
                name = classPropertyMapping.getName();
            }
            mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
            mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
            mdMapping.setBoost(classPropertyMapping.getBoost());
            this.bindConverter(mdMapping, searchableProp.converter(), clazz, type);
            mdMapping.setAccessor(classPropertyMapping.getAccessor());
            mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
            mdMapping.setStore(AnnotationsBindingUtils.convert(searchableProp.store()));
            mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableProp.index()));
            mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableProp.termVector()));
            mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableProp.reverse()));
            this.handleFormat(mdMapping, name, searchableProp.format());
            mdMapping.setInternal(false);
            if (StringUtils.hasLength(searchableProp.analyzer())) {
                mdMapping.setAnalyzer(searchableProp.analyzer());
            }
            mdMapping.setExcludeFromAll(searchableProp.excludeFromAll());
            classPropertyMapping.addMapping(mdMapping);
        }
        if (metaData != null) {
            this.bindMetaData(metaData, classPropertyMapping, clazz, type);
        }
        if (metaDatas != null) {
            for (SearchableMetaData searchableMetaData : metaDatas.value()) {
                this.bindMetaData(searchableMetaData, classPropertyMapping, clazz, type);
            }
        }
    }

    private void bindMetaData(SearchableMetaData searchableMetaData, ClassPropertyMapping classPropertyMapping, Class<?> clazz, Type type) {
        ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
        String name = searchableMetaData.name();
        mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
        mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        if (searchableMetaData.boost() == 1.0f) {
            mdMapping.setBoost(classPropertyMapping.getBoost());
        } else {
            mdMapping.setBoost(searchableMetaData.boost());
        }
        this.bindConverter(mdMapping, searchableMetaData.converter(), clazz, type);
        mdMapping.setAccessor(classPropertyMapping.getAccessor());
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        mdMapping.setStore(AnnotationsBindingUtils.convert(searchableMetaData.store()));
        mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableMetaData.index()));
        mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableMetaData.termVector()));
        mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableMetaData.reverse()));
        this.handleFormat(mdMapping, name, searchableMetaData.format());
        mdMapping.setInternal(false);
        if (StringUtils.hasLength(searchableMetaData.analyzer())) {
            mdMapping.setAnalyzer(searchableMetaData.analyzer());
        }
        mdMapping.setExcludeFromAll(searchableMetaData.excludeFromAll());
        classPropertyMapping.addMapping(mdMapping);
    }

    private void bindDynamicMetaData(SearchableDynamicMetaData searchableMetaData) {
        DynamicMetaDataMapping mdMapping = new DynamicMetaDataMapping();
        String name = searchableMetaData.name();
        mdMapping.setName(this.valueLookup.lookupMetaDataName(name));
        mdMapping.setPath(new StaticPropertyPath(mdMapping.getName()));
        mdMapping.setBoost(searchableMetaData.boost());
        mdMapping.setConverterName(searchableMetaData.converter());
        mdMapping.setExpression(searchableMetaData.expression());
        if (StringUtils.hasLength(searchableMetaData.format())) {
            mdMapping.setFormat(searchableMetaData.format());
        }
        mdMapping.setType(searchableMetaData.type());
        mdMapping.setStore(AnnotationsBindingUtils.convert(searchableMetaData.store()));
        mdMapping.setIndex(AnnotationsBindingUtils.convert(searchableMetaData.index()));
        mdMapping.setTermVector(AnnotationsBindingUtils.convert(searchableMetaData.termVector()));
        mdMapping.setReverse(AnnotationsBindingUtils.convert(searchableMetaData.reverse()));
        mdMapping.setInternal(false);
        if (StringUtils.hasLength(searchableMetaData.analyzer())) {
            mdMapping.setAnalyzer(searchableMetaData.analyzer());
        }
        mdMapping.setExcludeFromAll(searchableMetaData.excludeFromAll());
        this.classMapping.addMapping(mdMapping);
    }

    private void bindConstantMetaData(SearchableConstant searchableConstant) {
        ConstantMetaDataMapping constantMapping = new ConstantMetaDataMapping();
        constantMapping.setName(this.valueLookup.lookupMetaDataName(searchableConstant.name()));
        constantMapping.setBoost(searchableConstant.boost());
        constantMapping.setStore(AnnotationsBindingUtils.convert(searchableConstant.store()));
        constantMapping.setIndex(AnnotationsBindingUtils.convert(searchableConstant.index()));
        constantMapping.setTermVector(AnnotationsBindingUtils.convert(searchableConstant.termVector()));
        if (StringUtils.hasLength(searchableConstant.analyzer())) {
            constantMapping.setAnalyzer(searchableConstant.analyzer());
        }
        constantMapping.setExcludeFromAll(searchableConstant.excludeFromAll());
        constantMapping.setOverrideByName(searchableConstant.override());
        for (String value : searchableConstant.values()) {
            constantMapping.addMetaDataValue(this.valueLookup.lookupMetaDataValue(value));
        }
        this.classMapping.addMapping(constantMapping);
    }

    private void bindConverter(Mapping mapping, String converterName) {
        this.bindConverter(mapping, converterName, null, null);
    }

    private void bindConverter(Mapping mapping, String converterName, Class<?> clazz, Type type) {
        if (StringUtils.hasLength(converterName)) {
            mapping.setConverterName(converterName);
            return;
        }
        if (clazz == null) {
            return;
        }
        mapping.setConverter(this.getConverter(clazz, type));
    }

    public Converter getConverter(Class<?> clazz, Type type) {
        Converter objConverter;
        SearchableClassConverter searchableClassConverter;
        Class<?> actualClass = AnnotationsBindingUtils.getCollectionParameterClass(clazz, type);
        if (actualClass == null) {
            actualClass = clazz;
        }
        if ((searchableClassConverter = actualClass.getAnnotation(SearchableClassConverter.class)) == null) {
            return null;
        }
        try {
            objConverter = searchableClassConverter.value().newInstance();
        }
        catch (Exception e) {
            throw new MappingException("Failed to create converter [" + searchableClassConverter.value().getName() + "]", e);
        }
        if (!(objConverter instanceof Converter)) {
            throw new MappingException("[" + searchableClassConverter + "] does not implement Converter interface");
        }
        Converter converter = objConverter;
        if (searchableClassConverter.settings().length > 0 && !(converter instanceof CompassConfigurable)) {
            throw new MappingException("[" + searchableClassConverter + "] does not implement CompassConfigurable" + " interface, but has settings set, please implement it so settings can be injected");
        }
        if (converter instanceof CompassConfigurable) {
            CompassSettings settings = new CompassSettings();
            for (int i = 0; i < searchableClassConverter.settings().length; ++i) {
                SearchSetting setting = searchableClassConverter.settings()[i];
                settings.setSetting(setting.name(), setting.value());
            }
            ((CompassConfigurable)((Object)converter)).configure(settings);
        }
        return converter;
    }

    private void bindObjectMapping(ObjectMapping objectMapping, String actualAccessor, String name, String annotationAccessor, Class<?> searchableClass) {
        if (!StringUtils.hasLength(annotationAccessor)) {
            objectMapping.setAccessor(actualAccessor);
        } else {
            objectMapping.setAccessor(annotationAccessor);
        }
        objectMapping.setName(name);
        objectMapping.setPropertyName(name);
        if (searchableClass.isAnnotationPresent(Searchable.class)) {
            Searchable searchable = searchableClass.getAnnotation(Searchable.class);
            if (StringUtils.hasLength(searchable.alias())) {
                objectMapping.setDefinedInAlias(searchable.alias());
            } else {
                objectMapping.setDefinedInAlias(searchableClass.getName());
            }
        } else {
            objectMapping.setDefinedInAlias(searchableClass.getName());
        }
    }

    private String[] getAliases(String commaSeparatedAliases) {
        ArrayList<String> aliases = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(commaSeparatedAliases, ",");
        while (st.hasMoreTokens()) {
            String extendedAlias = st.nextToken().trim();
            Alias alias = this.valueLookup.lookupAlias(extendedAlias);
            if (alias == null) {
                aliases.add(extendedAlias);
                continue;
            }
            aliases.add(alias.getName());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private void handleFormat(ClassPropertyMetaDataMapping mdMapping, String name, String format) {
        if (!StringUtils.hasLength(format)) {
            return;
        }
        if (mdMapping.getConverter() == null) {
            if (format == null) {
                format = this.valueLookup.lookupMetaDataFormat(name);
            }
            if (format != null) {
                mdMapping.setConverter(new MetaDataFormatDelegateConverter(format));
            }
        }
    }
}

