/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.FileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.JdbcIndexConfigurable;
import org.apache.lucene.store.jdbc.index.RAMJdbcIndexOutput;

public class RAMAndFileJdbcIndexOutput
extends IndexOutput
implements JdbcIndexConfigurable {
    public static final String INDEX_OUTPUT_THRESHOLD_SETTING = "indexOutput.threshold";
    public static final long DEFAULT_THRESHOLD = 16384L;
    private long threshold;
    private RAMJdbcIndexOutput ramIndexOutput;
    private FileJdbcIndexOutput fileIndexOutput;
    private JdbcDirectory jdbcDirectory;
    private String name;
    private JdbcFileEntrySettings settings;
    private long position;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
        this.settings = settings;
        this.threshold = settings.getSettingAsLong(INDEX_OUTPUT_THRESHOLD_SETTING, 16384L);
        this.ramIndexOutput = this.createRamJdbcIndexOutput();
        this.ramIndexOutput.configure(name, jdbcDirectory, settings);
    }

    public void writeByte(byte b) throws IOException {
        this.switchIfNeeded(1).writeByte(b);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.switchIfNeeded(length).writeBytes(b, length);
    }

    public void flush() throws IOException {
        this.actualOutput().flush();
    }

    public void close() throws IOException {
        this.actualOutput().close();
    }

    public long getFilePointer() {
        return this.actualOutput().getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
        this.actualOutput().seek(pos);
    }

    public long length() throws IOException {
        return this.actualOutput().length();
    }

    private IndexOutput actualOutput() {
        if (this.fileIndexOutput != null) {
            return this.fileIndexOutput;
        }
        return this.ramIndexOutput;
    }

    private IndexOutput switchIfNeeded(int length) throws IOException {
        if (this.fileIndexOutput != null) {
            return this.fileIndexOutput;
        }
        this.position += (long)length;
        if (this.position < this.threshold) {
            return this.ramIndexOutput;
        }
        this.fileIndexOutput = this.createFileJdbcIndexOutput();
        this.fileIndexOutput.configure(this.name, this.jdbcDirectory, this.settings);
        this.ramIndexOutput.flushToIndexOutput(this.fileIndexOutput);
        this.ramIndexOutput = null;
        return this.fileIndexOutput;
    }

    protected FileJdbcIndexOutput createFileJdbcIndexOutput() {
        return new FileJdbcIndexOutput();
    }

    protected RAMJdbcIndexOutput createRamJdbcIndexOutput() {
        return new RAMJdbcIndexOutput();
    }
}

