/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.index.JdbcBufferedIndexInput;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class FetchOnBufferReadJdbcIndexInput
extends JdbcBufferedIndexInput {
    private String name;
    private long totalLength = -1L;
    private long position = 1L;
    private JdbcDirectory jdbcDirectory;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    protected void refill() throws IOException {
        this.jdbcDirectory.getJdbcTemplate().executeSelect(this.jdbcDirectory.getTable().sqlSelectSizeValueByName(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, FetchOnBufferReadJdbcIndexInput.this.name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    throw new JdbcStoreException("No entry for [" + FetchOnBufferReadJdbcIndexInput.this.name + "] table " + FetchOnBufferReadJdbcIndexInput.this.jdbcDirectory.getTable());
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (FetchOnBufferReadJdbcIndexInput.this.totalLength == -1L) {
                        FetchOnBufferReadJdbcIndexInput.this.totalLength = rs.getLong(3);
                    }
                }
                long start = FetchOnBufferReadJdbcIndexInput.this.bufferStart + (long)FetchOnBufferReadJdbcIndexInput.this.bufferPosition;
                long end = start + (long)FetchOnBufferReadJdbcIndexInput.this.bufferSize;
                if (end > FetchOnBufferReadJdbcIndexInput.this.length()) {
                    end = FetchOnBufferReadJdbcIndexInput.this.length();
                }
                FetchOnBufferReadJdbcIndexInput.this.bufferLength = (int)(end - start);
                if (FetchOnBufferReadJdbcIndexInput.this.bufferLength <= 0) {
                    throw new IOException("read past EOF");
                }
                if (FetchOnBufferReadJdbcIndexInput.this.buffer == null) {
                    FetchOnBufferReadJdbcIndexInput.access$902(FetchOnBufferReadJdbcIndexInput.this, new byte[FetchOnBufferReadJdbcIndexInput.this.bufferSize]);
                }
                Blob blob = rs.getBlob(2);
                FetchOnBufferReadJdbcIndexInput.this.readInternal(blob, FetchOnBufferReadJdbcIndexInput.this.buffer, 0, FetchOnBufferReadJdbcIndexInput.this.bufferLength);
                FetchOnBufferReadJdbcIndexInput.this.bufferStart = start;
                FetchOnBufferReadJdbcIndexInput.this.bufferPosition = 0;
                return null;
            }
        });
    }

    protected synchronized void readInternal(final byte[] b, final int offset, final int length) throws IOException {
        this.jdbcDirectory.getJdbcTemplate().executeSelect(this.jdbcDirectory.getTable().sqlSelectSizeValueByName(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, FetchOnBufferReadJdbcIndexInput.this.name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    throw new JdbcStoreException("No entry for [" + FetchOnBufferReadJdbcIndexInput.this.name + "] table " + FetchOnBufferReadJdbcIndexInput.this.jdbcDirectory.getTable());
                }
                Blob blob = rs.getBlob(2);
                FetchOnBufferReadJdbcIndexInput.this.readInternal(blob, b, offset, length);
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (FetchOnBufferReadJdbcIndexInput.this.totalLength == -1L) {
                        FetchOnBufferReadJdbcIndexInput.this.totalLength = rs.getLong(3);
                    }
                }
                return null;
            }
        });
    }

    private synchronized void readInternal(Blob blob, byte[] b, int offset, int length) throws Exception {
        byte[] bytesRead;
        long curPos = this.getFilePointer();
        if (curPos + 1L != this.position) {
            this.position = curPos + 1L;
        }
        if ((bytesRead = blob.getBytes(this.position, length)).length != length) {
            throw new IOException("read past EOF");
        }
        System.arraycopy(bytesRead, 0, b, offset, length);
        this.position += (long)bytesRead.length;
    }

    protected void seekInternal(long pos) throws IOException {
        this.position = pos + 1L;
    }

    public void close() throws IOException {
    }

    public synchronized long length() {
        if (this.totalLength == -1L) {
            try {
                this.totalLength = this.jdbcDirectory.fileLength(this.name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.totalLength;
    }

    static /* synthetic */ byte[] access$902(FetchOnBufferReadJdbcIndexInput x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

