/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CompassMultiReader;
import org.apache.lucene.index.CompassSegmentReader;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TransLog;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public class TransIndex {
    private Directory directory;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private Lock writeLock;
    private boolean closeDir;
    private PrintStream infoStream = null;
    private static final Log log = LogFactory.getLog((Class)TransIndex.class);
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private TransLog transLog;
    private Directory transDir;
    private SegmentInfos transSegmentInfos;
    private ArrayList transCreates;
    private ArrayList transReaders;
    private String newSegmentName;
    private Vector filesToDeleteCS;
    private LuceneSettings luceneSettings;

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public TransIndex(String subIndex, Directory dir, TransLog transLog, LuceneSettings luceneSettings) throws IOException {
        this(dir, false, false, luceneSettings);
        this.transLog = transLog;
        this.transDir = transLog.getDirectory();
        this.transCreates = new ArrayList();
        this.transReaders = new ArrayList();
        this.transSegmentInfos = new SegmentInfos();
        this.transSegmentInfos.write(this.transDir);
        if (this.segmentInfos.size() == 1) {
            this.indexReader = SegmentReader.get((SegmentInfos)this.segmentInfos, (SegmentInfo)this.segmentInfos.info(0), (boolean)false);
            ((CompassSegmentReader)this.indexReader).setSubIndex(subIndex);
        } else {
            IndexReader[] readers = new IndexReader[this.segmentInfos.size()];
            for (int i = 0; i < this.segmentInfos.size(); ++i) {
                readers[i] = SegmentReader.get((SegmentInfo)this.segmentInfos.info(i));
            }
            this.indexReader = new CompassMultiReader(subIndex, this.directory, this.segmentInfos, false, readers);
        }
        this.indexSearcher = new IndexSearcher(this.indexReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransIndex(Directory d, final boolean create, boolean closeDir, LuceneSettings luceneSettings) throws IOException {
        this.luceneSettings = luceneSettings;
        this.closeDir = closeDir;
        this.directory = d;
        Lock writeLock = this.directory.makeLock("write.lock");
        if (!writeLock.obtain(luceneSettings.getTransactionLockTimout())) {
            throw new IOException("Lock obtain failed: " + writeLock);
        }
        this.writeLock = writeLock;
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock"), luceneSettings.getTransactionCommitTimeout()){

                public Object doBody() throws IOException {
                    if (create) {
                        TransIndex.this.segmentInfos.write(TransIndex.this.directory);
                    } else {
                        TransIndex.this.segmentInfos.read(TransIndex.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public void addResource(InternalResource resource, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.transDir, analyzer, this.similarity, this.luceneSettings.getMaxFieldLength());
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newTransSegmentName();
        dw.addDocument(segmentName, ((LuceneResource)resource).getDocument());
        SegmentInfo segmentInfo = new SegmentInfo(segmentName, 1, this.transDir);
        this.transSegmentInfos.addElement((Object)segmentInfo);
        if (this.transLog.shouldUpdateTransSegments()) {
            this.transSegmentInfos.write(this.transDir);
        }
        this.transLog.onDocumentAdded();
        this.transReaders.add(SegmentReader.get((SegmentInfo)segmentInfo));
        this.transCreates.add(resource.resourceKey());
        ((LuceneResource)resource).setDocNum(this.indexReader.maxDoc() + this.transCreates.size() - 1);
    }

    private final String newTransSegmentName() {
        return "_" + Integer.toString(this.transSegmentInfos.counter++, 36);
    }

    private final String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public void deleteTransResource(ResourceKey resourceKey) throws IOException {
        int i = this.transCreates.indexOf(resourceKey);
        if (i != -1) {
            this.transSegmentInfos.removeElementAt(i);
            this.transCreates.remove(i);
            IndexReader indexReader = (IndexReader)this.transReaders.remove(i);
            try {
                indexReader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.transLog.shouldUpdateTransSegments()) {
                this.transSegmentInfos.write(this.transDir);
            }
        }
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public Searcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReader[] getFullIndexReaderAsArray() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return new IndexReader[]{this.indexReader};
        }
        IndexReader[] readers = new IndexReader[1 + this.transReaders.size()];
        readers[0] = this.indexReader;
        for (int i = 1; i < readers.length; ++i) {
            readers[i] = (IndexReader)this.transReaders.get(i - 1);
        }
        return readers;
    }

    public IndexReader getFullIndexReader() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return this.indexReader;
        }
        IndexReader[] readers = this.getFullIndexReaderAsArray();
        return new MultiReader(readers);
    }

    public Searcher getFullIndexSearcher() throws IOException {
        return new MultiSearcher((Searchable[])this.getFullIndexSearcherAsArray());
    }

    public Searcher[] getFullIndexSearcherAsArray() throws IOException {
        if (this.transSegmentInfos.size() == 0) {
            return new Searcher[]{this.indexSearcher};
        }
        IndexReader[] transReadersArr = this.transReaders.toArray(new IndexReader[this.transReaders.size()]);
        MultiReader transReader = new MultiReader(this.transDir, this.transSegmentInfos, false, transReadersArr);
        IndexSearcher transSearcher = new IndexSearcher((IndexReader)transReader);
        return new Searcher[]{this.indexSearcher, transSearcher};
    }

    public void firstPhase() throws IOException {
        this.newSegmentName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this.directory, this.newSegmentName);
        for (int i = 0; i < this.transReaders.size(); ++i) {
            merger.add((IndexReader)this.transReaders.get(i));
        }
        int mergedDocCount = merger.merge();
        if (this.infoStream != null) {
            this.infoStream.println(" into " + this.newSegmentName + " (" + mergedDocCount + " docs)");
        }
        merger.closeReaders();
        this.segmentInfos.addElement((Object)new SegmentInfo(this.newSegmentName, mergedDocCount, this.directory));
        if (this.luceneSettings.isUseCompoundFile()) {
            this.filesToDeleteCS = merger.createCompoundFile(this.newSegmentName + ".tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secondPhase() throws IOException {
        if (this.newSegmentName == null) {
            throw new IOException("Transaction not called first phase");
        }
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock"), this.luceneSettings.getTransactionCommitTimeout()){

                public Object doBody() throws IOException {
                    if (TransIndex.this.luceneSettings.isUseCompoundFile()) {
                        TransIndex.this.directory.renameFile(TransIndex.this.newSegmentName + ".tmp", TransIndex.this.newSegmentName + ".cfs");
                    }
                    TransIndex.this.indexSearcher.close();
                    TransIndex.this.indexSearcher = null;
                    TransIndex.this.indexReader.close();
                    TransIndex.this.indexReader = null;
                    TransIndex.this.segmentInfos.write(TransIndex.this.directory);
                    return null;
                }
            }.run();
        }
        if (this.luceneSettings.isUseCompoundFile()) {
            LuceneUtils.deleteFiles(this.filesToDeleteCS, this.directory);
            this.filesToDeleteCS = null;
        }
    }

    public void rollback() throws IOException {
        if (this.newSegmentName == null) {
            return;
        }
        String[] files = this.directory.list();
        String segmentPrefix = this.newSegmentName + ".";
        Vector<String> vFilesToDelete = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!fileName.startsWith(segmentPrefix)) continue;
            vFilesToDelete.add(fileName);
        }
        LuceneUtils.deleteFiles(vFilesToDelete, this.directory);
    }

    public void close() throws IOException {
        this.transCreates.clear();
        for (int i = 0; i < this.transReaders.size(); ++i) {
            try {
                ((IndexReader)this.transReaders.get(i)).close();
                continue;
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close transaction index readers, ignoring", (Throwable)ex);
            }
        }
        this.transReaders.clear();
        try {
            this.transLog.close();
            this.transDir = null;
        }
        catch (IOException ex) {
            log.warn((Object)"Failed to close transactional directory, ignoring", (Throwable)ex);
        }
        if (this.closeDir) {
            try {
                this.directory.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close directory, ignoring", (Throwable)ex);
            }
            this.directory = null;
        }
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }
}

