/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class DualCompoundFileWriter {
    private Directory src;
    private Directory dest;
    private byte[] buffer;
    private String fileName;
    private HashSet ids;
    private LinkedList entries;
    private boolean merged = false;

    public DualCompoundFileWriter(Directory src, Directory dest, String name, byte[] buffer) {
        if (src == null) {
            throw new NullPointerException("src cannot be null");
        }
        if (dest == null) {
            throw new NullPointerException("dest cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.src = src;
        this.dest = dest;
        this.buffer = buffer;
        this.fileName = name;
        this.ids = new HashSet();
        this.entries = new LinkedList();
    }

    public String getName() {
        return this.fileName;
    }

    public void addFile(String file) {
        if (this.merged) {
            throw new IllegalStateException("Can't add extensions after merge has been called");
        }
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (!this.ids.add(file)) {
            throw new IllegalArgumentException("File " + file + " already added");
        }
        FileEntry entry = new FileEntry();
        entry.file = file;
        this.entries.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.merged) {
            throw new IllegalStateException("Merge already performed");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("No entries to merge have been defined");
        }
        this.merged = true;
        IndexOutput os = null;
        try {
            FileEntry fe;
            os = this.dest.createOutput(this.fileName);
            os.writeVInt(this.entries.size());
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                fe = (FileEntry)it.next();
                fe.directoryOffset = os.getFilePointer();
                os.writeLong(0L);
                os.writeString(fe.file);
            }
            it = this.entries.iterator();
            while (it.hasNext()) {
                fe = (FileEntry)it.next();
                fe.dataOffset = os.getFilePointer();
                this.copyFile(fe, os, this.buffer);
            }
            it = this.entries.iterator();
            while (it.hasNext()) {
                fe = (FileEntry)it.next();
                os.seek(fe.directoryOffset);
                os.writeLong(fe.dataOffset);
            }
            IndexOutput tmp = os;
            os = null;
            tmp.close();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileEntry source, IndexOutput os, byte[] buffer) throws IOException {
        IndexInput is = null;
        try {
            long length;
            long remainder;
            int len;
            long startPtr = os.getFilePointer();
            is = this.src.openInput(source.file);
            int chunk = buffer.length;
            for (remainder = length = is.length(); remainder > 0L; remainder -= (long)len) {
                len = (int)Math.min((long)chunk, remainder);
                is.readBytes(buffer, 0, len);
                os.writeBytes(buffer, len);
            }
            if (remainder != 0L) {
                throw new IOException("Non-zero remainder length after copying: " + remainder + " (id: " + source.file + ", length: " + length + ", buffer size: " + chunk + ")");
            }
            long endPtr = os.getFilePointer();
            long diff = endPtr - startPtr;
            if (diff != length) {
                throw new IOException("Difference in the output file offsets " + diff + " does not match the original file length " + length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static final class FileEntry {
        String file;
        long directoryOffset;
        long dataOffset;

        private FileEntry() {
        }
    }
}

