/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.server.AbstractMessageHandler;
import org.subethamail.smtp.server.io.DeferredFileOutputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerAdapter
implements MessageHandlerFactory {
    private static int DEFAULT_DATA_DEFERRED_SIZE = 0x500000;
    private Collection<MessageListener> listeners;
    private int dataDeferredSize;

    public MessageListenerAdapter(Collection<MessageListener> listeners) {
        this(listeners, DEFAULT_DATA_DEFERRED_SIZE);
    }

    public MessageListenerAdapter(Collection<MessageListener> listeners, int dataDeferredSize) {
        this.listeners = listeners;
        this.dataDeferredSize = dataDeferredSize;
    }

    @Override
    public MessageHandler create(MessageContext ctx) {
        return new Handler(ctx);
    }

    class Handler
    extends AbstractMessageHandler {
        MessageContext ctx;
        String from;
        List<Delivery> deliveries = new ArrayList<Delivery>();

        public Handler(MessageContext ctx) {
            this.ctx = ctx;
        }

        public void from(String from) throws RejectException {
            this.from = from;
        }

        public void recipient(String recipient) throws RejectException {
            boolean addedListener = false;
            Iterator i$ = MessageListenerAdapter.this.listeners.iterator();
            while (i$.hasNext()) {
                MessageListener listener = (MessageListener)i$.next();
                if (!listener.accept(this.from, recipient)) continue;
                this.deliveries.add(new Delivery(listener, recipient));
                addedListener = true;
            }
            if (!addedListener) {
                throw new RejectException(553, "<" + recipient + "> address unknown.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void data(InputStream data) throws TooMuchDataException, IOException {
            if (this.deliveries.size() == 1) {
                Delivery delivery = this.deliveries.get(0);
                delivery.getListener().deliver(this.from, delivery.getRecipient(), data);
            } else {
                DeferredFileOutputStream dfos = new DeferredFileOutputStream(MessageListenerAdapter.this.dataDeferredSize);
                try {
                    int value;
                    while ((value = data.read()) >= 0) {
                        dfos.write(value);
                    }
                    Iterator<Delivery> i$ = this.deliveries.iterator();
                    while (i$.hasNext()) {
                        Delivery delivery = i$.next();
                        delivery.getListener().deliver(this.from, delivery.getRecipient(), dfos.getInputStream());
                    }
                }
                finally {
                    dfos.close();
                }
            }
        }
    }

    static class Delivery {
        MessageListener listener;
        String recipient;

        public MessageListener getListener() {
            return this.listener;
        }

        public String getRecipient() {
            return this.recipient;
        }

        public Delivery(MessageListener listener, String recipient) {
            this.listener = listener;
            this.recipient = recipient;
        }
    }
}

