/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;

public class StartTLSCommand
extends BaseCommand {
    private static Log log = LogFactory.getLog((Class)(class$org$subethamail$smtp$command$StartTLSCommand == null ? (class$org$subethamail$smtp$command$StartTLSCommand = StartTLSCommand.class$("org.subethamail.smtp.command.StartTLSCommand")) : class$org$subethamail$smtp$command$StartTLSCommand));
    private static final /* synthetic */ Class class$org$subethamail$smtp$command$StartTLSCommand;

    public StartTLSCommand() {
        super("STARTTLS", "The starttls command");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        if (!commandString.trim().toUpperCase().equals(this.getName())) {
            context.sendResponse("501 Syntax error (no parameters allowed)");
            return;
        }
        try {
            Socket socket = context.getConnection().getSocket();
            if (socket instanceof SSLSocket) {
                context.sendResponse("454 TLS not available due to temporary reason: TLS already active");
                return;
            }
            context.sendResponse("220 Ready to start TLS");
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
            s.setUseClientMode(false);
            s.setEnabledCipherSuites(s.getSupportedCipherSuites());
            s.startHandshake();
            context.getConnection().setSocket(s);
            context.getSession().reset();
        }
        catch (IOException e) {
            log.warn((Object)("startTLS() failed: " + e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

