/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.OOoContentHandler;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OpenOfficeTextFilter
implements TextFilter {
    private XMLReader xmlReader;

    public boolean canFilter(String mimeType) {
        return "application/vnd.oasis.opendocument.database".equalsIgnoreCase(mimeType) || "application/vnd.oasis.opendocument.formula".equalsIgnoreCase(mimeType) || "application/vnd.oasis.opendocument.graphics".equalsIgnoreCase(mimeType) || "application/vnd.oasis.opendocument.presentation".equalsIgnoreCase(mimeType) || "application/vnd.oasis.opendocument.spreadsheet".equalsIgnoreCase(mimeType) || "application/vnd.oasis.opendocument.text".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values;
        if (this.xmlReader == null) {
            this.initParser();
        }
        if ((values = data.getValues()).length > 0) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initializeReader() throws IOException {
                    InputStream in;
                    try {
                        in = blob.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                    try {
                        ZipInputStream zis = new ZipInputStream(in);
                        ZipEntry ze = zis.getNextEntry();
                        while (!ze.getName().equals("content.xml")) {
                            ze = zis.getNextEntry();
                        }
                        OOoContentHandler contentHandler = new OOoContentHandler();
                        OpenOfficeTextFilter.this.xmlReader.setContentHandler(contentHandler);
                        try {
                            OpenOfficeTextFilter.this.xmlReader.parse(new InputSource(zis));
                        }
                        catch (SAXException e) {
                            throw new IOException(e.getMessage());
                        }
                        finally {
                            zis.close();
                        }
                        this.delegate = new StringReader(contentHandler.getContent());
                    }
                    finally {
                        in.close();
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    private void initParser() throws RepositoryException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.xmlReader = saxParser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            this.xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

