/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MsExcelTextFilter
implements TextFilter {
    public boolean canFilter(String mimeType) {
        return "application/vnd.ms-excel".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length > 0) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initializeReader() throws IOException {
                    InputStream in;
                    CharArrayWriter writer = new CharArrayWriter();
                    try {
                        in = blob.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                    try {
                        POIFSFileSystem fs = new POIFSFileSystem(in);
                        HSSFWorkbook workbook = new HSSFWorkbook(fs);
                        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                            HSSFSheet sheet = workbook.getSheetAt(i);
                            Iterator rows = sheet.rowIterator();
                            while (rows.hasNext()) {
                                HSSFRow row = (HSSFRow)rows.next();
                                Iterator cells = row.cellIterator();
                                while (cells.hasNext()) {
                                    HSSFCell cell = (HSSFCell)cells.next();
                                    switch (cell.getCellType()) {
                                        case 0: {
                                            String num = Double.toString(cell.getNumericCellValue()).trim();
                                            if (num.length() <= 0) break;
                                            writer.write(num + " ");
                                            break;
                                        }
                                        case 1: {
                                            String text = cell.getStringCellValue().trim();
                                            if (text.length() <= 0) break;
                                            writer.write(text + " ");
                                        }
                                    }
                                }
                            }
                        }
                        this.delegate = new CharArrayReader(writer.toCharArray());
                    }
                    finally {
                        in.close();
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    static {
        POIFSFileSystem.class.getName();
    }
}

