/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger((Class)LazyReader.class);
    private static final Reader NULL_READER = new Reader(){

        public void close() {
        }

        public int read(char[] cbuf, int off, int len) {
            return -1;
        }
    };
    protected Reader delegate;

    protected abstract void initializeReader() throws IOException;

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.delegate == null) {
            try {
                this.initializeReader();
            }
            catch (Throwable t) {
                log.warn("exception initializing reader " + this.getClass().getName() + ": " + t);
                log.debug("Dump: ", t);
                this.delegate = NULL_READER;
            }
        }
        if (this.delegate == null) {
            this.delegate = NULL_READER;
        }
        return this.delegate.read(cbuf, off, len);
    }
}

