/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.jackrabbit.core.query.HTMLParser;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLTextFilter
implements TextFilter {
    private HTMLParser parser;
    private SAXResult result;
    private Transformer transformer;

    public boolean canFilter(String mimeType) {
        return "text/html".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values;
        if (this.parser == null) {
            this.initParser();
        }
        if ((values = data.getValues()).length > 0) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                protected void initializeReader() throws IOException {
                    InputStream in;
                    try {
                        in = blob.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                    try {
                        SAXSource source = new SAXSource((XMLReader)((Object)HTMLTextFilter.this.parser), new InputSource(in));
                        HTMLTextFilter.this.transformer.transform(source, HTMLTextFilter.this.result);
                        String text = HTMLTextFilter.this.parser.getContents();
                        this.delegate = new StringReader(text);
                    }
                    catch (TransformerException e) {
                        throw new IOException(e.getMessage());
                    }
                    finally {
                        in.close();
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    private void initParser() throws RepositoryException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.transformer = factory.newTransformer();
            this.parser = new HTMLParser();
            this.result = new SAXResult(new DefaultHandler());
        }
        catch (TransformerConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

