/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.applets.hangman;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Hangman
extends Applet
implements KeyListener {
    private static final int MEDIA_TRACKER_HANG = 0;
    private static final int MEDIA_TRACKER_DANCE = 1;
    private static final int TOTAL_IMAGES_HANG = 5;
    private static final int TOTAL_IMAGES_DANCE = 5;
    private static final int HANG_WIDTH = 42;
    private static final int HANG_HEIGHT = 64;
    private static final int DANCE_WIDTH = 100;
    private static final int DANCE_HEIGHT = 80;
    private static final int[] DANCE_STEP = new int[]{12, 28, 8, -6, -20, 12, -10, -6, -10, -20, 8, 8, 12, -8, -4};
    private MediaTracker _tracker;
    private AudioClip _danceMusic;
    private Image[] _danceImages;
    private Image[] _hangImages;
    private Thread _danceThread;
    private int _danceIndex;
    private int _danceY;
    private int _danceX;
    private int _danceXLo;
    private int _danceXHi;
    private List _wordList;
    private int _wordIndex;
    private String _rightGuess;
    private String _wrongGuess;
    private int _guessLength;
    private Font _wrongFont;
    private FontMetrics _wrongMetrics;
    private Font _rightFont;
    private FontMetrics _rightMetrics;

    public void init() {
        this._initValues();
        this._buildWordList();
        this._loadResources();
        this.addKeyListener(this);
        this._newGame();
    }

    public void paint(Graphics g) {
        g.setColor(new Color(128, 64, 0));
        g.fillRect(10, 138, 45, 3);
        g.fillRect(31, 10, 3, 128);
        g.fillRect(31, 10, 42, 3);
        g.fillRect(72, 10, 3, 22);
        if (this._wrongGuess.length() != 0) {
            g.drawImage(this._hangImages[this._wrongGuess.length() - 1], 52, 21, this);
            g.setColor(Color.RED);
            g.setFont(this._wrongFont);
            g.drawChars(this._wrongGuess.toUpperCase().toCharArray(), 0, this._wrongGuess.length(), 84, this._wrongMetrics.getHeight() + 1);
        }
        g.setColor(Color.BLACK);
        g.setFont(this._rightFont);
        int width = this._rightMetrics.charWidth(' ');
        char[] wordChars = this._getWord().toCharArray();
        int i = 0;
        while (i < wordChars.length) {
            if (wordChars[i] != ' ') {
                g.drawLine(84 + 2 * i * width + 1, 129, 84 + 2 * (i + 1) * width - 1, 129);
                if (this._gameOver() || this._rightGuess.indexOf(wordChars[i]) != -1) {
                    g.drawChars(this._getWord().toUpperCase().toCharArray(), i, 1, 84 + 2 * i * width + width / 2, 128);
                }
            }
            ++i;
        }
        g.clearRect(this._danceX, this._danceY, 100, 80);
        if (this._danceIndex != -1) {
            this._danceX += DANCE_STEP[this._danceIndex % DANCE_STEP.length];
            this._danceX = Math.max(this._danceX, this._danceXLo);
            this._danceX = Math.min(this._danceX, this._danceXHi);
            g.drawImage(this._danceImages[this._danceIndex % 5], this._danceX, this._danceY, this);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (!this._gameOver()) {
            if (key < 'a' || key > 'z' || this._rightGuess.indexOf(key) != -1 || this._wrongGuess.indexOf(key) != -1) {
                this.play(this.getCodeBase(), "audio/ding.au");
            } else {
                Character letter = new Character(key);
                if (this._getWord().indexOf(key) != -1) {
                    this._rightGuess = this._rightGuess + letter;
                    int i = 0;
                    while (i < this._getWord().length()) {
                        if (this._getWord().charAt(i) == key) {
                            ++this._guessLength;
                        }
                        ++i;
                    }
                    if (this._guessLength == this._getWord().length()) {
                        this.play(this.getCodeBase(), "audio/whoopy.au");
                        this._startDance();
                    } else {
                        this.play(this.getCodeBase(), "audio/ah.au");
                    }
                } else {
                    this._wrongGuess = this._wrongGuess + letter;
                    if (this._wrongGuess.length() < 5) {
                        this.play(this.getCodeBase(), "audio/ooh.au");
                    } else {
                        this.play(this.getCodeBase(), "audio/scream.au");
                    }
                }
            }
            this.repaint();
        } else {
            this._stopDance();
            this._newGame();
        }
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
    }

    private final void _initValues() {
        this._tracker = new MediaTracker(this);
        this._danceImages = new Image[5];
        this._hangImages = new Image[5];
        this._danceIndex = -1;
        this._danceY = 32;
        this._danceXLo = 84;
        this._danceX = 84;
        this._danceXHi = Math.min(284, this.getWidth() - 100);
        this._wordList = new ArrayList();
        this._wrongFont = new Font("MONOSPACED", 1, 16);
        this._wrongMetrics = this.getFontMetrics(this._wrongFont);
        this._rightFont = new Font("MONOSPACED", 0, 14);
        this._rightMetrics = this.getFontMetrics(this._rightFont);
    }

    private final void _buildWordList() {
        String paramWords = this.getParameter("word_list");
        if (paramWords != null) {
            StringTokenizer st = new StringTokenizer(paramWords, ",");
            while (st.hasMoreTokens()) {
                boolean skip = false;
                String token = st.nextToken().trim();
                int i = 0;
                while (i < token.length()) {
                    char c = token.charAt(i);
                    if ((c < 'a' || c > 'z') && c != ' ') {
                        skip = true;
                        break;
                    }
                    ++i;
                }
                if (!skip) {
                    this._wordList.add(token);
                    continue;
                }
                System.err.println("Token '" + token + "' contains invalid characters");
            }
        }
        if (this._wordList.isEmpty()) {
            this._wordList.add("liferay");
            this._wordList.add("open source");
            this._wordList.add("enterprise");
            this._wordList.add("for life");
        }
    }

    private final void _loadResources() {
        Image img;
        int i = 0;
        while (i < 5) {
            img = this.getImage(this.getCodeBase(), "images/hanging/h" + (i + 1) + ".gif");
            this._tracker.addImage(img, 0);
            this._hangImages[i] = img;
            ++i;
        }
        i = 0;
        while (i < 5) {
            img = this.getImage(this.getCodeBase(), "images/dancing/d" + (i + 1) + ".gif");
            this._tracker.addImage(img, 1);
            this._danceImages[i] = img;
            ++i;
        }
        this._danceMusic = this.getAudioClip(this.getCodeBase(), "audio/dance.au");
    }

    private final void _newGame() {
        try {
            this._tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this._tracker.checkAll(true);
        this._rightGuess = new String();
        this._wrongGuess = new String();
        this._wordIndex = (int)(Math.random() * 100.0) % this._wordList.size();
        this._guessLength = 0;
        String word = this._getWord();
        int i = 0;
        while (i < word.length()) {
            if (word.charAt(i) == ' ') {
                ++this._guessLength;
            }
            ++i;
        }
        this.repaint();
    }

    private final boolean _gameOver() {
        boolean bl = false;
        if (this._guessLength == this._getWord().length() || this._wrongGuess.length() == 5) {
            bl = true;
        }
        return bl;
    }

    private final String _getWord() {
        return (String)this._wordList.get(this._wordIndex);
    }

    private final void _startDance() {
        this._danceThread = new DanceThread();
        this._danceThread.start();
    }

    private final void _stopDance() {
        if (this._danceThread != null) {
            this._danceThread.interrupt();
            this._danceThread = null;
        }
    }

    static /* synthetic */ int access$7() {
        return 1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DanceThread
    extends Thread {
        public void run() {
            Hangman.this._danceX = Hangman.this._danceXLo;
            Hangman hangman = Hangman.this;
            hangman._danceX = hangman._danceX + (int)(Math.random() * 100.0) % (Hangman.this._danceXHi - Hangman.this._danceXLo);
            Hangman.this._danceIndex = 0;
            Hangman.this._danceMusic.loop();
            try {
                Hangman.this._tracker.waitForID(1);
                while (true) {
                    Hangman hangman2 = Hangman.this;
                    hangman2._danceIndex = hangman2._danceIndex + 1;
                    Hangman.this.repaint();
                    DanceThread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                Hangman.this._danceIndex = -1;
                Hangman.this._danceMusic.stop();
                Hangman.this.repaint();
                return;
            }
        }

        private DanceThread() {
        }
    }
}

