/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousResultSetNode;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousResultSetNode;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetColumnChecker;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultSetsChecker {
    private final DataSetDesign setDesign;
    private final Iterator setDefinedResultsIter;
    private final Iterator columnHintsIter;

    ResultSetsChecker(DataSetDesign setDesign, OdaDataSetHandle setHandle) {
        this.setDesign = setDesign;
        this.setDefinedResultsIter = setHandle.resultSetIterator();
        this.columnHintsIter = setHandle.columnHintsIterator();
    }

    List<IAmbiguousResultSetNode> process() {
        ResultSetDefinition resultDefn = this.setDesign.getPrimaryResultSet();
        if (resultDefn == null) {
            ResultSets resultSets = this.setDesign.getResultSets();
            if (resultSets == null) {
                return Collections.emptyList();
            }
            EList definitions = resultSets.getResultSetDefinitions();
            if (definitions.isEmpty()) {
                return Collections.emptyList();
            }
            resultDefn = (ResultSetDefinition)definitions.get(0);
        }
        assert (resultDefn != null);
        ResultSetColumns setColumns = resultDefn.getResultSetColumns();
        if (setColumns == null) {
            return Collections.emptyList();
        }
        EList odaSetColumns = setColumns.getResultColumnDefinitions();
        if (odaSetColumns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IAmbiguousResultSetNode> ambiguousResultSets = new ArrayList<IAmbiguousResultSetNode>(4);
        int i = 0;
        while (i < odaSetColumns.size()) {
            ColumnHintHandle existingColumnHintHandle;
            ResultSetColumnChecker oneChecker;
            List<IAmbiguousAttribute> attrs;
            ColumnDefinition columnDefn = (ColumnDefinition)odaSetColumns.get(i);
            ResultSetColumnHandle existingColumnHandle = null;
            DataElementAttributes dataAttrs = columnDefn.getAttributes();
            if (dataAttrs != null) {
                String nativeName = dataAttrs.getName();
                Integer position = dataAttrs.getPosition();
                Integer nativeDataType = dataAttrs.getNativeDataTypeCode();
                existingColumnHandle = ResultSetsAdapter.findOdaResultSetColumn(this.setDefinedResultsIter, nativeName, position, nativeDataType);
            }
            if (existingColumnHandle != null && (attrs = (oneChecker = new ResultSetColumnChecker(columnDefn, (OdaResultSetColumnHandle)existingColumnHandle, existingColumnHintHandle = AdapterUtil.findColumnHint(existingColumnHandle.getColumnName(), this.columnHintsIter))).process()) != null && !attrs.isEmpty()) {
                AmbiguousResultSetNode node = new AmbiguousResultSetNode((OdaResultSetColumnHandle)existingColumnHandle, attrs);
                ambiguousResultSets.add(node);
            }
            ++i;
        }
        return ambiguousResultSets;
    }
}

