/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.SimpleRandomAccessObject;

public class DirectoryDocumentManager
implements IDocumentManager {
    private String documentDir = null;

    public DirectoryDocumentManager(String documentDir, boolean deleteOld) throws DataException {
        this.documentDir = documentDir;
        File dir = new File(documentDir);
        if (!(FileSecurity.fileExist(dir) && FileSecurity.fileIsDirectory(dir) || FileSecurity.fileMakeDirs(dir))) {
            throw new DataException("data.olap.OlapDirCreateFail", documentDir);
        }
        if (deleteOld) {
            File[] oldFiles = FileSecurity.fileListFiles(dir);
            int i = 0;
            while (i < oldFiles.length) {
                FileSecurity.fileDelete(oldFiles[i]);
                ++i;
            }
        }
    }

    public void close() throws IOException {
    }

    public IDocumentObject createDocumentObject(String documentObjectName) throws IOException {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        if (FileSecurity.fileExist(file)) {
            return null;
        }
        if (!FileSecurity.createNewFile(file)) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
    }

    public IDocumentObject openDocumentObject(String documentObjectName) throws IOException {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        if (!FileSecurity.fileExist(file)) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
    }

    public boolean exist(String documentObjectName) {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        return FileSecurity.fileExist(file);
    }

    public void flush() throws IOException {
    }
}

