/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.xml.sax.SAXException;

public class FacesConfigurator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$config$FacesConfigurator == null ? (class$org$apache$myfaces$config$FacesConfigurator = FacesConfigurator.class$("org.apache.myfaces.config.FacesConfigurator")) : class$org$apache$myfaces$config$FacesConfigurator));
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "org.apache.myfaces.resource".replace('.', '/') + "/standard-faces-config.xml";
    private static final String FACES_CONFIG_RESOURCE = "META-INF/faces-config.xml";
    private static final String META_INF_SERVICES_RESOURCE_PREFIX = "META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = (class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl == null ? (class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl = FacesConfigurator.class$("org.apache.myfaces.renderkit.html.HtmlRenderKitImpl")) : class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl).getName();
    private static final String DEFAULT_APPLICATION_FACTORY = (class$org$apache$myfaces$application$ApplicationFactoryImpl == null ? (class$org$apache$myfaces$application$ApplicationFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.application.ApplicationFactoryImpl")) : class$org$apache$myfaces$application$ApplicationFactoryImpl).getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = (class$org$apache$myfaces$context$FacesContextFactoryImpl == null ? (class$org$apache$myfaces$context$FacesContextFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.context.FacesContextFactoryImpl")) : class$org$apache$myfaces$context$FacesContextFactoryImpl).getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = (class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.lifecycle.LifecycleFactoryImpl")) : class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl).getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = (class$org$apache$myfaces$renderkit$RenderKitFactoryImpl == null ? (class$org$apache$myfaces$renderkit$RenderKitFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.renderkit.RenderKitFactoryImpl")) : class$org$apache$myfaces$renderkit$RenderKitFactoryImpl).getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set FACTORY_NAMES = new HashSet();
    private ExternalContext _externalContext;
    private FacesConfigUnmarshaller _unmarshaller;
    private FacesConfigDispenser _dispenser;
    private static final String JAR_EXTENSION = ".jar";
    private static final String META_INF_MANIFEST_SUFFIX = "!/META-INF/MANIFEST.MF";
    private static final String JAR_PREFIX = "jar:";
    public static final String MYFACES_API_PACKAGE_NAME = "myfaces-api";
    public static final String MYFACES_IMPL_PACKAGE_NAME = "myfaces-impl";
    public static final String MYFACES_TOMAHAWK_PACKAGE_NAME = "tomahawk";
    public static final String MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME = "tomahawk-sandbox";
    public static final String COMMONS_EL_PACKAGE_NAME = "commons-el";
    public static final String JSP_API_PACKAGE_NAME = "jsp-api";
    static /* synthetic */ Class class$org$apache$myfaces$config$FacesConfigurator;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl;
    static /* synthetic */ Class class$org$apache$myfaces$application$ApplicationFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$context$FacesContextFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$RenderKitFactoryImpl;
    static /* synthetic */ Class class$javax$faces$event$ActionListener;
    static /* synthetic */ Class class$javax$faces$application$NavigationHandler;
    static /* synthetic */ Class class$javax$faces$el$PropertyResolver;
    static /* synthetic */ Class class$javax$faces$application$StateManager;
    static /* synthetic */ Class class$javax$faces$el$VariableResolver;
    static /* synthetic */ Class class$javax$faces$application$ViewHandler;

    public FacesConfigurator(ExternalContext externalContext) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        this._externalContext = externalContext;
    }

    public void configure() throws FacesException {
        this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        this._dispenser = new DigesterFacesConfigDispenserImpl();
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            this.feedClassloaderConfigurations();
            this.feedContextSpecifiedConfig();
            this.feedWebAppConfig();
            if (log.isInfoEnabled()) {
                this.logMetaInf();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
        if (stream == null) {
            throw new FacesException("Standard faces config " + STANDARD_FACES_CONFIG_RESOURCE + " not found");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading standard config " + STANDARD_FACES_CONFIG_RESOURCE));
        }
        this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
        stream.close();
    }

    protected void logMetaInf() {
        try {
            ArrayList<VersionInfo> li = new ArrayList<VersionInfo>();
            li.add(new VersionInfo(MYFACES_API_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_IMPL_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_PACKAGE_NAME));
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", this);
            while (it.hasNext()) {
                VersionInfo versionInfo;
                URL url = (URL)it.next();
                for (int i = 0; i < li.size() && !FacesConfigurator.checkJar(versionInfo = (VersionInfo)li.get(i), url); ++i) {
                }
            }
            for (int i = 0; i < li.size(); ++i) {
                VersionInfo versionInfo = (VersionInfo)li.get(i);
                if (versionInfo.getUsedVersion() != null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Starting up MyFaces-package : " + versionInfo.getPackageName() + " in version : " + versionInfo.getUsedVersion() + " from path : " + versionInfo.getUsedVersionPath()));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("MyFaces-package : " + versionInfo.getPackageName() + " not found."));
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private static boolean checkJar(VersionInfo versionInfo, URL path) {
        int index;
        String version = versionInfo.getLastVersion();
        String pathString = path.toString();
        if (!pathString.startsWith(JAR_PREFIX)) {
            return false;
        }
        if (pathString.length() <= META_INF_MANIFEST_SUFFIX.length() + JAR_PREFIX.length()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PathString : " + pathString + " not long enough to be parsed."));
            }
            return false;
        }
        File file = new File(pathString = pathString.substring(JAR_PREFIX.length(), pathString.length() - META_INF_MANIFEST_SUFFIX.length()));
        String fileName = file.getName();
        if (fileName.endsWith(JAR_EXTENSION) && (index = fileName.indexOf(versionInfo.getPackageName())) != -1) {
            int beginIndex = index + versionInfo.getPackageName().length() + 1;
            if (beginIndex > fileName.length() - 1) {
                log.debug((Object)("beginIndex out of bounds. fileName: " + fileName));
                return false;
            }
            int endIndex = fileName.length() - JAR_EXTENSION.length();
            if (endIndex < 0 || endIndex <= beginIndex) {
                log.debug((Object)("endIndex out of bounds. fileName: " + fileName));
                return false;
            }
            String newVersion = fileName.substring(beginIndex, endIndex);
            if (version == null) {
                versionInfo.addJarInfo(pathString, newVersion);
            } else if (version.equals(newVersion)) {
                versionInfo.addJarInfo(pathString, version);
            } else {
                log.error((Object)("You are using the MyFaces-package : " + versionInfo.getPackageName() + " in different versions; first (and probably used) version is : " + versionInfo.getUsedVersion() + ", currently encountered version is : " + newVersion + ". This will cause undesired behaviour. Please clean out your class-path." + " The first encountered version is loaded from : " + versionInfo.getUsedVersionPath() + ". The currently encountered version is loaded from : " + path));
            }
            return true;
        }
        return false;
    }

    protected void feedMetaInfServicesFactories() {
        try {
            Iterator iterator = FACTORY_NAMES.iterator();
            while (iterator.hasNext()) {
                String factoryName = (String)iterator.next();
                Iterator it = ClassUtils.getResources(META_INF_SERVICES_RESOURCE_PREFIX + factoryName, this);
                while (it.hasNext()) {
                    String className;
                    URL url = (URL)it.next();
                    InputStream stream = this.openStreamWithoutCache(url);
                    InputStreamReader isr = new InputStreamReader(stream);
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        className = br.readLine();
                    }
                    catch (IOException e) {
                        throw new FacesException("Unable to read class name from file " + url.toExternalForm(), (Throwable)e);
                    }
                    br.close();
                    isr.close();
                    stream.close();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found " + factoryName + " factory implementation: " + className));
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        this._dispenser.feedApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        this._dispenser.feedFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        this._dispenser.feedLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        this._dispenser.feedRenderKitFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private void feedClassloaderConfigurations() {
        try {
            Iterator it = ClassUtils.getResources(FACES_CONFIG_RESOURCE, this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                InputStream stream = this.openStreamWithoutCache(url);
                String systemId = url.toExternalForm();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading config " + systemId));
                }
                this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
                stream.close();
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private void feedContextSpecifiedConfig() throws IOException, SAXException {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                InputStream stream;
                String systemId = st.nextToken().trim();
                if (log.isWarnEnabled() && DEFAULT_FACES_CONFIG.equals(systemId)) {
                    log.warn((Object)"/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This should be removed, as it will be loaded twice.  See JSF spec 1.1, 10.3.2");
                }
                if ((stream = this._externalContext.getResourceAsStream(systemId)) == null) {
                    log.error((Object)("Faces config resource " + systemId + " not found"));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading config " + systemId));
                }
                this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
                stream.close();
            }
        }
    }

    private void feedWebAppConfig() throws IOException, SAXException {
        InputStream stream = this._externalContext.getResourceAsStream(DEFAULT_FACES_CONFIG);
        if (stream != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config /WEB-INF/faces-config.xml");
            }
            this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, DEFAULT_FACES_CONFIG));
            stream.close();
        }
    }

    private void configureFactories() {
        this.setFactories("javax.faces.application.ApplicationFactory", this._dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", this._dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", this._dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", this._dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
    }

    private void setFactories(String factoryName, Iterator factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        while (factories.hasNext()) {
            FactoryFinder.setFactory((String)factoryName, (String)((String)factories.next()));
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        application.setActionListener((ActionListener)this.getApplicationObject(class$javax$faces$event$ActionListener == null ? (class$javax$faces$event$ActionListener = FacesConfigurator.class$("javax.faces.event.ActionListener")) : class$javax$faces$event$ActionListener, this._dispenser.getActionListenerIterator(), null));
        if (this._dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(this._dispenser.getDefaultLocale()));
        }
        if (this._dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(this._dispenser.getDefaultRenderKitId());
        }
        if (this._dispenser.getMessageBundle() != null) {
            application.setMessageBundle(this._dispenser.getMessageBundle());
        }
        application.setNavigationHandler((NavigationHandler)this.getApplicationObject(class$javax$faces$application$NavigationHandler == null ? (class$javax$faces$application$NavigationHandler = FacesConfigurator.class$("javax.faces.application.NavigationHandler")) : class$javax$faces$application$NavigationHandler, this._dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setPropertyResolver((PropertyResolver)this.getApplicationObject(class$javax$faces$el$PropertyResolver == null ? (class$javax$faces$el$PropertyResolver = FacesConfigurator.class$("javax.faces.el.PropertyResolver")) : class$javax$faces$el$PropertyResolver, this._dispenser.getPropertyResolverIterator(), application.getPropertyResolver()));
        application.setStateManager((StateManager)this.getApplicationObject(class$javax$faces$application$StateManager == null ? (class$javax$faces$application$StateManager = FacesConfigurator.class$("javax.faces.application.StateManager")) : class$javax$faces$application$StateManager, this._dispenser.getStateManagerIterator(), application.getStateManager()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator it = this._dispenser.getSupportedLocalesIterator();
        while (it.hasNext()) {
            locales.add(LocaleUtils.toLocale((String)it.next()));
        }
        application.setSupportedLocales(locales);
        application.setVariableResolver((VariableResolver)this.getApplicationObject(class$javax$faces$el$VariableResolver == null ? (class$javax$faces$el$VariableResolver = FacesConfigurator.class$("javax.faces.el.VariableResolver")) : class$javax$faces$el$VariableResolver, this._dispenser.getVariableResolverIterator(), application.getVariableResolver()));
        application.setViewHandler((ViewHandler)this.getApplicationObject(class$javax$faces$application$ViewHandler == null ? (class$javax$faces$application$ViewHandler = FacesConfigurator.class$("javax.faces.application.ViewHandler")) : class$javax$faces$application$ViewHandler, this._dispenser.getViewHandlerIterator(), application.getViewHandler()));
        it = this._dispenser.getComponentTypes();
        while (it.hasNext()) {
            String componentType = (String)it.next();
            application.addComponent(componentType, this._dispenser.getComponentClass(componentType));
        }
        it = this._dispenser.getConverterIds();
        while (it.hasNext()) {
            String converterId = (String)it.next();
            application.addConverter(converterId, this._dispenser.getConverterClassById(converterId));
        }
        it = this._dispenser.getConverterClasses();
        while (it.hasNext()) {
            String converterClass = (String)it.next();
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), this._dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.error((Object)"Converter could not be added. Reason:", (Throwable)ex);
            }
        }
        if (application instanceof ApplicationImpl) {
            it = this._dispenser.getConverterConfigurationByClassName();
            while (it.hasNext()) {
                String converterClassName = (String)it.next();
                ((ApplicationImpl)application).addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
            }
        }
        it = this._dispenser.getValidatorIds();
        while (it.hasNext()) {
            String validatorId = (String)it.next();
            application.addValidator(validatorId, this._dispenser.getValidatorClass(validatorId));
        }
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                current = ClassUtils.newInstance(implClass);
            }
        }
        return current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        Iterator iterator = this._dispenser.getManagedBeans();
        while (iterator.hasNext()) {
            ManagedBean bean = (ManagedBean)iterator.next();
            ManagedBean oldBean = runtimeConfig.getManagedBean(bean.getManagedBeanName());
            if (log.isWarnEnabled() && oldBean != null) {
                log.warn((Object)("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' registered. First managed bean was registered in :" + oldBean.getConfigLocation() + ", new managed bean was registered in : " + bean.getConfigLocation() + ". The first definition of the managed-bean will be ignored by the standard MyFaces variable resolver!"));
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        iterator = this._dispenser.getNavigationRules();
        while (iterator.hasNext()) {
            NavigationRule rule = (NavigationRule)iterator.next();
            runtimeConfig.addNavigationRule(rule);
        }
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        Iterator iterator = this._dispenser.getRenderKitIds();
        while (iterator.hasNext()) {
            String renderKitId = (String)iterator.next();
            String renderKitClass = this._dispenser.getRenderKitClass(renderKitId);
            if (renderKitClass == null) {
                renderKitClass = DEFAULT_RENDER_KIT_CLASS;
            }
            RenderKit renderKit = (RenderKit)ClassUtils.newInstance(renderKitClass);
            Iterator renderers = this._dispenser.getRenderers(renderKitId);
            while (renderers.hasNext()) {
                javax.faces.render.Renderer renderer;
                Renderer element = (Renderer)renderers.next();
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.error((Object)("failed to configure class " + element.getRendererClass()), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        Iterator iterator = this._dispenser.getLifecyclePhaseListeners();
        while (iterator.hasNext()) {
            String listenerClassName = (String)iterator.next();
            try {
                lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName));
            }
            catch (ClassCastException e) {
                log.error((Object)("Class " + listenerClassName + " does not implement PhaseListener"));
            }
        }
    }

    private String getLifecycleId() {
        String id = this._externalContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id != null) {
            return id;
        }
        return "DEFAULT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.error((Object)("Make sure '" + serialProvider + "' implements the correct interface"), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.error((Object)"Using default serialization provider");
                }
            }
        }
        log.info((Object)("Serialization provider : " + serialFactory.getClass()));
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JarInfo {
        private String url;
        private String version;

        public JarInfo(String url, String version) {
            this.url = url;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class VersionInfo {
        private String packageName;
        private List jarInfos;

        public VersionInfo(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void addJarInfo(String path, String version) {
            if (this.jarInfos == null) {
                this.jarInfos = new ArrayList();
            }
            this.jarInfos.add(new JarInfo(path, version));
        }

        public String getLastVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(this.jarInfos.size() - 1)).getVersion();
        }

        public String getUsedVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(0)).getVersion();
        }

        public String getUsedVersionPath() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(0)).getUrl();
        }
    }
}

