/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.pss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.pss.TreeStructComponent;
import org.apache.myfaces.application.pss.UIViewRootWrapper;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class PartialTreeStructureManager {
    public static final String PARTIAL_STATE_CLASS_IDS = (class$org$apache$myfaces$application$pss$PartialTreeStructureManager == null ? (class$org$apache$myfaces$application$pss$PartialTreeStructureManager = PartialTreeStructureManager.class$("org.apache.myfaces.application.pss.PartialTreeStructureManager")) : class$org$apache$myfaces$application$pss$PartialTreeStructureManager).getName() + ".PARTIAL_STATE_MANAGER_COMPONENT_IDS";
    private FacesContext _facesContext = null;
    static /* synthetic */ Class class$org$apache$myfaces$application$pss$PartialTreeStructureManager;

    public PartialTreeStructureManager(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    public Object buildTreeStructureToSave(UIViewRoot viewRoot, FacesContext facesContext) {
        Object savedStateTree = viewRoot.processSaveState(facesContext);
        if (viewRoot instanceof UIViewRootWrapper) {
            return this.internalBuildInitalTreeStructureToSave((UIComponent)viewRoot, facesContext, savedStateTree, 0);
        }
        return this.internalBuildTreeStructureToSave((UIComponent)viewRoot, facesContext, savedStateTree, 0);
    }

    private TreeStructComponent internalBuildInitalTreeStructureToSave(UIComponent component, FacesContext facesContext, Object state, int childIndex) {
        Map facetMap;
        UIComponent child;
        Object myState = ((Object[])state)[0];
        Map facetStateMap = (Map)((Object[])state)[1];
        List childrenStateList = (List)((Object[])state)[2];
        TreeStructComponent structComp = new TreeStructComponent(this.convertStringToComponentClassId(facesContext, component.getClass().getName()), component.getId(), myState, component.isTransient());
        if (component.getChildCount() > 0) {
            List childList = component.getChildren();
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int len = childList.size();
            for (int i = 0; i < len; ++i) {
                TreeStructComponent structChild;
                child = (UIComponent)childList.get(i);
                if (!child.isTransient()) {
                    structChild = this.internalBuildInitalTreeStructureToSave(child, facesContext, childrenStateList != null ? childrenStateList.get(childIndex++) : null, 0);
                    structChildList.add(structChild);
                    continue;
                }
                child.setTransient(false);
                structChild = this.internalBuildInitalTreeStructureToSave(child, facesContext, child.processSaveState(facesContext), 0);
                structChildList.add(structChild);
                child.setTransient(true);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (!(facetMap = component.getFacets()).isEmpty()) {
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            Iterator it = facetMap.entrySet().iterator();
            while (it.hasNext()) {
                TreeStructComponent structChild;
                Map.Entry entry = it.next();
                child = (UIComponent)entry.getValue();
                String facetName = (String)entry.getKey();
                if (!child.isTransient()) {
                    structChild = this.internalBuildInitalTreeStructureToSave(child, facesContext, facetStateMap.get(facetName), 0);
                    structFacetList.add(new Object[]{facetName, structChild});
                    continue;
                }
                child.setTransient(false);
                structChild = this.internalBuildInitalTreeStructureToSave(child, facesContext, child.processSaveState(facesContext), 0);
                structFacetList.add(new Object[]{facetName, structChild});
                child.setTransient(true);
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    private TreeStructComponent internalBuildTreeStructureToSave(UIComponent component, FacesContext facesContext, Object state, int childIndex) {
        Map facetMap;
        UIComponent child;
        Object myState = ((Object[])state)[0];
        Map facetStateMap = (Map)((Object[])state)[1];
        List childrenStateList = (List)((Object[])state)[2];
        TreeStructComponent structComp = new TreeStructComponent(this.convertStringToComponentClassId(facesContext, component.getClass().getName()), component.getId(), myState, component.isTransient());
        if (component.getChildCount() > 0) {
            List childList = component.getChildren();
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int len = childList.size();
            for (int i = 0; i < len; ++i) {
                child = (UIComponent)childList.get(i);
                if (child.isTransient()) continue;
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child, facesContext, childrenStateList != null ? childrenStateList.get(childIndex++) : null, 0);
                structChildList.add(structChild);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (!(facetMap = component.getFacets()).isEmpty()) {
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            Iterator it = facetMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                child = (UIComponent)entry.getValue();
                String facetName = (String)entry.getKey();
                if (child.isTransient()) continue;
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child, facesContext, facetStateMap.get(facetName), 0);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    public UIViewRoot restoreTreeStructure(FacesContext facesContext, Object treeStructRoot) {
        if (treeStructRoot instanceof TreeStructComponent) {
            return (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)treeStructRoot, facesContext);
        }
        throw new IllegalArgumentException("TreeStructure of type " + treeStructRoot.getClass().getName() + " is not supported.");
    }

    private UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp, FacesContext facesContext) {
        Object[] facetArray;
        String compClass = this.convertComponentClassIdToString(facesContext, treeStructComp.getComponentClass());
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance(compClass);
        component.setId(compId);
        component.setTransient(treeStructComp.isTransient());
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List childList = component.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.internalRestoreTreeStructure(childArray[i], facesContext);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map facetMap = component.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                TreeStructComponent structChild = (TreeStructComponent)((Object[])facetArray[i])[1];
                String facetName = (String)((Object[])facetArray[i])[0];
                UIComponent child = this.internalRestoreTreeStructure(structChild, facesContext);
                facetMap.put(facetName, child);
            }
        }
        return component;
    }

    private String convertComponentClassIdToString(FacesContext facesContext, Integer classId) {
        Object[] idmaps = (Object[])facesContext.getExternalContext().getApplicationMap().get(PARTIAL_STATE_CLASS_IDS);
        if (idmaps == null) {
            idmaps = new Object[]{new HashMap(), new HashMap()};
            facesContext.getExternalContext().getApplicationMap().put(PARTIAL_STATE_CLASS_IDS, idmaps);
        }
        return (String)((HashMap)idmaps[0]).get(classId);
    }

    private Integer convertStringToComponentClassId(FacesContext facesContext, String stringToConvert) {
        Object[] idmaps;
        if (stringToConvert.equalsIgnoreCase("org.apache.myfaces.application.pss.UIViewRootWrapper")) {
            stringToConvert = "javax.faces.component.UIViewRoot";
        }
        if ((idmaps = (Object[])facesContext.getExternalContext().getApplicationMap().get(PARTIAL_STATE_CLASS_IDS)) == null) {
            idmaps = new Object[]{new HashMap(), new HashMap()};
        }
        Integer idInMap = (Integer)((HashMap)idmaps[1]).get(stringToConvert);
        HashMap idToStringMap = (HashMap)idmaps[0];
        HashMap stringToIdMap = (HashMap)idmaps[1];
        if (idInMap == null) {
            Integer id = new Integer(stringToIdMap.size());
            stringToIdMap.put(stringToConvert, id);
            idToStringMap.put(id, stringToConvert);
        }
        facesContext.getExternalContext().getApplicationMap().put(PARTIAL_STATE_CLASS_IDS, idmaps);
        return (Integer)stringToIdMap.get(stringToConvert);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

