/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.producer.provider.driver;

import java.net.URLEncoder;
import oasis.names.tc.wsrp.v1.types.PortletContext;
import oasis.names.tc.wsrp.v1.types.RuntimeContext;
import oasis.names.tc.wsrp.v1.types.Templates;
import oasis.names.tc.wsrp.v1.types.UserContext;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.producer.provider.Provider;
import org.apache.wsrp4j.producer.provider.URLComposer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class URLComposerImpl
implements URLComposer {
    private Provider provider;
    private Logger logger;

    public static URLComposerImpl getInstance(Provider provider) {
        URLComposerImpl urlComposer = new URLComposerImpl();
        urlComposer.provider = provider;
        return urlComposer;
    }

    public String createBlockingActionURL(String portletMode, String navigationalState, String interactionState, String windowState, boolean secureURL, RuntimeContext runtimeContext, PortletContext portletContext, UserContext userContext) {
        Templates templates;
        String MN = "createBlockingActionURL";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (runtimeContext != null && (templates = runtimeContext.getTemplates()) != null) {
            String template = null;
            if (secureURL) {
                template = templates.getSecureBlockingActionTemplate();
                if (template == null) {
                    template = templates.getSecureDefaultTemplate();
                }
            } else {
                template = templates.getBlockingActionTemplate();
                if (template == null) {
                    template = templates.getDefaultTemplate();
                }
            }
            try {
                if (template != null) {
                    if (this.logger.isLogging(60)) {
                        this.logger.exit(60, MN);
                    }
                    return this.createBlockingActionURLByTemplate(template, portletMode, navigationalState, interactionState, windowState, portletContext == null ? null : portletContext.getPortletHandle(), userContext == null ? null : userContext.getUserContextKey(), runtimeContext.getPortletInstanceKey(), runtimeContext.getSessionID());
                }
            }
            catch (WSRPException e) {
                // empty catch block
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return this.createRewriteURL("blockingAction", portletMode, navigationalState, interactionState, windowState, null, null, null, String.valueOf(secureURL));
    }

    public String createRenderURL(String portletMode, String navigationalState, String windowState, boolean secureURL, RuntimeContext runtimeContext, PortletContext portletContext, UserContext userContext) {
        Templates templates;
        String MN = "createRenderURL";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (runtimeContext != null && (templates = runtimeContext.getTemplates()) != null) {
            String template = null;
            if (secureURL) {
                template = templates.getSecureRenderTemplate();
                if (template == null) {
                    template = templates.getDefaultTemplate();
                }
            } else {
                template = templates.getRenderTemplate();
                if (template == null) {
                    template = templates.getDefaultTemplate();
                }
            }
            try {
                if (template != null) {
                    if (this.logger.isLogging(60)) {
                        this.logger.exit(60, MN);
                    }
                    return this.createRenderURLByTemplate(template, portletMode, navigationalState, windowState, portletContext == null ? null : portletContext.getPortletHandle(), userContext == null ? null : userContext.getUserContextKey(), runtimeContext.getPortletInstanceKey(), runtimeContext.getSessionID());
                }
            }
            catch (WSRPException e) {
                // empty catch block
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return this.createRewriteURL("render", portletMode, navigationalState, null, windowState, null, null, null, String.valueOf(secureURL));
    }

    public String createResourceURL(String url, boolean rewriteResource, boolean secureURL, RuntimeContext runtimeContext, PortletContext portletContext, UserContext userContext) {
        Templates templates;
        String MN = "createResourceURL";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (runtimeContext != null && (templates = runtimeContext.getTemplates()) != null) {
            String template = null;
            if (secureURL) {
                template = templates.getSecureResourceTemplate();
                if (template == null) {
                    template = templates.getDefaultTemplate();
                }
            } else {
                template = templates.getResourceTemplate();
                if (template == null) {
                    template = templates.getDefaultTemplate();
                }
            }
            try {
                if (template != null) {
                    if (this.logger.isLogging(60)) {
                        this.logger.exit(60, MN);
                    }
                    return this.createResourceURLByTemplate(template, url, rewriteResource, portletContext == null ? null : portletContext.getPortletHandle(), userContext == null ? null : userContext.getUserContextKey(), runtimeContext.getPortletInstanceKey(), runtimeContext.getSessionID());
                }
            }
            catch (WSRPException e) {
                // empty catch block
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return this.createRewriteURL("resource", null, null, null, null, url, String.valueOf(rewriteResource), null, String.valueOf(secureURL));
    }

    public String createNamespacedToken(String token, RuntimeContext runtimeContext) {
        String MN = "createNamespacedToken";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        String nsToken = null;
        if (runtimeContext != null) {
            nsToken = runtimeContext.getNamespacePrefix();
        }
        if (nsToken == null) {
            nsToken = "wsrp_rewrite_";
        }
        if (token != null) {
            nsToken = nsToken.concat(token);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return nsToken;
    }

    private final String createRewriteURL(String urlType, String portletMode, String navigationalState, String interactionState, String windowState, String url, String rewriteResource, String token, String secureURL) {
        String MN = "createRewriteURL()";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN, new Object[]{urlType, portletMode, navigationalState, interactionState, windowState, url, rewriteResource, token, secureURL});
        }
        StringBuffer resultURL = new StringBuffer();
        resultURL.append("wsrp_rewrite");
        resultURL.append("?");
        if (urlType != null) {
            resultURL.append(this.appendNameValuePair("wsrp-urlType", urlType));
        }
        if (portletMode != null && portletMode.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-mode", portletMode));
        }
        if (navigationalState != null && navigationalState.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-navigationalState", navigationalState));
        }
        if (interactionState != null && interactionState.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-interactionState", interactionState));
        }
        if (windowState != null && windowState.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-windowState", windowState));
        }
        if (url != null && url.length() > 0) {
            resultURL.append("&amp;");
            String fileEncoding = System.getProperty("file.encoding", "UTF-8");
            try {
                resultURL.append(this.appendNameValuePair("wsrp-url", URLEncoder.encode(url, fileEncoding)));
            }
            catch (Exception e) {
                this.logger.text(10, MN, e, "Encoding not supported.");
            }
        }
        if (rewriteResource != null && rewriteResource.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-requiresRewrite", rewriteResource));
        }
        if (secureURL != null && secureURL.length() > 0) {
            resultURL.append("&amp;");
            resultURL.append(this.appendNameValuePair("wsrp-secureURL", secureURL));
        }
        resultURL.append("/wsrp_rewrite");
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        String result = resultURL.toString();
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN, result);
        }
        return result;
    }

    private final String createNameValuePair(String name, String value) {
        StringBuffer pair = new StringBuffer(name);
        pair.append("=");
        pair.append(value);
        return pair.toString();
    }

    private final String appendNameValuePair(String name, String value) {
        return this.createNameValuePair(name, value);
    }

    private final String createBlockingActionURLByTemplate(String blockingActionTemplate, String portletMode, String navigationalState, String interactionState, String windowState) throws WSRPException {
        return this.processTemplate(blockingActionTemplate, "blockingAction", portletMode, navigationalState, interactionState, windowState, null, null, null, null, null, null);
    }

    private final String createBlockingActionURLByTemplate(String blockingActionTemplate, String portletMode, String navigationalState, String interactionState, String windowState, String portletHandle, String userContextKey, String portletInstanceKey, String sessionID) throws WSRPException {
        return this.processTemplate(blockingActionTemplate, "blockingAction", portletMode, navigationalState, interactionState, windowState, null, null, portletHandle, userContextKey, portletInstanceKey, sessionID);
    }

    private final String createRenderURLByTemplate(String renderTemplate, String portletMode, String navigationalState, String windowState) throws WSRPException {
        return this.processTemplate(renderTemplate, "render", portletMode, navigationalState, null, windowState, null, null, null, null, null, null);
    }

    private final String createRenderURLByTemplate(String renderTemplate, String portletMode, String navigationalState, String windowState, String portletHandle, String userContextKey, String portletInstanceKey, String sessionID) throws WSRPException {
        return this.processTemplate(renderTemplate, "render", portletMode, navigationalState, null, windowState, null, null, portletHandle, userContextKey, portletInstanceKey, sessionID);
    }

    private final String createResourceURLByTemplate(String resourceTemplate, String url, boolean rewriteResource) throws WSRPException {
        return this.processTemplate(resourceTemplate, "resource", null, null, null, null, url, String.valueOf(rewriteResource), null, null, null, null);
    }

    private final String createResourceURLByTemplate(String resourceTemplate, String url, boolean rewriteResource, String portletHandle, String userContextKey, String portletInstanceKey, String sessionID) throws WSRPException {
        return this.processTemplate(resourceTemplate, "resource", null, null, null, null, url, String.valueOf(rewriteResource), portletHandle, userContextKey, portletInstanceKey, sessionID);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private final String processTemplate(String template, String urlType, String portletMode, String navigationalState, String interactionState, String windowState, String url, String rewriteResource, String portletHandle, String userContextKey, String portletInstanceKey, String sessionID) throws WSRPException {
        boolean bl;
        boolean bl2;
        String MN = "processTemplate";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        String replaceToken = "";
        boolean bl3 = true;
        do {
            if (!bl3 || (bl3 = false) || !true) {
                StringBuffer templateBuffer = new StringBuffer(template);
                int left_br = template.indexOf("{");
                int right_br = template.indexOf("}") + 1;
                boolean bl4 = false;
                if (left_br > right_br) {
                    bl4 = true;
                }
                boolean bl5 = false;
                if (left_br == -1) {
                    bl5 = true;
                }
                boolean bl6 = bl4 | bl5;
                boolean bl7 = false;
                if (right_br == -1) {
                    bl7 = true;
                }
                if (bl6 | bl7) {
                    WSRPXHelper.throwX(this.logger, 10, MN, 3041);
                }
                if ((replaceToken = templateBuffer.substring(left_br + 1, right_br - 1)).equalsIgnoreCase("wsrp-urlType")) {
                    if (urlType == null) {
                        urlType = "";
                    }
                    templateBuffer.replace(left_br, right_br, urlType);
                } else if (replaceToken.equalsIgnoreCase("wsrp-mode")) {
                    if (portletMode == null) {
                        portletMode = "";
                    }
                    templateBuffer.replace(left_br, right_br, portletMode);
                } else if (replaceToken.equalsIgnoreCase("wsrp-navigationalState")) {
                    if (navigationalState == null) {
                        navigationalState = "";
                    }
                    templateBuffer.replace(left_br, right_br, navigationalState);
                } else if (replaceToken.equalsIgnoreCase("wsrp-interactionState")) {
                    if (interactionState == null) {
                        interactionState = "";
                    }
                    templateBuffer.replace(left_br, right_br, interactionState);
                } else if (replaceToken.equalsIgnoreCase("wsrp-windowState")) {
                    if (windowState == null) {
                        windowState = "";
                    }
                    templateBuffer.replace(left_br, right_br, windowState);
                } else if (replaceToken.equalsIgnoreCase("wsrp-url")) {
                    if (url == null) {
                        url = "";
                    }
                    templateBuffer.replace(left_br, right_br, url);
                } else if (replaceToken.equalsIgnoreCase("wsrp-requiresRewrite")) {
                    if (rewriteResource == null) {
                        rewriteResource = "";
                    }
                    templateBuffer.replace(left_br, right_br, rewriteResource);
                } else if (replaceToken.equalsIgnoreCase("wsrp-portletHandle")) {
                    if (portletHandle == null) {
                        portletHandle = "";
                    }
                    templateBuffer.replace(left_br, right_br, portletHandle);
                } else if (replaceToken.equalsIgnoreCase("wsrp-userContextKey")) {
                    if (userContextKey == null) {
                        userContextKey = "";
                    }
                    templateBuffer.replace(left_br, right_br, userContextKey);
                } else if (replaceToken.equalsIgnoreCase("wsrp-portletInstanceKey")) {
                    if (portletInstanceKey == null) {
                        portletInstanceKey = "";
                    }
                    templateBuffer.replace(left_br, right_br, portletInstanceKey);
                } else if (replaceToken.equalsIgnoreCase("wsrp-sessionID")) {
                    if (sessionID == null) {
                        sessionID = "";
                    }
                    templateBuffer.replace(left_br, right_br, sessionID);
                } else {
                    WSRPXHelper.throwX(this.logger, 10, MN, 3040);
                }
                template = templateBuffer.toString();
            }
            bl2 = false;
            if (template.indexOf("{") != -1) {
                bl2 = true;
            }
            bl = false;
            if (template.indexOf("}") == -1) continue;
            bl = true;
        } while (bl2 | bl);
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return template;
    }

    private final /* synthetic */ void this() {
        this.provider = null;
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
    }

    private URLComposerImpl() {
        this.this();
    }
}

