/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.producer.provider.driver;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.producer.provider.PortletRegistrationFilter;
import org.apache.wsrp4j.producer.provider.PortletRegistrationFilterWriter;
import org.apache.wsrp4j.producer.provider.driver.ConsumerPortletRegistrationImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PortletRegistrationFilterImpl
implements PortletRegistrationFilter,
PortletRegistrationFilterWriter {
    private static PortletRegistrationFilterImpl filter = null;
    private static HashMap consumerPortletRegistrationMap = new HashMap();
    private Logger logger;

    public static PortletRegistrationFilterWriter createWriter() {
        if (filter == null) {
            filter = new PortletRegistrationFilterImpl();
        }
        return filter;
    }

    public static PortletRegistrationFilter createReader() {
        if (filter == null) {
            filter = new PortletRegistrationFilterImpl();
        }
        return filter;
    }

    public Iterator getAvailable(String regHandle) {
        String MN = "getAvailable";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        Iterator iter = null;
        if (consumerPortletRegistrationMap.containsKey(regHandle)) {
            if (this.logger.isLogging(50)) {
                this.logger.text(50, MN, "RegistrationHandle " + regHandle + " found in Map.");
            }
            ConsumerPortletRegistrationImpl cpr = (ConsumerPortletRegistrationImpl)consumerPortletRegistrationMap.get(regHandle);
            iter = cpr.getPortletHandles().iterator();
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return iter;
    }

    public boolean isAvailable(String regHandle, String portletHandle) {
        String MN = "isAvailable";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        boolean retVal = false;
        if (consumerPortletRegistrationMap.containsKey(regHandle)) {
            ConsumerPortletRegistrationImpl cpr;
            if (this.logger.isLogging(50)) {
                this.logger.text(50, MN, "RegistrationHandle " + regHandle + "found in Map.");
            }
            if ((cpr = (ConsumerPortletRegistrationImpl)consumerPortletRegistrationMap.get(regHandle)).containsPortletHandle(portletHandle)) {
                retVal = true;
                if (this.logger.isLogging(50)) {
                    this.logger.text(50, MN, "PortletHandle " + portletHandle + "found for registration.");
                }
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return retVal;
    }

    public void makeAvailable(String regHandle, String portletHandle) throws WSRPException {
        String MN = "makeAvailable";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        ConsumerPortletRegistrationImpl cpr = null;
        if (!consumerPortletRegistrationMap.containsKey(regHandle)) {
            cpr = new ConsumerPortletRegistrationImpl();
            cpr.setRegistrationHandle(regHandle);
            consumerPortletRegistrationMap.put(regHandle, cpr);
        } else {
            cpr = (ConsumerPortletRegistrationImpl)consumerPortletRegistrationMap.get(regHandle);
        }
        cpr.addPortletHandle(portletHandle);
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    public void makeAvailable(String regHandle, Iterator portletHandles) throws WSRPException {
        String MN = "makeAvailable";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        while (portletHandles.hasNext()) {
            this.makeAvailable(regHandle, (String)portletHandles.next());
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    public void remove(String regHandle) {
        String MN = "remove";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (consumerPortletRegistrationMap.containsKey(regHandle)) {
            ConsumerPortletRegistrationImpl cpr = (ConsumerPortletRegistrationImpl)consumerPortletRegistrationMap.get(regHandle);
            consumerPortletRegistrationMap.remove(regHandle);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    public void remove(String regHandle, String portletHandle) throws WSRPException {
        String MN = "remove";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (consumerPortletRegistrationMap.containsKey(regHandle)) {
            ConsumerPortletRegistrationImpl cpr = (ConsumerPortletRegistrationImpl)consumerPortletRegistrationMap.get(regHandle);
            cpr.deletePortletHandle(portletHandle);
            if (cpr.isEmpty()) {
                consumerPortletRegistrationMap.remove(regHandle);
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    public void remove(String regHandle, Iterator portletHandles) throws WSRPException {
        String MN = "remove";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (portletHandles != null) {
            while (portletHandles.hasNext()) {
                this.remove(regHandle, (String)portletHandles.next());
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    private final /* synthetic */ void this() {
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
    }

    private PortletRegistrationFilterImpl() {
        this.this();
        String MN = "Constructor";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }
}

