/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.producer.driver;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_PortletManagement_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Registration_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_ServiceDescription_PortType;
import oasis.names.tc.wsrp.v1.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v1.types.ClonePortlet;
import oasis.names.tc.wsrp.v1.types.DestroyFailed;
import oasis.names.tc.wsrp.v1.types.DestroyPortlets;
import oasis.names.tc.wsrp.v1.types.DestroyPortletsResponse;
import oasis.names.tc.wsrp.v1.types.GetMarkup;
import oasis.names.tc.wsrp.v1.types.GetPortletDescription;
import oasis.names.tc.wsrp.v1.types.GetPortletProperties;
import oasis.names.tc.wsrp.v1.types.GetPortletPropertyDescription;
import oasis.names.tc.wsrp.v1.types.GetServiceDescription;
import oasis.names.tc.wsrp.v1.types.InitCookie;
import oasis.names.tc.wsrp.v1.types.MarkupParams;
import oasis.names.tc.wsrp.v1.types.MarkupResponse;
import oasis.names.tc.wsrp.v1.types.MarkupType;
import oasis.names.tc.wsrp.v1.types.MissingParametersFault;
import oasis.names.tc.wsrp.v1.types.ModifyRegistration;
import oasis.names.tc.wsrp.v1.types.PerformBlockingInteraction;
import oasis.names.tc.wsrp.v1.types.PortletContext;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.PortletDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PortletPropertyDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PropertyList;
import oasis.names.tc.wsrp.v1.types.RegistrationContext;
import oasis.names.tc.wsrp.v1.types.RegistrationData;
import oasis.names.tc.wsrp.v1.types.RegistrationState;
import oasis.names.tc.wsrp.v1.types.ReleaseSessions;
import oasis.names.tc.wsrp.v1.types.ReturnAny;
import oasis.names.tc.wsrp.v1.types.ServiceDescription;
import oasis.names.tc.wsrp.v1.types.SetPortletProperties;
import oasis.names.tc.wsrp.v1.types.StateChange;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.producer.ConsumerRegistry;
import org.apache.wsrp4j.producer.ConsumerRegistryAccess;
import org.apache.wsrp4j.producer.ProviderAccess;
import org.apache.wsrp4j.producer.Registration;
import org.apache.wsrp4j.producer.provider.ConsumerConfiguredPortlet;
import org.apache.wsrp4j.producer.provider.DescriptionHandler;
import org.apache.wsrp4j.producer.provider.Portlet;
import org.apache.wsrp4j.producer.provider.PortletStateManager;
import org.apache.wsrp4j.producer.provider.ProducerOfferedPortlet;
import org.apache.wsrp4j.producer.provider.Provider;
import org.apache.wsrp4j.util.LocaleHelper;
import org.apache.wsrp4j.util.ParameterChecker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WSRPEngine
implements WSRP_v1_PortletManagement_PortType,
WSRP_v1_Markup_PortType,
WSRP_v1_Registration_PortType,
WSRP_v1_ServiceDescription_PortType {
    private static WSRPEngine instance = null;
    private boolean registrationRequired;
    private Provider provider;
    private ConsumerRegistry consumerRegistry;
    private ParameterChecker paramCheck;
    private Logger logger;

    private final void createSession() throws WSRPException {
        MessageContext msgContext = AxisEngine.getCurrentMessageContext();
        HttpServletRequest servletRequest = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession session = servletRequest.getSession(true);
        if (session == null) {
            throw new WSRPException(1108);
        }
    }

    public static synchronized WSRPEngine getInstance() throws RemoteException {
        if (instance == null) {
            instance = new WSRPEngine();
        }
        return instance;
    }

    public ServiceDescription getServiceDescription(GetServiceDescription request) throws RemoteException {
        ServiceDescription description;
        String MN;
        block8: {
            MN = "getServiceDescription";
            if (this.logger.isLogging(60)) {
                this.logger.entry(60, MN);
            }
            description = null;
            try {
                this.paramCheck.check(request);
                DescriptionHandler descrHandler = this.provider.getDescriptionHandler();
                RegistrationContext regContext = request.getRegistrationContext();
                boolean registered = false;
                if (regContext != null) {
                    registered = this.consumerRegistry.check(regContext.getRegistrationHandle());
                }
                if (!this.registrationRequired || regContext != null && registered) {
                    description = descrHandler.getServiceDescription(regContext, request.getDesiredLocales());
                    break block8;
                }
                if (regContext == null && !registered) {
                    description = descrHandler.getServiceDescription(null, request.getDesiredLocales());
                    break block8;
                }
                throw new WSRPException(1102);
            }
            catch (WSRPException e) {
                WSRPXHelper.handleWSRPException(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return description;
    }

    public RegistrationContext register(RegistrationData request) throws RemoteException {
        String MN = "register";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        RegistrationContext regContext = null;
        try {
            this.paramCheck.check(request, false);
            Registration consumerRegistration = this.consumerRegistry.register(request);
            regContext = consumerRegistration.getRegistrationContext();
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return regContext;
    }

    public ReturnAny deregister(RegistrationContext request) throws RemoteException {
        String MN = "deregister";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        this.paramCheck.check(request, false);
        try {
            this.checkRegistration(request);
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return new ReturnAny();
    }

    public RegistrationState modifyRegistration(ModifyRegistration request) throws RemoteException {
        String MN = "modifyRegistration";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        this.paramCheck.check(request);
        RegistrationState regState = null;
        try {
            this.checkRegistration(request.getRegistrationContext());
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        Registration registration = this.consumerRegistry.get(request.getRegistrationContext().getRegistrationHandle());
        registration.setRegistrationData(request.getRegistrationData());
        registration.setRegistrationContext(request.getRegistrationContext());
        regState = new RegistrationState();
        regState.setRegistrationState(registration.getRegistrationContext().getRegistrationState());
        regState.setExtensions(null);
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return regState;
    }

    private final void checkRegistration(RegistrationContext registrationContext) throws RemoteException, WSRPException {
        String MN = "checkRegistration";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        this.paramCheck.check(registrationContext, false);
        if (!this.consumerRegistry.check(registrationContext.getRegistrationHandle())) {
            throw new WSRPException(1102);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    private final Portlet getPortlet(RegistrationContext registrationContext, String portletHandle) throws RemoteException {
        String MN = "getPortlet";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        Portlet portlet = null;
        try {
            portlet = this.provider.getPortletPool().get(portletHandle);
            if (this.registrationRequired) {
                ProducerOfferedPortlet parent = null;
                if (portlet instanceof ProducerOfferedPortlet) {
                    parent = (ProducerOfferedPortlet)portlet;
                } else {
                    String regHandle = registrationContext.getRegistrationHandle();
                    if (!this.provider.getPortletRegistrationFilter().isAvailable(regHandle, portletHandle)) {
                        throw new WSRPException(1100);
                    }
                    String parentHandle = ((ConsumerConfiguredPortlet)portlet).getParentHandle();
                    parent = (ProducerOfferedPortlet)this.provider.getPortletPool().get(parentHandle);
                }
                if (parent != null && parent.isRegistrationRequired()) {
                    this.checkRegistration(registrationContext);
                }
            }
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return portlet;
    }

    private final void checkCookie() throws RemoteException, WSRPException {
        MessageContext msgContext = AxisEngine.getCurrentMessageContext();
        HttpServletRequest servletRequest = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession session = servletRequest.getSession(false);
        if (session == null) {
            throw new WSRPException(1103);
        }
    }

    private final MarkupType checkMarkupParams(PortletDescription portletDescription, MarkupParams markupParams) throws WSRPException {
        String MN = "checkMarkupParams";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        MarkupType match = new MarkupType();
        String[] reqMimeTypes = markupParams.getMimeTypes();
        String reqMode = markupParams.getMode();
        String reqWindowState = markupParams.getWindowState();
        String[] reqLocales = markupParams.getLocales();
        boolean foundMode = false;
        boolean foundWindow = false;
        boolean foundMime = false;
        MarkupType[] markupTypes = portletDescription.getMarkupTypes();
        int i = 0;
        while (i < markupTypes.length) {
            String mimeType = markupTypes[i].getMimeType();
            int j = 0;
            while (j < reqMimeTypes.length) {
                if (mimeType.equalsIgnoreCase(reqMimeTypes[j])) {
                    foundMime = true;
                    match.setMimeType(mimeType);
                    String[] modes = markupTypes[i].getModes();
                    int k = 0;
                    while (k < modes.length) {
                        if (modes[k].equalsIgnoreCase(reqMode)) {
                            foundMode = true;
                            match.setModes(new String[]{reqMode});
                            String[] windowStates = markupTypes[i].getWindowStates();
                            int l = 0;
                            while (l < windowStates.length) {
                                if (windowStates[l].equalsIgnoreCase(reqWindowState)) {
                                    foundWindow = true;
                                    match.setWindowStates(new String[]{reqWindowState});
                                    String[] locales = markupTypes[i].getLocales();
                                    if (locales == null) {
                                        if (this.logger.isLogging(60)) {
                                            this.logger.exit(60, MN);
                                        }
                                        return match;
                                    }
                                    int m = 0;
                                    while (m < locales.length) {
                                        int n = 0;
                                        while (n < reqLocales.length) {
                                            if (locales[m].equalsIgnoreCase(reqLocales[n])) {
                                                match.setLocales(new String[]{locales[m]});
                                                if (this.logger.isLogging(60)) {
                                                    this.logger.exit(60, MN);
                                                }
                                                return match;
                                            }
                                            if (LocaleHelper.getLanguageCode(locales[m]).equalsIgnoreCase(LocaleHelper.getLanguageCode(reqLocales[n]))) {
                                                match.setLocales(new String[]{LocaleHelper.getLanguageCode(locales[m])});
                                                if (this.logger.isLogging(60)) {
                                                    this.logger.exit(60, MN);
                                                }
                                                return match;
                                            }
                                            ++n;
                                        }
                                        ++m;
                                    }
                                }
                                ++l;
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        if (!foundMime) {
            throw new WSRPException(1111);
        }
        if (!foundMode) {
            throw new WSRPException(1112);
        }
        if (!foundWindow) {
            throw new WSRPException(1113);
        }
        throw new WSRPException(1110);
    }

    public MarkupResponse getMarkup(GetMarkup request) throws RemoteException {
        String MN = "getMarkup";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        MarkupResponse markupResponse = null;
        try {
            this.paramCheck.check(request);
            this.checkCookie();
            RegistrationContext regContext = request.getRegistrationContext();
            PortletDescription portletDescription = null;
            portletDescription = this.provider.getDescriptionHandler().getPortletDescription(request.getPortletContext().getPortletHandle(), regContext, null, request.getMarkupParams().getLocales());
            MarkupType markupType = this.checkMarkupParams(portletDescription, request.getMarkupParams());
            request.getMarkupParams().setLocales(markupType.getLocales());
            request.getMarkupParams().setMimeTypes(new String[]{markupType.getMimeType()});
            request.getMarkupParams().setMode(markupType.getModes()[0]);
            request.getMarkupParams().setWindowState(markupType.getWindowStates()[0]);
            request.getMarkupParams().setWindowState(markupType.getWindowStates()[0]);
            Boolean templateProcessing = portletDescription.getDoesUrlTemplateProcessing();
            if (templateProcessing == null) {
                templateProcessing = Boolean.FALSE;
            }
            if (templateProcessing.booleanValue()) {
                try {
                    this.paramCheck.check(request.getRuntimeContext().getTemplates());
                }
                catch (MissingParametersFault e) {
                    templateProcessing = Boolean.FALSE;
                }
            }
            markupResponse = this.provider.getPortletInvoker().invokeGetMarkup(request);
            if (!templateProcessing.booleanValue()) {
                markupResponse.getMarkupContext().setRequiresUrlRewriting(Boolean.TRUE);
            } else {
                markupResponse.getMarkupContext().setRequiresUrlRewriting(Boolean.FALSE);
            }
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return markupResponse;
    }

    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction request) throws RemoteException {
        String MN = "performBlockingInteraction";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        BlockingInteractionResponse interactionResponse = null;
        try {
            this.paramCheck.check(request);
            this.checkCookie();
            PortletContext newPortletContext = null;
            newPortletContext = this.handlePortletStateChange(request);
            PortletDescription portletDescription = null;
            portletDescription = this.provider.getDescriptionHandler().getPortletDescription(request.getPortletContext().getPortletHandle(), request.getRegistrationContext(), null, request.getMarkupParams().getLocales());
            MarkupType markupType = this.checkMarkupParams(portletDescription, request.getMarkupParams());
            request.getMarkupParams().setLocales(markupType.getLocales());
            request.getMarkupParams().setMimeTypes(new String[]{markupType.getMimeType()});
            request.getMarkupParams().setMode(markupType.getModes()[0]);
            request.getMarkupParams().setWindowState(markupType.getWindowStates()[0]);
            interactionResponse = this.provider.getPortletInvoker().invokePerformBlockingInteraction(request);
            if (newPortletContext != null) {
                interactionResponse.getUpdateResponse().setPortletContext(newPortletContext);
            }
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return interactionResponse;
    }

    private final PortletContext handlePortletStateChange(PerformBlockingInteraction request) throws RemoteException, WSRPException {
        String MN = "handlePortletStateChange";
        PortletContext portletContext = null;
        Portlet portlet = null;
        try {
            portlet = this.provider.getPortletPool().get(request.getPortletContext().getPortletHandle());
        }
        catch (WSRPException e) {
            if (e.getErrorCode() == 3020) {
                WSRPXHelper.throwX(this.logger, 10, "handlePortletStateChange", 1104);
            }
            WSRPXHelper.throwX(e.getErrorCode());
        }
        StateChange stateChange = null;
        stateChange = request.getInteractionParams().getPortletStateChange();
        if (portlet instanceof ProducerOfferedPortlet) {
            if (stateChange.toString().equals("readOnly")) {
                WSRPXHelper.throwX(1109);
            } else if (stateChange.toString().equals("cloneBeforeWrite")) {
                portletContext = this.handleCloneBeforeWrite(request);
            } else {
                WSRPXHelper.throwX(1108);
            }
        } else if (portlet instanceof ConsumerConfiguredPortlet) {
            if (stateChange.toString().equals("readOnly")) {
                WSRPXHelper.throwX(1109);
            } else if (stateChange.toString().equals("cloneBeforeWrite")) {
                portletContext = this.handleCloneBeforeWrite(request);
            }
        } else {
            WSRPXHelper.throwX(this.logger, 10, "handlePortletStateChange", 1108);
        }
        return portletContext;
    }

    private final PortletContext handleCloneBeforeWrite(PerformBlockingInteraction request) throws WSRPException, RemoteException {
        PortletContext portletContext = null;
        ClonePortlet cloneRequest = new ClonePortlet();
        cloneRequest.setPortletContext(request.getPortletContext());
        cloneRequest.setRegistrationContext(request.getRegistrationContext());
        cloneRequest.setUserContext(request.getUserContext());
        portletContext = this.clonePortlet(cloneRequest);
        request.setPortletContext(portletContext);
        return portletContext;
    }

    public ReturnAny initCookie(InitCookie request) throws RemoteException {
        String MN = "initCookie";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        try {
            this.paramCheck.check(request);
            if (this.registrationRequired) {
                this.checkRegistration(request.getRegistrationContext());
            }
            this.createSession();
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return new ReturnAny();
    }

    public ReturnAny releaseSessions(ReleaseSessions request) throws RemoteException {
        String MN = "releaseSession";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return new ReturnAny();
    }

    public PortletDescriptionResponse getPortletDescription(GetPortletDescription request) throws RemoteException {
        String MN = "getPortletDescription";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PortletDescription portletDescription = null;
        PortletDescriptionResponse response = null;
        try {
            this.paramCheck.check(request);
            RegistrationContext regContext = request.getRegistrationContext();
            portletDescription = this.provider.getDescriptionHandler().getPortletDescription(request.getPortletContext().getPortletHandle(), regContext, null, request.getDesiredLocales());
            response = new PortletDescriptionResponse();
            response.setPortletDescription(portletDescription);
            response.setResourceList(null);
            response.setExtensions(null);
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return response;
    }

    public PortletContext clonePortlet(ClonePortlet request) throws RemoteException {
        PortletContext portletContext;
        String MN;
        block6: {
            MN = "clonePortlet";
            if (this.logger.isLogging(60)) {
                this.logger.entry(60, MN);
            }
            portletContext = null;
            try {
                this.paramCheck.check(request);
                PortletStateManager portletStateManager = null;
                portletStateManager = this.provider.getPortletStateManager();
                String orgPortletHandle = request.getPortletContext().getPortletHandle();
                Portlet portletClone = null;
                portletClone = this.provider.getPortletPool().clone(orgPortletHandle);
                if (portletClone != null) {
                    String regHandle;
                    String newPortletHandle = portletClone.getPortletHandle();
                    portletContext = new PortletContext();
                    portletContext.setPortletHandle(newPortletHandle);
                    portletContext.setPortletState(portletStateManager.getAsString(newPortletHandle).getBytes());
                    portletContext.setExtensions(null);
                    RegistrationContext regContext = request.getRegistrationContext();
                    if (regContext != null && (regHandle = regContext.getRegistrationHandle()) != null && this.consumerRegistry.check(regHandle)) {
                        this.provider.getPortletRegistrationFilterWriter().makeAvailable(regHandle, newPortletHandle);
                    }
                    break block6;
                }
                throw new WSRPException(1108);
            }
            catch (WSRPException e) {
                WSRPXHelper.handleWSRPException(e);
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return portletContext;
    }

    public DestroyPortletsResponse destroyPortlets(DestroyPortlets request) throws RemoteException {
        String MN = "destroyPortlets";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        this.paramCheck.check(request);
        try {
            String regHandle;
            this.checkRegistration(request.getRegistrationContext());
            RegistrationContext regContext = request.getRegistrationContext();
            if (regContext != null && (regHandle = regContext.getRegistrationHandle()) != null && this.consumerRegistry.check(regHandle)) {
                this.provider.getPortletRegistrationFilterWriter().remove(regHandle, Arrays.asList(request.getPortletHandles()).iterator());
            }
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        Iterator<String> handles = Arrays.asList(request.getPortletHandles()).iterator();
        Iterator result = this.provider.getPortletPool().destroySeveral(handles);
        ArrayList<DestroyFailed> failedHandles = new ArrayList<DestroyFailed>();
        while (result.hasNext()) {
            DestroyFailed failed = new DestroyFailed();
            failed.setPortletHandle(result.next().toString());
            failed.setReason("Portlet handle refers to a producer offered portlet!");
            failedHandles.add(failed);
        }
        DestroyFailed[] destroyFailedArray = new DestroyFailed[failedHandles.size()];
        failedHandles.toArray(destroyFailedArray);
        DestroyPortletsResponse response = new DestroyPortletsResponse();
        response.setDestroyFailed(destroyFailedArray);
        response.setExtensions(null);
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return response;
    }

    public PortletContext setPortletProperties(SetPortletProperties request) throws RemoteException {
        String MN = "setPortletProperties";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PortletContext portletContext = null;
        try {
            this.paramCheck.check(request);
            String portletHandle = request.getPortletContext().getPortletHandle();
            Portlet portlet = this.getPortlet(request.getRegistrationContext(), portletHandle);
            if (!(portlet instanceof ConsumerConfiguredPortlet)) {
                throw new WSRPException(1101);
            }
            this.provider.getPortletStateManager().setAsPropertyList(portletHandle, request.getPropertyList());
            portletContext = request.getPortletContext();
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return portletContext;
    }

    public PropertyList getPortletProperties(GetPortletProperties request) throws RemoteException {
        String MN = "getPortletProperties";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PropertyList propertyList = null;
        try {
            this.paramCheck.check(request);
            String portletHandle = request.getPortletContext().getPortletHandle();
            this.getPortlet(request.getRegistrationContext(), portletHandle);
            PortletStateManager portletStateManager = this.provider.getPortletStateManager();
            propertyList = portletStateManager.getAsPropertyList(portletHandle);
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return propertyList;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(GetPortletPropertyDescription request) throws RemoteException {
        String MN = "getPortletPropertyDescription";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PortletPropertyDescriptionResponse response = null;
        try {
            this.paramCheck.check(request);
            String portletHandle = request.getPortletContext().getPortletHandle();
            this.getPortlet(request.getRegistrationContext(), portletHandle);
            response = new PortletPropertyDescriptionResponse();
            response.setModelDescription(this.provider.getPortletStateManager().getModelDescription(portletHandle, request.getDesiredLocales(), false));
            response.setResourceList(null);
            response.setExtensions(null);
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return response;
    }

    private final /* synthetic */ void this() {
        this.provider = null;
        this.consumerRegistry = null;
        this.paramCheck = new ParameterChecker();
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
    }

    private WSRPEngine() throws RemoteException {
        this.this();
        String MN = "Constructor";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        try {
            this.provider = ProviderAccess.getProvider();
            this.consumerRegistry = ConsumerRegistryAccess.getConsumerRegistry();
            this.registrationRequired = this.consumerRegistry.isRegistrationRequired();
        }
        catch (WSRPException e) {
            WSRPXHelper.handleWSRPException(e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }
}

