/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.exception;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v1.types.AccessDeniedFault;
import oasis.names.tc.wsrp.v1.types.Fault;
import oasis.names.tc.wsrp.v1.types.InconsistentParametersFault;
import oasis.names.tc.wsrp.v1.types.InvalidCookieFault;
import oasis.names.tc.wsrp.v1.types.InvalidHandleFault;
import oasis.names.tc.wsrp.v1.types.InvalidRegistrationFault;
import oasis.names.tc.wsrp.v1.types.InvalidSessionFault;
import oasis.names.tc.wsrp.v1.types.InvalidUserCategoryFault;
import oasis.names.tc.wsrp.v1.types.MissingParametersFault;
import oasis.names.tc.wsrp.v1.types.OperationFailedFault;
import oasis.names.tc.wsrp.v1.types.PortletStateChangeRequiredFault;
import oasis.names.tc.wsrp.v1.types.UnsupportedLocaleFault;
import oasis.names.tc.wsrp.v1.types.UnsupportedMimeTypeFault;
import oasis.names.tc.wsrp.v1.types.UnsupportedModeFault;
import oasis.names.tc.wsrp.v1.types.UnsupportedWindowStateFault;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.XMLUtils;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WSRPXHelper {
    private static final String EMPTY_STRING = "";
    private static String EXCEPTION_MAPPING_FILE = "wsrp-exception-mapping.properties";
    private static HashMap exceptionMapping = null;
    static /* synthetic */ Class class$org$apache$wsrp4j$exception$WSRPXHelper;

    public static void throwX(int errorCode) throws WSRPException {
        WSRPException e = WSRPXHelper.getException(errorCode, null);
        throw e;
    }

    public static void throwX(int errorCode, Throwable t) throws WSRPException {
        WSRPException e = WSRPXHelper.getException(errorCode, t);
        throw e;
    }

    public static void throwX(Logger logger, int logLevel, String method, int errorCode) throws WSRPException {
        WSRPException e = WSRPXHelper.getException(errorCode, null);
        if (logger != null) {
            logger.text(logLevel, method, e, EMPTY_STRING);
        }
        throw e;
    }

    public static void throwX(Logger logger, int logLevel, String method, int errorCode, Throwable t) throws WSRPException {
        WSRPException e = WSRPXHelper.getException(errorCode, t);
        if (logger != null) {
            if (t instanceof WSRPException) {
                logger.text(logLevel, method, e.getMessage());
            } else {
                logger.text(logLevel, method, e, EMPTY_STRING);
            }
        }
        throw e;
    }

    public static void handleWSRPException(WSRPException exception) throws RemoteException {
        if (exceptionMapping == null) {
            WSRPXHelper.loadExceptionMapping();
        }
        AxisFault fault = null;
        int errorCode = (Integer)exceptionMapping.get(String.valueOf(exception.getErrorCode()));
        if (errorCode == 1100) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "AccessDenied");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(AccessDeniedFault.getTypeDesc().getXmlType().getNamespaceURI(), "AccessDenied");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1101) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InconsistenParameters");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InconsistentParametersFault.getTypeDesc().getXmlType().getNamespaceURI(), "InconsistenParameters");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1102) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidRegistration");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InvalidRegistrationFault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidRegistration");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1103) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidCookie");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InvalidCookieFault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidCookie");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1104) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidHandle");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InvalidHandleFault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidHandle");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1105) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidSession");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InvalidSessionFault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidSession");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1106) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidUserCategory");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(InvalidUserCategoryFault.getTypeDesc().getXmlType().getNamespaceURI(), "InvalidUserCategory");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1107) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "MissingParameters");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(MissingParametersFault.getTypeDesc().getXmlType().getNamespaceURI(), "MissingParameters");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1108) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "OperationFailed");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(OperationFailedFault.getTypeDesc().getXmlType().getNamespaceURI(), "OperationFailed");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1109) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "PortletStateChangeRequired");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(PortletStateChangeRequiredFault.getTypeDesc().getXmlType().getNamespaceURI(), "PortletStateChangeRequired");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1110) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedLocale");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(UnsupportedLocaleFault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedLocale");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1111) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedMimeType");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(UnsupportedMimeTypeFault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedMimeType");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1112) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedMode");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(UnsupportedModeFault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedMode");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else if (errorCode == 1113) {
            fault = new AxisFault();
            QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedWindowState");
            fault.setFaultCode(qname);
            fault.setFaultString(exception.getMessage());
            try {
                Document doc = XMLUtils.newDocument();
                Element element = doc.createElementNS(UnsupportedWindowStateFault.getTypeDesc().getXmlType().getNamespaceURI(), "UnsupportedWindowState");
                fault.clearFaultDetails();
                fault.setFaultDetail(new Element[]{element});
            }
            catch (Exception e) {}
        } else {
            throw new RemoteException();
        }
        throw fault;
    }

    private static final void loadExceptionMapping() {
        try {
            exceptionMapping = new HashMap();
            Class clazz = class$org$apache$wsrp4j$exception$WSRPXHelper;
            if (clazz == null) {
                clazz = class$org$apache$wsrp4j$exception$WSRPXHelper = WSRPXHelper.class("[Lorg.apache.wsrp4j.exception.WSRPXHelper;", false);
            }
            InputStream in = clazz.getClassLoader().getResourceAsStream(EXCEPTION_MAPPING_FILE);
            Properties props = new Properties();
            props.load(in);
            Enumeration<?> keys = props.propertyNames();
            StringTokenizer tokenizer = null;
            while (keys.hasMoreElements()) {
                String value = null;
                String currentKey = (String)keys.nextElement();
                exceptionMapping.put(currentKey, new Integer(currentKey));
                value = props.getProperty(currentKey);
                if (value == null || value.length() <= 0) continue;
                tokenizer = new StringTokenizer(value, ",");
                String token = null;
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if (token == null) continue;
                    exceptionMapping.put(token, new Integer(currentKey));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleWSRPFault(Logger logger, RemoteException wsrpFault) throws WSRPException {
        if (wsrpFault instanceof AccessDeniedFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1100, wsrpFault);
        } else if (wsrpFault instanceof InconsistentParametersFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1101, wsrpFault);
        } else if (wsrpFault instanceof InvalidRegistrationFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1102, wsrpFault);
        } else if (wsrpFault instanceof InvalidCookieFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1103, wsrpFault);
        } else if (wsrpFault instanceof InvalidHandleFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1104, wsrpFault);
        } else if (wsrpFault instanceof InvalidSessionFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1105, wsrpFault);
        } else if (wsrpFault instanceof InvalidUserCategoryFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1106, wsrpFault);
        } else if (wsrpFault instanceof MissingParametersFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1107, wsrpFault);
        } else if (wsrpFault instanceof OperationFailedFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1108, wsrpFault);
        } else if (wsrpFault instanceof PortletStateChangeRequiredFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1109, wsrpFault);
        } else if (wsrpFault instanceof UnsupportedLocaleFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1110, wsrpFault);
        } else if (wsrpFault instanceof UnsupportedMimeTypeFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1111, wsrpFault);
        } else if (wsrpFault instanceof UnsupportedModeFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1112, wsrpFault);
        } else if (wsrpFault instanceof UnsupportedWindowStateFault) {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1113, wsrpFault);
        } else {
            WSRPXHelper.throwX(logger, 10, EMPTY_STRING, 1116, wsrpFault);
        }
    }

    protected static WSRPException getException(int errorCode, Throwable t) {
        WSRPException e = null;
        if (errorCode >= 2000 && errorCode <= 2999) {
            e = t == null ? new WSRPException(errorCode) : new WSRPException(errorCode, t);
            e.setProducerExceptionRange();
        } else if (errorCode >= 3000 && errorCode <= 3999) {
            e = t == null ? new WSRPException(errorCode) : new WSRPException(errorCode, t);
            e.setProviderExceptionRange();
        } else if (errorCode >= 6000 && errorCode <= 6999) {
            e = t == null ? new WSRPException(errorCode) : new WSRPException(errorCode, t);
            e.setConsumerExceptionRange();
        } else if (errorCode >= 1000 && errorCode <= 1999) {
            e = t == null ? new WSRPException(errorCode) : new WSRPException(errorCode, t);
            e.setCommonExceptionRange();
        } else {
            e = t == null ? new WSRPException(errorCode) : new WSRPException(errorCode, t);
        }
        return e;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

