/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_PortletManagement_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Registration_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_ServiceDescription_PortType;
import oasis.names.tc.wsrp.v1.types.GetServiceDescription;
import oasis.names.tc.wsrp.v1.types.InvalidRegistrationFault;
import oasis.names.tc.wsrp.v1.types.ModifyRegistration;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.RegistrationContext;
import oasis.names.tc.wsrp.v1.types.RegistrationData;
import oasis.names.tc.wsrp.v1.types.RegistrationState;
import oasis.names.tc.wsrp.v1.types.ReturnAny;
import oasis.names.tc.wsrp.v1.types.ServiceDescription;
import oasis.names.tc.wsrp.v1.wsdl.WSRPServiceLocator;
import org.apache.wsrp4j.consumer.Producer;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.util.ParameterChecker;
import org.apache.wsrp4j.util.StateChangedServiceImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProducerImpl
extends StateChangedServiceImpl
implements Producer {
    private String name;
    private String producerID;
    private String description;
    private String registrationURL;
    private String serviceDescriptionURL;
    private String markupURL;
    private String portletManagementURL;
    private boolean registrationRequired;
    private RegistrationContext registrationContext;
    private RegistrationData consumerRegData;
    private ServiceDescription serviceDescription;
    private Hashtable portletDesc;
    private WSRP_v1_ServiceDescription_PortType serviceDescriptionInterface;
    private WSRP_v1_Registration_PortType registrationInterface;
    private WSRP_v1_PortletManagement_PortType portletManagementInterface;
    private Logger logger;
    private ParameterChecker checker;

    public void initServiceDescInterface(String serviceDescriptionURL) throws WSRPException {
        this.serviceDescriptionURL = serviceDescriptionURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.serviceDescriptionInterface = serviceLocator.getWSRPServiceDescriptionService(new URL(serviceDescriptionURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initServiceDescInterface", 6004, xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initServiceDescInterface", 6005, urlEx);
        }
    }

    public void initRegistrationInterface(String registrationURL) throws WSRPException {
        this.registrationURL = registrationURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.registrationInterface = serviceLocator.getWSRPRegistrationService(new URL(registrationURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initRegistrationInterface", 6006, xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initRegistrationInterface", 6007, urlEx);
        }
    }

    public String getServiceDescriptionInterfaceEndpoint() {
        return this.serviceDescriptionURL;
    }

    public void setServiceDescriptionInterfaceEndpoint(String url) {
        this.serviceDescriptionURL = url;
        this.stateChanged();
    }

    public String getRegistrationInterfaceEndpoint() {
        return this.registrationURL;
    }

    public void setRegistrationInterfaceEndpoint(String url) {
        this.registrationURL = url;
        this.stateChanged();
    }

    public String getID() {
        return this.producerID;
    }

    public void setID(String id) {
        this.producerID = id;
        this.stateChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.stateChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.stateChanged();
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public void setIsRegistrationRequired(boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
        this.stateChanged();
    }

    public RegistrationData getRegistrationData() {
        return this.consumerRegData;
    }

    public void setRegistrationData(RegistrationData regData) {
        this.consumerRegData = regData;
        this.stateChanged();
    }

    public RegistrationContext getRegistrationContext() {
        return this.registrationContext;
    }

    public void setRegistrationContext(RegistrationContext registrationContext) {
        if (registrationContext != null) {
            this.registrationContext = registrationContext;
            this.stateChanged();
        }
    }

    public ServiceDescription getServiceDescription() throws WSRPException {
        return this.getServiceDescription(false);
    }

    public ServiceDescription getServiceDescription(boolean newRequest) throws WSRPException {
        block10: {
            if (this.serviceDescription == null || newRequest) {
                GetServiceDescription request = new GetServiceDescription();
                if (this.registrationContext != null) {
                    request.setRegistrationContext(this.registrationContext);
                }
                request.setDesiredLocales(null);
                ServiceDescription response = null;
                try {
                    response = this.serviceDescriptionInterface.getServiceDescription(request);
                    if (response != null) {
                        try {
                            this.checker.check(response);
                        }
                        catch (RemoteException wsrpFault) {
                            WSRPXHelper.handleWSRPFault(this.logger, wsrpFault);
                        }
                        if (this.registrationContext == null && response.isRequiresRegistration()) {
                            this.register(this.consumerRegData);
                            this.getServiceDescription(true);
                        } else {
                            this.setServiceDescription(response);
                        }
                        break block10;
                    }
                    WSRPXHelper.throwX(this.logger, 10, "getServiceDescription", 6011);
                }
                catch (InvalidRegistrationFault invalidReg) {
                    this.register(this.consumerRegData);
                    this.getServiceDescription(true);
                }
                catch (RemoteException wsrpFault) {
                    WSRPXHelper.handleWSRPFault(this.logger, wsrpFault);
                }
            }
        }
        return this.serviceDescription;
    }

    public PortletDescription getPortletDescription(String portletHandle) throws WSRPException {
        PortletDescription desc = null;
        if (portletHandle != null) {
            if (this.serviceDescription == null) {
                this.getServiceDescription();
            }
            if ((desc = (PortletDescription)this.portletDesc.get(portletHandle)) == null) {
                WSRPXHelper.throwX(this.logger, 10, "getPortletDescription", 6010);
            }
        }
        return desc;
    }

    public void setServiceDescription(ServiceDescription serviceDescription) {
        if (serviceDescription != null) {
            this.serviceDescription = serviceDescription;
            this.updatePortletDescriptions(serviceDescription);
            this.setIsRegistrationRequired(serviceDescription.isRequiresRegistration());
        }
    }

    public void addPortletDescription(PortletDescription portletDescription) {
        if (portletDescription != null) {
            this.portletDesc.put(portletDescription.getPortletHandle(), portletDescription);
        }
    }

    private final void updatePortletDescriptions(ServiceDescription serviceDescription) {
        PortletDescription[] offeredPortlets;
        if (serviceDescription != null && (offeredPortlets = serviceDescription.getOfferedPortlets()) != null) {
            this.portletDesc.clear();
            int i = 0;
            while (i < offeredPortlets.length) {
                if (offeredPortlets[i] != null) {
                    this.addPortletDescription(offeredPortlets[i]);
                }
                ++i;
            }
        }
    }

    public RegistrationContext register(RegistrationData registrationData) throws WSRPException {
        if (registrationData != null && this.registrationInterface != null) {
            try {
                RegistrationContext regContext = this.registrationInterface.register(registrationData);
                this.checker.check(regContext, false);
                this.setRegistrationContext(regContext);
            }
            catch (RemoteException wsrpFault) {
                WSRPXHelper.handleWSRPFault(this.logger, wsrpFault);
            }
        }
        return this.registrationContext;
    }

    public RegistrationState modifyRegistration(RegistrationData registrationData) throws WSRPException {
        RegistrationState newState = null;
        try {
            if (registrationData != null && this.registrationInterface != null) {
                ModifyRegistration request = new ModifyRegistration();
                if (this.registrationContext != null) {
                    request.setRegistrationContext(this.registrationContext);
                }
                request.setRegistrationData(registrationData);
                newState = this.registrationInterface.modifyRegistration(request);
                this.getRegistrationContext().setRegistrationState(newState.getRegistrationState());
                this.stateChanged();
            }
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(this.logger, wsrpFault);
        }
        return newState;
    }

    public ReturnAny deregister() throws WSRPException {
        ReturnAny any = null;
        try {
            if (this.registrationContext != null && this.registrationInterface != null) {
                any = this.registrationInterface.deregister(this.registrationContext);
                this.registrationContext = null;
                this.registrationRequired = false;
                this.stateChanged();
            }
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(this.logger, wsrpFault);
        }
        return any;
    }

    public String getMarkupInterfaceEndpoint() {
        return this.markupURL;
    }

    public void setMarkupInterfaceEndpoint(String url) {
        this.markupURL = url;
        this.stateChanged();
    }

    public String getPortletManagementInterfaceEndpoint() {
        return this.portletManagementURL;
    }

    public void setPortletManagementInterfaceEndpoint(String url) {
        this.portletManagementURL = url;
        this.stateChanged();
    }

    public void initPortletManagementInterface(String portletManagementURL) throws WSRPException {
        String MN = "initPortletManagementInterface";
        this.portletManagementURL = portletManagementURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.portletManagementInterface = serviceLocator.getWSRPPortletManagementService(new URL(portletManagementURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initPortletManagementInterface", 6014, xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX(this.logger, 10, "initPortletManagementInterface", 6015, urlEx);
        }
    }

    public WSRP_v1_PortletManagement_PortType getPortletManagementInterface() {
        return this.portletManagementInterface;
    }

    public WSRP_v1_Registration_PortType getRegistrationInterface() {
        return this.registrationInterface;
    }

    public WSRP_v1_ServiceDescription_PortType getServiceDescriptionInterface() {
        return this.serviceDescriptionInterface;
    }

    public boolean isPortletManagementInferfaceSupported() {
        return this.portletManagementURL != null;
    }

    public boolean isRegistrationInterfaceSupported() {
        return this.registrationURL != null;
    }

    private final /* synthetic */ void this() {
        this.name = null;
        this.producerID = null;
        this.description = null;
        this.registrationRequired = false;
        this.registrationContext = null;
        this.consumerRegData = null;
        this.serviceDescription = null;
        this.portletDesc = null;
        this.serviceDescriptionInterface = null;
        this.registrationInterface = null;
        this.portletManagementInterface = null;
        this.logger = null;
        this.checker = null;
    }

    public ProducerImpl() {
        this.this();
        this.portletDesc = new Hashtable();
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
        this.checker = new ParameterChecker();
    }

    public ProducerImpl(String producerID, String markupURL, String serviceDescriptionURL) throws WSRPException {
        this();
        this.producerID = producerID;
        if (markupURL != null) {
            this.markupURL = markupURL;
        } else {
            WSRPXHelper.throwX(this.logger, 10, "init", 6016);
        }
        if (serviceDescriptionURL != null) {
            this.serviceDescriptionURL = serviceDescriptionURL;
            this.initServiceDescInterface(serviceDescriptionURL);
        } else {
            WSRPXHelper.throwX(this.logger, 10, "init", 6003);
        }
    }

    public ProducerImpl(String producerID, String markupURL, String serviceDescriptionURL, String registrationURL, String portletManagementURL, RegistrationData registrationData) throws WSRPException {
        this(producerID, markupURL, serviceDescriptionURL);
        if (registrationURL != null) {
            this.initRegistrationInterface(registrationURL);
            this.registrationURL = registrationURL;
            this.consumerRegData = registrationData;
        }
        if (portletManagementURL != null) {
            this.portletManagementURL = portletManagementURL;
            this.initPortletManagementInterface(portletManagementURL);
        }
    }
}

