/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.rmi.RemoteException;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_PortletManagement_PortType;
import oasis.names.tc.wsrp.v1.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v1.types.ClientData;
import oasis.names.tc.wsrp.v1.types.ClonePortlet;
import oasis.names.tc.wsrp.v1.types.CookieProtocol;
import oasis.names.tc.wsrp.v1.types.DestroyPortlets;
import oasis.names.tc.wsrp.v1.types.DestroyPortletsResponse;
import oasis.names.tc.wsrp.v1.types.GetMarkup;
import oasis.names.tc.wsrp.v1.types.GetPortletDescription;
import oasis.names.tc.wsrp.v1.types.GetPortletProperties;
import oasis.names.tc.wsrp.v1.types.GetPortletPropertyDescription;
import oasis.names.tc.wsrp.v1.types.InitCookie;
import oasis.names.tc.wsrp.v1.types.InteractionParams;
import oasis.names.tc.wsrp.v1.types.InvalidCookieFault;
import oasis.names.tc.wsrp.v1.types.MarkupContext;
import oasis.names.tc.wsrp.v1.types.MarkupParams;
import oasis.names.tc.wsrp.v1.types.MarkupResponse;
import oasis.names.tc.wsrp.v1.types.PerformBlockingInteraction;
import oasis.names.tc.wsrp.v1.types.PortletContext;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.PortletDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PortletPropertyDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PropertyList;
import oasis.names.tc.wsrp.v1.types.RegistrationContext;
import oasis.names.tc.wsrp.v1.types.ReleaseSessions;
import oasis.names.tc.wsrp.v1.types.ReturnAny;
import oasis.names.tc.wsrp.v1.types.RuntimeContext;
import oasis.names.tc.wsrp.v1.types.ServiceDescription;
import oasis.names.tc.wsrp.v1.types.SetPortletProperties;
import oasis.names.tc.wsrp.v1.types.StateChange;
import oasis.names.tc.wsrp.v1.types.Templates;
import oasis.names.tc.wsrp.v1.types.UserContext;
import org.apache.wsrp4j.consumer.ConsumerEnvironment;
import org.apache.wsrp4j.consumer.GroupSessionMgr;
import org.apache.wsrp4j.consumer.InteractionRequest;
import org.apache.wsrp4j.consumer.MarkupRequest;
import org.apache.wsrp4j.consumer.PortletDriver;
import org.apache.wsrp4j.consumer.Producer;
import org.apache.wsrp4j.consumer.URLRewriter;
import org.apache.wsrp4j.consumer.URLTemplateComposer;
import org.apache.wsrp4j.consumer.User;
import org.apache.wsrp4j.consumer.UserSessionMgr;
import org.apache.wsrp4j.consumer.WSRPBaseRequest;
import org.apache.wsrp4j.consumer.WSRPPortlet;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.util.ParameterChecker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PortletDriverImpl
implements PortletDriver {
    private static final Logger logger;
    private WSRPPortlet portlet;
    private WSRP_v1_Markup_PortType markupPort;
    private WSRP_v1_PortletManagement_PortType portletPort;
    private ConsumerEnvironment consumerEnv;
    private Producer producer;
    private ParameterChecker parameterChecker;
    private CookieProtocol initCookie;
    static /* synthetic */ Class class$org$apache$wsrp4j$consumer$driver$PortletDriverImpl;

    public WSRPPortlet getPortlet() {
        return this.portlet;
    }

    private final void resetInitCookie(String userID) throws WSRPException {
        UserSessionMgr userSession = this.consumerEnv.getSessionHandler().getUserSession(this.getPortlet().getPortletKey().getProducerId(), userID);
        if (this.initCookie.getValue().equalsIgnoreCase("none")) {
            userSession.setInitCookieDone(false);
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            PortletDescription portletDescription = null;
            try {
                portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            }
            catch (WSRPException groupID) {
                // empty catch block
            }
            String groupID = null;
            if (portletDescription != null) {
                groupID = portletDescription.getGroupID();
            }
            if (groupID != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                groupSession.setInitCookieDone(false);
            }
        }
    }

    private final void checkInitCookie(String userID) throws WSRPException {
        UserSessionMgr userSession = this.consumerEnv.getSessionHandler().getUserSession(this.getPortlet().getPortletKey().getProducerId(), userID);
        if (this.initCookie.getValue().equalsIgnoreCase("perUser")) {
            this.markupPort = userSession.getWSRPBaseService();
            if (!userSession.isInitCookieDone()) {
                userSession.setInitCookieRequired(true);
                this.initCookie();
                userSession.setInitCookieDone(true);
            }
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            PortletDescription portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            String groupID = null;
            if (portletDescription != null) {
                groupID = portletDescription.getGroupID();
            }
            if (groupID != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                this.markupPort = groupSession.getWSRPBaseService();
                if (!groupSession.isInitCookieDone()) {
                    groupSession.setInitCookieRequired(true);
                    this.initCookie();
                    groupSession.setInitCookieDone(true);
                }
            }
        } else {
            this.markupPort = userSession.getWSRPBaseService();
        }
    }

    private final MarkupParams getMarkupParams(WSRPBaseRequest request) {
        MarkupParams markupParams = new MarkupParams();
        ClientData clientData = new ClientData();
        clientData.setUserAgent(this.producer.getRegistrationData().getConsumerAgent());
        markupParams.setClientData(clientData);
        markupParams.setSecureClientCommunication(false);
        markupParams.setLocales(this.consumerEnv.getSupportedLocales());
        markupParams.setMimeTypes(this.consumerEnv.getMimeTypes());
        markupParams.setMode(request.getMode());
        markupParams.setWindowState(request.getWindowState());
        markupParams.setNavigationalState(request.getNavigationalState());
        markupParams.setMarkupCharacterSets(this.consumerEnv.getCharacterEncodingSet());
        markupParams.setValidateTag(null);
        markupParams.setValidNewModes(this.consumerEnv.getSupportedModes());
        markupParams.setValidNewWindowStates(this.consumerEnv.getSupportedWindowStates());
        markupParams.setExtensions(null);
        return markupParams;
    }

    private final RuntimeContext getRuntimeContext(WSRPBaseRequest request) {
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication(this.consumerEnv.getUserAuthentication());
        runtimeContext.setPortletInstanceKey(request.getPortletInstanceKey());
        URLTemplateComposer templateComposer = this.consumerEnv.getTemplateComposer();
        if (templateComposer != null) {
            runtimeContext.setNamespacePrefix(templateComposer.getNamespacePrefix());
        }
        Boolean doesUrlTemplateProcess = null;
        try {
            PortletDescription desc = this.producer.getPortletDescription(this.getPortlet().getParent());
            if (desc != null) {
                doesUrlTemplateProcess = desc.getDoesUrlTemplateProcessing();
            }
        }
        catch (WSRPException e) {
            // empty catch block
        }
        if (doesUrlTemplateProcess != null && templateComposer != null && doesUrlTemplateProcess.booleanValue()) {
            Templates templates = new Templates();
            templates.setBlockingActionTemplate(templateComposer.createBlockingActionTemplate(true, true, true, true));
            templates.setRenderTemplate(templateComposer.createRenderTemplate(true, true, true, true));
            templates.setDefaultTemplate(templateComposer.createDefaultTemplate(true, true, true, true));
            templates.setResourceTemplate(templateComposer.createResourceTemplate(true, true, true, true));
            templates.setSecureBlockingActionTemplate(templateComposer.createSecureBlockingActionTemplate(true, true, true, true));
            templates.setSecureRenderTemplate(templateComposer.createSecureRenderTemplate(true, true, true, true));
            templates.setSecureDefaultTemplate(templateComposer.createSecureDefaultTemplate(true, true, true, true));
            templates.setSecureResourceTemplate(templateComposer.createSecureResourceTemplate(true, true, true, true));
            runtimeContext.setTemplates(templates);
        }
        runtimeContext.setSessionID(request.getSessionID());
        runtimeContext.setExtensions(null);
        return runtimeContext;
    }

    private final UserContext getUserContext(String userID) {
        User user;
        UserContext userContext = null;
        if (userID != null && (user = this.consumerEnv.getUserRegistry().getUser(userID)) != null) {
            userContext = user.getUserContext();
        }
        if (userContext == null) {
            userContext = new UserContext();
            userContext.setUserContextKey("dummyUserContextKey");
        }
        return userContext;
    }

    private final InteractionParams getInteractionParams(InteractionRequest actionRequest) {
        InteractionParams interactionParams = new InteractionParams();
        interactionParams.setPortletStateChange(this.consumerEnv.getPortletStateChange());
        if (!this.portlet.isConsumerConfigured() && interactionParams.getPortletStateChange().toString().equalsIgnoreCase("readWrite")) {
            interactionParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        }
        interactionParams.setInteractionState(actionRequest.getInteractionState());
        interactionParams.setFormParameters(actionRequest.getFormParameters());
        interactionParams.setUploadContexts(null);
        interactionParams.setExtensions(null);
        return interactionParams;
    }

    public MarkupResponse getMarkup(MarkupRequest markupRequest, String userID) throws WSRPException {
        this.checkInitCookie(userID);
        MarkupResponse response = null;
        try {
            URLRewriter urlRewriter;
            String rewrittenMarkup;
            MarkupContext markupContext = null;
            markupContext = markupRequest.getCachedMarkup();
            if (markupContext == null) {
                UserContext userCtx;
                GetMarkup request = new GetMarkup();
                request.setPortletContext(this.getPortlet().getPortletContext());
                request.setMarkupParams(this.getMarkupParams(markupRequest));
                request.setRuntimeContext(this.getRuntimeContext(markupRequest));
                RegistrationContext regCtx = this.producer.getRegistrationContext();
                if (regCtx != null) {
                    request.setRegistrationContext(regCtx);
                }
                if ((userCtx = this.getUserContext(userID)) != null) {
                    request.setUserContext(this.getUserContext(userID));
                }
                response = this.markupPort.getMarkup(request);
                this.parameterChecker.check(response);
            } else {
                response = new MarkupResponse();
                response.setMarkupContext(markupContext);
            }
            Boolean requiresRewriting = response.getMarkupContext().getRequiresUrlRewriting();
            Boolean bl = requiresRewriting = requiresRewriting == null ? Boolean.FALSE : requiresRewriting;
            if (requiresRewriting.booleanValue() && (rewrittenMarkup = (urlRewriter = this.consumerEnv.getURLRewriter()).rewriteURLs(response.getMarkupContext().getMarkupString())) != null) {
                response.getMarkupContext().setMarkupString(rewrittenMarkup);
            }
        }
        catch (InvalidCookieFault cookieFault) {
            this.resetInitCookie(userID);
            this.getMarkup(markupRequest, userID);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public BlockingInteractionResponse performBlockingInteraction(InteractionRequest actionRequest, String userID) throws WSRPException {
        this.checkInitCookie(userID);
        BlockingInteractionResponse response = null;
        try {
            UserContext userCtx;
            PerformBlockingInteraction request = new PerformBlockingInteraction();
            request.setPortletContext(this.getPortlet().getPortletContext());
            request.setInteractionParams(this.getInteractionParams(actionRequest));
            request.setMarkupParams(this.getMarkupParams(actionRequest));
            request.setRuntimeContext(this.getRuntimeContext(actionRequest));
            RegistrationContext regCtx = this.producer.getRegistrationContext();
            if (regCtx != null) {
                request.setRegistrationContext(regCtx);
            }
            if ((userCtx = this.getUserContext(userID)) != null) {
                request.setUserContext(userCtx);
            }
            response = this.markupPort.performBlockingInteraction(request);
            this.parameterChecker.check(response);
        }
        catch (InvalidCookieFault cookieFault) {
            this.resetInitCookie(userID);
            this.performBlockingInteraction(actionRequest, userID);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public PortletContext clonePortlet(String userID) throws WSRPException {
        UserContext userCtx;
        ClonePortlet request = new ClonePortlet();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userID)) != null) {
            request.setUserContext(userCtx);
        }
        PortletContext response = null;
        try {
            response = this.portletPort.clonePortlet(request);
            this.parameterChecker.check(response, false);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public DestroyPortletsResponse destroyPortlets(String[] portletHandles, String userID) throws WSRPException {
        DestroyPortlets request = new DestroyPortlets();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletHandles(portletHandles);
        DestroyPortletsResponse response = null;
        try {
            response = this.portletPort.destroyPortlets(request);
            this.parameterChecker.check(response);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public ReturnAny releaseSessions(String[] sessionIDs, String userID) throws WSRPException {
        this.checkInitCookie(userID);
        ReleaseSessions request = new ReleaseSessions();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setSessionIDs(sessionIDs);
        ReturnAny response = null;
        try {
            response = this.markupPort.releaseSessions(request);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public void initCookie() throws WSRPException {
        InitCookie request = new InitCookie();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        try {
            this.markupPort.initCookie(request);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
    }

    public PortletDescriptionResponse getPortletDescription(String userID, String[] desiredLocales) throws WSRPException {
        GetPortletDescription request = new GetPortletDescription();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletContext(this.getPortlet().getPortletContext());
        UserContext userCtx = this.getUserContext(userID);
        if (userCtx != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(desiredLocales);
        PortletDescriptionResponse response = null;
        try {
            response = this.portletPort.getPortletDescription(request);
            this.parameterChecker.check(response);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(String userID) throws WSRPException {
        UserContext userCtx;
        GetPortletPropertyDescription request = new GetPortletPropertyDescription();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userID)) != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(this.consumerEnv.getSupportedLocales());
        PortletPropertyDescriptionResponse response = null;
        try {
            response = this.portletPort.getPortletPropertyDescription(request);
            this.parameterChecker.check(response);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public PropertyList getPortletProperties(String[] names, String userID) throws WSRPException {
        UserContext userCtx;
        GetPortletProperties request = new GetPortletProperties();
        request.setPortletContext(this.getPortlet().getPortletContext());
        request.setNames(names);
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userID)) != null) {
            request.setUserContext(userCtx);
        }
        PropertyList response = null;
        try {
            response = this.portletPort.getPortletProperties(request);
            this.parameterChecker.check(response, false);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    public PortletContext setPortletProperties(PropertyList properties, String userID) throws WSRPException {
        UserContext userCtx;
        SetPortletProperties request = new SetPortletProperties();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userID)) != null) {
            request.setUserContext(userCtx);
        }
        request.setPropertyList(properties);
        PortletContext response = null;
        try {
            response = this.portletPort.setPortletProperties(request);
            this.parameterChecker.check(response, false);
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault(logger, wsrpFault);
        }
        return response;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.portlet = null;
        this.markupPort = null;
        this.portletPort = null;
        this.consumerEnv = null;
        this.producer = null;
        this.parameterChecker = null;
        this.initCookie = CookieProtocol.none;
    }

    public PortletDriverImpl(WSRPPortlet portlet, ConsumerEnvironment consumerEnv) throws WSRPException {
        this.this();
        this.parameterChecker = new ParameterChecker();
        this.consumerEnv = consumerEnv;
        this.portlet = portlet;
        this.producer = consumerEnv.getProducerRegistry().getProducer(portlet.getPortletKey().getProducerId());
        this.portletPort = this.producer.getPortletManagementInterface();
        ServiceDescription serviceDescription = this.producer.getServiceDescription(false);
        if (serviceDescription != null) {
            this.initCookie = serviceDescription.getRequiresInitCookie();
            if (this.initCookie == null) {
                this.initCookie = CookieProtocol.none;
            }
        }
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        Class clazz = class$org$apache$wsrp4j$consumer$driver$PortletDriverImpl;
        if (clazz == null) {
            clazz = class$org$apache$wsrp4j$consumer$driver$PortletDriverImpl = PortletDriverImpl.class("[Lorg.apache.wsrp4j.consumer.driver.PortletDriverImpl;", false);
        }
        logger = logManager.getLogger(clazz);
    }
}

