/*
 * Decompiled with CFR 0.152.
 */
package com.proveo.ad.ldap;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPAuthenticator {
    public static final String USE_OBJECT_CREDENTIAL_OPT = "useObjectCredential";
    public static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    public static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    public static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    public static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    public static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    public static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    public static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    public static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    public static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final Log log = LogFactory.getLog(LDAPAuthenticator.class);
    private Map<String, String> options;

    protected InitialLdapContext login(Properties env) throws AccessDeniedException {
        InitialLdapContext ctx;
        try {
            log.trace((Object)("Logging into LDAP server, env=" + env));
            ctx = new InitialLdapContext(env, null);
            log.trace((Object)("Logged into LDAP server, " + ctx));
        }
        catch (NamingException ex) {
            log.error((Object)"login runs into", (Throwable)ex);
            throw new AccessDeniedException();
        }
        return ctx;
    }

    public void configure(Map<String, String> options) {
        this.options = options;
    }

    protected Properties prepareEnvironment(String username, String credential) {
        String principalDNSuffix;
        String principalDNPrefix;
        String authType;
        if (this.options == null) {
            throw new IllegalStateException("call configure first!");
        }
        Properties env = new Properties();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = protocol != null && protocol.equals("ssl") ? "ldaps://" : "ldap://";
            providerURL = providerURL + "localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        if ((principalDNPrefix = this.options.get(PRINCIPAL_DN_PREFIX_OPT)) == null) {
            principalDNPrefix = "";
        }
        if ((principalDNSuffix = this.options.get(PRINCIPAL_DN_SUFFIX_OPT)) == null) {
            principalDNSuffix = "";
        }
        String userDN = principalDNPrefix + username + principalDNSuffix;
        env.setProperty("java.naming.provider.url", providerURL);
        env.setProperty("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", credential);
        return env;
    }

    protected User loadUser(InitialLdapContext ctx, Properties env, String username) {
        User user = new User();
        user.username = username;
        user.securityPrincipal = env.getProperty("java.naming.security.principal");
        String rolesCtxDN = this.options.get(ROLES_CTX_DN_OPT);
        String userRolesCtxDNAttributeName = this.options.get(USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT);
        if (userRolesCtxDNAttributeName != null) {
            String[] returnAttribute = new String[]{userRolesCtxDNAttributeName};
            try {
                Attributes result = ctx.getAttributes(env.getProperty("java.naming.security.principal"), returnAttribute);
                if (result.get(userRolesCtxDNAttributeName) != null) {
                    rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
                    log.trace((Object)("Found user roles context DN: " + rolesCtxDN));
                }
            }
            catch (NamingException e) {
                log.debug((Object)"Failed to query userRolesCtxDNAttributeName", (Throwable)e);
            }
        }
        if (rolesCtxDN != null) {
            String roleAttrName;
            String matchType = this.options.get(MATCH_ON_USER_DN_OPT);
            boolean matchOnUserDN = Boolean.valueOf(matchType);
            String uidAttrName = this.options.get(UID_ATTRIBUTE_ID_OPT);
            if (uidAttrName == null) {
                uidAttrName = "uid";
            }
            if ((roleAttrName = this.options.get(ROLE_ATTRIBUTE_ID_OPT)) == null) {
                roleAttrName = "roles";
            }
            BasicAttributes matchAttrs = new BasicAttributes(true);
            if (matchOnUserDN) {
                matchAttrs.put(uidAttrName, env.getProperty("java.naming.security.principal"));
            } else {
                matchAttrs.put(uidAttrName, username);
            }
            String[] roleAttr = new String[]{roleAttrName};
            String roleAttributeIsDNOption = this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
            boolean roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
            String roleNameAttributeID = this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
            if (roleNameAttributeID == null) {
                roleNameAttributeID = "name";
            }
            try {
                SearchControls controls = new SearchControls();
                controls.setSearchScope(2);
                controls.setReturningAttributes(roleAttr);
                NamingEnumeration<SearchResult> answer = ctx.search(rolesCtxDN, "(& (sAMAccountName=" + username + ")(objectClass=user))", controls);
                while (answer.hasMore()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    Attribute roles = attrs.get(roleAttrName);
                    for (int r = 0; r < roles.size(); ++r) {
                        Object value = roles.get(r);
                        String roleName = null;
                        if (roleAttributeIsDN) {
                            String roleDN = value.toString();
                            String[] returnAttribute = new String[]{roleNameAttributeID};
                            log.trace((Object)("Using roleDN: " + roleDN));
                            try {
                                Attributes result = ctx.getAttributes(roleDN, returnAttribute);
                                if (result.get(roleNameAttributeID) != null) {
                                    roleName = result.get(roleNameAttributeID).get().toString();
                                }
                            }
                            catch (NamingException e) {
                                log.trace((Object)"Failed to query roleNameAttrName", (Throwable)e);
                            }
                        } else {
                            roleName = value.toString();
                        }
                        if (roleName == null) continue;
                        try {
                            user.roles.add(roleName);
                            log.trace((Object)("Assign user to role " + roleName));
                            continue;
                        }
                        catch (Exception e) {
                            log.debug((Object)("Failed to create principal: " + roleName), (Throwable)e);
                        }
                    }
                }
            }
            catch (NamingException e) {
                log.trace((Object)"Failed to locate roles", (Throwable)e);
            }
        }
        return user;
    }

    public User authenticate(String username, String credential) throws AccessDeniedException {
        Properties env = this.prepareEnvironment(username, credential);
        InitialLdapContext ctx = this.login(env);
        User user = this.loadUser(ctx, env, username);
        try {
            ctx.close();
        }
        catch (NamingException ex) {
            log.warn((Object)"runs during close LDAP context into", (Throwable)ex);
        }
        return user;
    }

    public class AccessDeniedException
    extends Exception {
    }

    public class User {
        private String username;
        private final Set<String> roles = new HashSet<String>();
        private String securityPrincipal;

        public String getUsername() {
            return this.username;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getSecurityPrincipal() {
            return this.securityPrincipal;
        }
    }
}

