/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    private String algorithm = "EC";
    private BigInteger d;
    private ECParameterSpec ecSpec;
    private boolean withCompression = true;
    private Hashtable pkcs12Attributes = new Hashtable();
    private Vector pkcs12Ordering = new Vector();

    protected JCEECPrivateKey() {
    }

    JCEECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    JCEECPrivateKey(String string, org.bouncycastle.jce.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        ECCurve.Fp fp = (ECCurve.Fp)eCPrivateKeySpec.getParams().getCurve();
        this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), eCPrivateKeySpec.getParams().getSeed()), new ECPoint(eCPrivateKeySpec.getParams().getG().getX().toBigInteger(), eCPrivateKeySpec.getParams().getG().getY().toBigInteger()), eCPrivateKeySpec.getParams().getN(), eCPrivateKeySpec.getParams().getH().intValue());
    }

    JCEECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECCurve.Fp fp = (ECCurve.Fp)eCDomainParameters.getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), eCDomainParameters.getSeed()), new ECPoint(eCDomainParameters.getG().getX().toBigInteger(), eCDomainParameters.getG().getY().toBigInteger()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.ecSpec = eCParameterSpec;
        }
    }

    JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            ECCurve.Fp fp = (ECCurve.Fp)eCDomainParameters.getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), eCDomainParameters.getSeed()), new ECPoint(eCDomainParameters.getG().getX().toBigInteger(), eCDomainParameters.getG().getY().toBigInteger()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            ECCurve.Fp fp = (ECCurve.Fp)eCParameterSpec.getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), eCParameterSpec.getSeed()), new ECPoint(eCParameterSpec.getG().getX().toBigInteger(), eCParameterSpec.getG().getY().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
    }

    JCEECPrivateKey(PrivateKeyInfo privateKeyInfo) {
        ASN1Encodable aSN1Encodable;
        X962Parameters x962Parameters = new X962Parameters((DERObject)privateKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            X9ECParameters x9ECParameters = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
            ECCurve.Fp fp = (ECCurve.Fp)x9ECParameters.getCurve();
            this.ecSpec = new ECNamedCurveSpec(X962NamedCurves.getName((DERObjectIdentifier)aSN1Encodable), new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), x9ECParameters.getSeed()), new ECPoint(x9ECParameters.getG().getX().toBigInteger(), x9ECParameters.getG().getY().toBigInteger()), x9ECParameters.getN(), x9ECParameters.getH());
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            ECCurve.Fp fp = (ECCurve.Fp)((X9ECParameters)aSN1Encodable).getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), ((X9ECParameters)aSN1Encodable).getSeed()), new ECPoint(((X9ECParameters)aSN1Encodable).getG().getX().toBigInteger(), ((X9ECParameters)aSN1Encodable).getG().getY().toBigInteger()), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH().intValue());
        }
        if (privateKeyInfo.getPrivateKey() instanceof DERInteger) {
            aSN1Encodable = (DERInteger)privateKeyInfo.getPrivateKey();
            this.d = ((DERInteger)aSN1Encodable).getValue();
        } else {
            aSN1Encodable = new ECPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            this.d = ((ECPrivateKeyStructure)aSN1Encodable).getKey();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveSpec) {
            x962Parameters = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()));
        } else {
            object = new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
            X9ECParameters x9ECParameters = new X9ECParameters((ECCurve)object, new ECPoint.Fp((ECCurve)object, new ECFieldElement.Fp(((ECCurve.Fp)object).getQ(), this.ecSpec.getGenerator().getAffineX()), new ECFieldElement.Fp(((ECCurve.Fp)object).getQ(), this.ecSpec.getGenerator().getAffineY()), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        object = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, x962Parameters.getDERObject()), new ECPrivateKeyStructure(this.getS()).getDERObject()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), new ECPrivateKeyStructure(this.getS()).getDERObject());
        try {
            dEROutputStream.writeObject(object);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC private key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public org.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECCurve.Fp fp = new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
        return new org.bouncycastle.jce.spec.ECParameterSpec(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), this.ecSpec.getGenerator().getAffineX()), new ECFieldElement.Fp(fp.getQ(), this.ecSpec.getGenerator().getAffineY())), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
    }

    public BigInteger getS() {
        return this.d;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.pkcs12Attributes.put(dERObjectIdentifier, dEREncodable);
        this.pkcs12Ordering.addElement(dERObjectIdentifier);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier dERObjectIdentifier) {
        return (DEREncodable)this.pkcs12Attributes.get(dERObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.pkcs12Ordering.elements();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equals(string);
    }
}

