/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.util.regex.Pattern;
import net.sf.uadetector.internal.data.OrderedPattern;
import net.sf.uadetector.internal.util.RegularExpressionConverter;

public final class OperatingSystemPattern
implements OrderedPattern<OperatingSystemPattern> {
    private final int id;
    private final Pattern pattern;
    private final int position;

    public OperatingSystemPattern(int id, Pattern pattern, int position) {
        if (id < 0) {
            throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 'pattern' must not be null.");
        }
        if (position < 0) {
            throw new IllegalArgumentException("Argument 'position' must not be smaller than 0.");
        }
        this.id = id;
        this.pattern = pattern;
        this.position = position;
    }

    @Override
    public int compareTo(OperatingSystemPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 'pattern' must not be null.");
        }
        int result = 0;
        if (this.getPosition() > pattern.getPosition()) {
            result = 1;
        } else if (this.getPosition() < pattern.getPosition()) {
            result = -1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystemPattern other = (OperatingSystemPattern)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        if (!this.pattern.pattern().equals(other.pattern.pattern())) {
            return false;
        }
        return this.pattern.flags() == other.pattern.flags();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.position;
        result = 31 * result + this.pattern.pattern().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatingSystemPattern [id=");
        builder.append(this.id);
        builder.append(", pattern=");
        builder.append(this.pattern);
        builder.append(", position=");
        builder.append(this.position);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private int id = Integer.MIN_VALUE;
        private Pattern pattern;
        private int position = Integer.MIN_VALUE;

        public OperatingSystemPattern build() {
            return new OperatingSystemPattern(this.id, this.pattern, this.position);
        }

        public Builder setId(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
            }
            this.id = id;
            return this;
        }

        public Builder setId(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 'id' must not be null.");
            }
            this.setId(Integer.parseInt(id));
            return this;
        }

        public Builder setPattern(Pattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("Argument 'pattern' must not be null.");
            }
            this.pattern = pattern;
            return this;
        }

        public Builder setPerlRegularExpression(String regex) {
            if (regex == null) {
                throw new IllegalArgumentException("Argument 'regex' must not be null.");
            }
            this.setPattern(RegularExpressionConverter.convertPerlRegexToPattern(regex));
            return this;
        }

        public Builder setPosition(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Argument 'position' must not be null.");
            }
            this.position = position;
            return this;
        }

        public Builder setPosition(String position) {
            if (position == null) {
                throw new IllegalArgumentException("Argument 'position' must not be null.");
            }
            this.setPosition(Integer.parseInt(position));
            return this;
        }
    }
}

