/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.filters.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompressionStream
extends ServletOutputStream {
    private static final String _CONTENT_ENCODING = "Content-Encoding";
    private static final String _GZIP = "gzip";
    private static Log _log;
    private HttpServletResponse _res;
    private ServletOutputStream _output;
    private OutputStream _bufferedOutput;
    private boolean _closed;
    static /* synthetic */ Class class$com$liferay$filters$compression$CompressionStream;

    public void close() throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        if (this._bufferedOutput instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this._bufferedOutput;
            ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutput = new GZIPOutputStream(compressedContent);
            gzipOutput.write(baos.toByteArray());
            gzipOutput.finish();
            byte[] compressedBytes = compressedContent.toByteArray();
            this._res.setContentLength(compressedBytes.length);
            this._res.addHeader(_CONTENT_ENCODING, _GZIP);
            this._output.write(compressedBytes);
            this._output.flush();
            this._output.close();
            this._closed = true;
        } else if (this._bufferedOutput instanceof GZIPOutputStream) {
            GZIPOutputStream gzipOutput = (GZIPOutputStream)this._bufferedOutput;
            gzipOutput.finish();
            this._output.flush();
            this._output.close();
            this._closed = true;
        }
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._bufferedOutput.flush();
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._bufferedOutput.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        try {
            this._bufferedOutput.write(b, off, len);
        }
        catch (IOException ioe) {
            _log.warn((Object)ioe.getMessage());
        }
    }

    public boolean closed() {
        return this._closed;
    }

    public void reset() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this._res = null;
        this._output = null;
        this._bufferedOutput = null;
        this._closed = false;
    }

    public CompressionStream(HttpServletResponse res) throws IOException {
        this.this();
        this._res = res;
        this._output = res.getOutputStream();
        this._bufferedOutput = new ByteArrayOutputStream();
        this._closed = false;
    }

    static {
        Class clazz = class$com$liferay$filters$compression$CompressionStream;
        if (clazz == null) {
            clazz = class$com$liferay$filters$compression$CompressionStream = CompressionStream.class("[Lcom.liferay.filters.compression.CompressionStream;", false);
        }
        _log = LogFactory.getLog((Class)clazz);
    }
}

