/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.filters.compression;

import com.liferay.filters.compression.CompressionResponse;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.util.BrowserSniffer;
import com.liferay.util.GetterUtil;
import com.liferay.util.Http;
import com.liferay.util.ParamUtil;
import com.liferay.util.SystemProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompressionFilter
implements Filter {
    static boolean useCompressionFilter;
    public static final String ENCODING;
    private static final String _ALREADY_FILTERED;
    private static final String _COMPRESS = "compress";
    private static final String _INCLUDE = "javax.servlet.include.request_uri";
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$filters$compression$CompressionFilter;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            if (useCompressionFilter) {
                _log.debug((Object)"Compression is enabled");
            } else {
                _log.debug((Object)"Compression is disabled");
            }
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        httpReq.setCharacterEncoding(ENCODING);
        String completeURL = Http.getCompleteURL((HttpServletRequest)httpReq);
        if (useCompressionFilter && this.isCompress(httpReq) && !this.isInclude(httpReq) && BrowserSniffer.acceptsGzip((HttpServletRequest)httpReq) && !this.isAlreadyFiltered(httpReq)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Compressing " + completeURL));
            }
            httpReq.setAttribute(_ALREADY_FILTERED, (Object)Boolean.TRUE);
            CompressionResponse compressionResponse = new CompressionResponse(httpRes);
            chain.doFilter(req, (ServletResponse)compressionResponse);
            compressionResponse.finishResponse();
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not compressing " + completeURL));
            }
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    protected boolean isAlreadyFiltered(HttpServletRequest req) {
        return req.getAttribute(_ALREADY_FILTERED) != null;
    }

    protected boolean isCompress(HttpServletRequest req) {
        if (!ParamUtil.get((ServletRequest)req, (String)_COMPRESS, (boolean)true)) {
            return false;
        }
        String windowState = ParamUtil.getString((ServletRequest)req, (String)"p_p_state");
        return !windowState.equals("exclusive");
    }

    protected boolean isInclude(HttpServletRequest req) {
        String uri = (String)req.getAttribute(_INCLUDE);
        return uri != null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$liferay$filters$compression$CompressionFilter;
        if (clazz == null) {
            clazz = class$com$liferay$filters$compression$CompressionFilter = CompressionFilter.class("[Lcom.liferay.filters.compression.CompressionFilter;", false);
        }
        if (useCompressionFilter = GetterUtil.getBoolean((String)SystemProperties.get((String)clazz.getName()), (boolean)true)) {
            useCompressionFilter = ServerDetector.isJBoss() || ServerDetector.isJetty() || ServerDetector.isJOnAS() || ServerDetector.isOC4J() || ServerDetector.isOrion() || ServerDetector.isTomcat();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz2 = class$com$liferay$filters$compression$CompressionFilter;
        if (clazz2 == null) {
            clazz2 = class$com$liferay$filters$compression$CompressionFilter = CompressionFilter.class("[Lcom.liferay.filters.compression.CompressionFilter;", false);
        }
        ENCODING = GetterUtil.getString((String)SystemProperties.get((String)stringBuffer.append(clazz2.getName()).append(".encoding").toString()), (String)"UTF-8");
        StringBuffer stringBuffer2 = new StringBuffer();
        Class clazz3 = class$com$liferay$filters$compression$CompressionFilter;
        if (clazz3 == null) {
            clazz3 = class$com$liferay$filters$compression$CompressionFilter = CompressionFilter.class("[Lcom.liferay.filters.compression.CompressionFilter;", false);
        }
        _ALREADY_FILTERED = stringBuffer2.append(clazz3).append("_ALREADY_FILTERED").toString();
        Class clazz4 = class$com$liferay$filters$compression$CompressionFilter;
        if (clazz4 == null) {
            clazz4 = class$com$liferay$filters$compression$CompressionFilter = CompressionFilter.class("[Lcom.liferay.filters.compression.CompressionFilter;", false);
        }
        _log = LogFactory.getLog((Class)clazz4);
    }
}

