/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.skin.AbstractSkinFactory;
import org.richfaces.skin.CompositeSkinImpl;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinNotFoundException;
import org.richfaces.skin.Theme;
import org.richfaces.skin.ThemeImpl;
import org.richfaces.skin.ThemeNotFoundException;

public class SkinFactoryImpl
extends AbstractSkinFactory {
    private static final String SKIN_KEY = SkinFactoryImpl.class.getName() + ":skin";
    private static final String BASE_SKIN_KEY = SkinFactoryImpl.class.getName() + ":baseSkin";
    private static final String DEFAULT_SKIN_NAME = "DEFAULT";
    private static final String[] THEME_PATHS = new String[]{"META-INF/themes/%s.theme.properties", "%s.theme.properties"};
    private Map<String, Theme> themes = new HashMap<String, Theme>();

    public Skin getDefaultSkin(FacesContext context) {
        return this.getSkin(context, DEFAULT_SKIN_NAME);
    }

    public Skin getSkin(FacesContext context) {
        Skin skin = (Skin)context.getAttributes().get(SKIN_KEY);
        if (skin == null) {
            Skin mainSkin = this.getSkinOrName(context, false);
            Skin baseSkin = this.getSkinOrName(context, true);
            skin = mainSkin != null || baseSkin != null ? new CompositeSkinImpl(mainSkin, baseSkin) : new CompositeSkinImpl(this.getDefaultSkin(context));
            context.getAttributes().put(SKIN_KEY, skin);
        }
        return skin;
    }

    public Skin getBaseSkin(FacesContext context) {
        Skin skin = (Skin)context.getAttributes().get(BASE_SKIN_KEY);
        if (skin == null) {
            Skin baseSkin = this.getSkinOrName(context, true);
            skin = baseSkin != null ? new CompositeSkinImpl(baseSkin) : new CompositeSkinImpl(this.getDefaultSkin(context));
            context.getAttributes().put(BASE_SKIN_KEY, skin);
        }
        return skin;
    }

    static void clearSkinCaches(FacesContext context) {
        context.getAttributes().remove(BASE_SKIN_KEY);
        context.getAttributes().remove(SKIN_KEY);
    }

    protected Skin getSkinOrName(FacesContext context, boolean useBase) {
        Object skinObject = ConfigurationServiceHelper.getConfigurationValue((FacesContext)context, (Enum)(useBase ? CoreConfiguration.Items.baseSkin : CoreConfiguration.Items.skin));
        Skin result = null;
        if (skinObject instanceof Skin) {
            result = (Skin)skinObject;
        } else if (skinObject != null) {
            result = this.getSkin(context, (String)skinObject);
        }
        return result;
    }

    public Theme getTheme(FacesContext facesContext, String name) {
        Theme theme = this.themes.get(name);
        if (null == theme) {
            Properties properties;
            try {
                properties = this.loadProperties(name, THEME_PATHS);
            }
            catch (SkinNotFoundException e) {
                throw new ThemeNotFoundException(Messages.getMessage((String)"THEME_NOT_FOUND_ERROR", (Object)name), e.getCause());
            }
            this.processProperties(facesContext, properties);
            theme = new ThemeImpl(properties);
            this.themes.put(name, theme);
        }
        return theme;
    }
}

