/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalStaticResourceFactory;

public class MojarraExternalResourceTracker
implements ExternalResourceTracker {
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        Map contextMap = facesContext.getAttributes();
        String key = resourceKey.getResourceName() + resourceKey.getLibraryName();
        return contextMap.containsKey(key);
    }

    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        Map contextMap = facesContext.getAttributes();
        String resourceName = resourceKey.getResourceName();
        String libraryName = resourceKey.getLibraryName();
        String key = resourceName + libraryName;
        this.putToContext(contextMap, key);
        if (libraryName == null || libraryName.isEmpty()) {
            libraryName = "null";
            key = resourceName + libraryName;
            this.putToContext(contextMap, key);
        }
    }

    public void markExternalResourceRendered(FacesContext facesContext, ExternalResource resource) {
        ExternalStaticResourceFactory externalStaticResourceFactory = (ExternalStaticResourceFactory)ServiceTracker.getService(ExternalStaticResourceFactory.class);
        Set resourcesKeys = externalStaticResourceFactory.getResourcesForLocation(resource.getExternalLocation());
        for (ResourceKey resourceKey : resourcesKeys) {
            this.markResourceRendered(facesContext, resourceKey);
        }
    }

    private void putToContext(Map<Object, Object> contextMap, String key) {
        if (!contextMap.containsKey(key)) {
            contextMap.put(key, Boolean.TRUE);
        }
    }
}

