/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.Collections;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.richfaces.context.ComponentCallback;
import org.richfaces.renderkit.util.CoreRendererUtils;

class RenderComponentCallback
extends ComponentCallback {
    private Collection<String> renderIds = null;
    private boolean limitRender = false;
    private String oncomplete;
    private String onbeforedomupdate;
    private Object data;

    RenderComponentCallback(FacesContext facesContext, String behaviorEvent) {
        super(facesContext, behaviorEvent);
    }

    public boolean isLimitRender() {
        return this.limitRender;
    }

    public String getOnbeforedomupdate() {
        return this.onbeforedomupdate;
    }

    public String getOncomplete() {
        return this.oncomplete;
    }

    public Object getData() {
        return this.data;
    }

    public Collection<String> getRenderIds() {
        return this.renderIds != null ? this.renderIds : Collections.emptySet();
    }

    @Override
    protected void doVisit(UIComponent target, AjaxClientBehavior behavior) {
        Collection<Object> renderValue;
        if (behavior != null) {
            renderValue = behavior.getRender();
            this.limitRender = behavior.isLimitRender();
            this.onbeforedomupdate = behavior.getOnbeforedomupdate();
            this.oncomplete = behavior.getOncomplete();
            this.data = behavior.getData();
        } else {
            renderValue = target.getAttributes().get("render");
            this.limitRender = this.isTrue(target.getAttributes().get("limitRender"));
            this.onbeforedomupdate = (String)target.getAttributes().get("onbeforedomupdate");
            this.oncomplete = (String)target.getAttributes().get("oncomplete");
            this.data = target.getAttributes().get("data");
        }
        Collection<String> unresolvedRenderIds = this.toCollection(renderValue);
        this.renderIds = CoreRendererUtils.INSTANCE.findComponentsFor(this.facesContext, target, unresolvedRenderIds);
    }

    private boolean isTrue(Object value) {
        boolean result = false;
        result = value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(String.valueOf(value)).booleanValue();
        return result;
    }
}

