/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

class _ComponentUtils {
    private _ComponentUtils() {
    }

    static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        FacesMessage facesMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }

    static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

