/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLFormatter {
    public static final String ENCODING = "UTF-8";
    public static final String INDENT = "\t";

    public static String fixProlog(String xml) {
        if (xml != null) {
            char[] charArray = xml.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                if (charArray[i] == '<') {
                    if (i == 0) break;
                    xml = xml.substring(i, xml.length());
                    break;
                }
                ++i;
            }
        }
        return xml;
    }

    public static String fromCompactSafe(String xml) {
        return StringUtil.replace(xml, "[$NEW_LINE$]", "\n");
    }

    public static String toCompactSafe(String xml) {
        return StringUtil.replace(xml, "\n", "[$NEW_LINE$]");
    }

    public static String toString(String xml) throws DocumentException, IOException {
        return XMLFormatter.toString(xml, INDENT);
    }

    public static String toString(String xml, String indent) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(xml));
        return XMLFormatter.toString((Branch)doc, indent);
    }

    public static String toString(Branch branch) throws IOException {
        return XMLFormatter.toString(branch, INDENT);
    }

    public static String toString(Branch branch, String indent) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndent(indent);
        format.setLineSeparator("\n");
        XMLWriter writer = new XMLWriter((OutputStream)baos, format);
        writer.write((Node)branch);
        String content = baos.toString(ENCODING);
        int x = content.indexOf("<!DOCTYPE");
        if (x != -1) {
            x = content.indexOf(">", x) + 1;
            content = content.substring(0, x) + '\n' + content.substring(x, content.length());
        }
        if ((content = StringUtil.replace(content, "\n\n\n", "\n\n")).endsWith("\n\n")) {
            content = content.substring(0, content.length() - 2);
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        while (content.indexOf(" \n") != -1) {
            content = StringUtil.replace(content, " \n", "\n");
        }
        return content;
    }
}

