/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.dao.hibernate;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.util.Randomizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;

public class QueryUtil {
    public static final int ALL_POS = -1;

    public static Iterator iterate(Query query, Dialect dialect, int begin, int end) {
        return QueryUtil.list(query, dialect, begin, end).iterator();
    }

    public static List list(Query query, Dialect dialect, int begin, int end) {
        if (begin == -1 && end == -1) {
            return query.list();
        }
        if (dialect.supportsLimit()) {
            query.setMaxResults(end - begin);
            query.setFirstResult(begin);
            return query.list();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ScrollableResults sr = query.scroll();
        if (sr.first() && sr.scroll(begin)) {
            int i = begin;
            while (i < end) {
                Object obj = sr.get(0);
                list.add(obj);
                if (!sr.next()) break;
                ++i;
            }
        }
        return list;
    }

    public static List randomList(Query query, Dialect dialect, int total, int num) {
        if (total == 0 || num == 0) {
            return new ArrayList();
        }
        if (num >= total) {
            return QueryUtil.list(query, dialect, -1, -1);
        }
        int[] scrollIds = Randomizer.getInstance().nextInt(total, num);
        ArrayList<Object> list = new ArrayList<Object>();
        ScrollableResults sr = query.scroll();
        int i = 0;
        while (i < scrollIds.length) {
            if (sr.scroll(scrollIds[i])) {
                Object obj = sr.get(0);
                list.add(obj);
                sr.first();
            }
            ++i;
        }
        return list;
    }

    public static Comparable[] getPrevAndNext(Query query, int count, OrderByComparator obc, Comparable comparable) {
        Comparable[] array = new Comparable[3];
        ScrollableResults sr = query.scroll();
        if (sr.first()) {
            Object obj;
            while ((obj = sr.get(0)) != null) {
                Comparable curComparable = (Comparable)obj;
                int value = obc.compare((Object)comparable, (Object)curComparable);
                if (value == 0) {
                    if (!comparable.equals(curComparable)) break;
                    array[1] = curComparable;
                    if (sr.previous()) {
                        array[0] = (Comparable)sr.get(0);
                    }
                    sr.next();
                    if (!sr.next()) break;
                    array[2] = (Comparable)sr.get(0);
                    break;
                }
                if (count == 1) break;
                count = (int)Math.ceil((double)count / (double)2);
                if (!(value < 0 ? !sr.scroll(count * -1) : !sr.scroll(count))) continue;
                break;
            }
        }
        return array;
    }
}

