/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.axis;

import com.liferay.util.GetterUtil;
import com.liferay.util.SystemProperties;
import com.liferay.util.axis.SimpleAuthenticator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Pattern;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleHTTPSender
extends HTTPSender {
    public static final String URL_REGEXP_PATTERN;
    public static final Pattern URL_PATTERN;
    private static ThreadLocal _currentCookie;
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$util$axis$SimpleHTTPSender;

    public void invoke(MessageContext ctx) throws AxisFault {
        String url = ctx.getStrProp("transport.url");
        if (URL_PATTERN.matcher(url).matches()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("A match was found for " + url));
            }
            this._invoke(ctx, url);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No match was found for " + url));
            }
            super.invoke(ctx);
            this._registerCurrentCookie(ctx);
        }
    }

    public static String getCurrentCookie() {
        return (String)_currentCookie.get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _invoke(MessageContext ctx, String url) throws AxisFault {
        try {
            try {
                String userName = ctx.getUsername();
                String password = ctx.getPassword();
                if (userName != null && password != null) {
                    Authenticator.setDefault(new SimpleAuthenticator(userName, password));
                }
                URL urlObj = new URL(url);
                URLConnection urlc = urlObj.openConnection();
                this._writeToConnection(urlc, ctx);
                this._readFromConnection(urlc, ctx);
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            Authenticator.setDefault(null);
            throw throwable;
        }
        {
            Object var4_10 = null;
        }
        Authenticator.setDefault(null);
    }

    private final void _writeToConnection(URLConnection urlc, MessageContext ctx) throws Exception {
        urlc.setDoOutput(true);
        Message request = ctx.getRequestMessage();
        String contentType = request.getContentType(ctx.getSOAPConstants());
        urlc.setRequestProperty("Content-Type", contentType);
        if (ctx.useSOAPAction()) {
            urlc.setRequestProperty("SOAPAction", ctx.getSOAPActionURI());
        }
        BufferedOutputStream out = new BufferedOutputStream(urlc.getOutputStream(), 8192);
        request.writeTo((OutputStream)out);
        ((OutputStream)out).flush();
    }

    private final void _readFromConnection(URLConnection urlc, MessageContext ctx) throws Exception {
        String contentType = urlc.getContentType();
        String contentLocation = urlc.getHeaderField("Content-Location");
        InputStream in = ((HttpURLConnection)urlc).getErrorStream();
        if (in == null) {
            in = urlc.getInputStream();
        }
        in = new BufferedInputStream(in, 8192);
        Message response = new Message((Object)in, false, contentType, contentLocation);
        response.setMessageType("response");
        ctx.setResponseMessage(response);
    }

    private final void _registerCurrentCookie(MessageContext ctx) {
        String cookie = "";
        try {
            cookie = GetterUtil.getString(ctx.getStrProp("Cookie"));
        }
        catch (Throwable t) {
            _log.warn((Object)t);
        }
        _currentCookie.set(cookie);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$com$liferay$util$axis$SimpleHTTPSender;
        if (clazz == null) {
            clazz = class$com$liferay$util$axis$SimpleHTTPSender = SimpleHTTPSender.class("[Lcom.liferay.util.axis.SimpleHTTPSender;", false);
        }
        URL_REGEXP_PATTERN = GetterUtil.getString(SystemProperties.get(stringBuffer.append(clazz.getName()).append(".regexp.pattern").toString()));
        URL_PATTERN = Pattern.compile(URL_REGEXP_PATTERN);
        _currentCookie = new ThreadLocal(){

            protected final Object initialValue() {
                return "";
            }
        };
        Class clazz2 = class$com$liferay$util$axis$SimpleHTTPSender;
        if (clazz2 == null) {
            clazz2 = class$com$liferay$util$axis$SimpleHTTPSender = SimpleHTTPSender.class("[Lcom.liferay.util.axis.SimpleHTTPSender;", false);
        }
        _log = LogFactory.getLog((Class)clazz2);
    }
}

