/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.CollectionFactory;
import com.liferay.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

public class SetUtil {
    public static Set fromArray(Object[] array) {
        if (array == null || array.length == 0) {
            return CollectionFactory.getHashSet();
        }
        Set set = CollectionFactory.getHashSet(array.length);
        int i = 0;
        while (i < array.length) {
            set.add(array[i]);
            ++i;
        }
        return set;
    }

    public static Set fromFile(String fileName) throws IOException {
        return SetUtil.fromFile(new File(fileName));
    }

    public static Set fromFile(File file) throws IOException {
        Set set = CollectionFactory.getHashSet();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String s = "";
        while ((s = br.readLine()) != null) {
            set.add(s);
        }
        br.close();
        return set;
    }

    public static Set fromString(String s) {
        return SetUtil.fromArray(StringUtil.split(s, "\n"));
    }
}

