/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.util.EncryptorException;
import com.liferay.util.GetterUtil;
import com.liferay.util.SystemProperties;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Encryptor {
    public static final String ENCODING = "UTF-8";
    public static final String KEY_ALGORITHM = "DES";
    public static final String SUN_PROVIDER_CLASS = "com.sun.crypto.provider.SunJCE";
    public static final String IBM_PROVIDER_CLASS = "com.ibm.crypto.provider.IBMJCE";
    public static final String PROVIDER_CLASS;
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$util$Encryptor;

    public static Key generateKey() throws EncryptorException {
        return Encryptor.generateKey(KEY_ALGORITHM);
    }

    public static Key generateKey(String algorithm) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            KeyGenerator generator = KeyGenerator.getInstance(algorithm);
            generator.init(56, new SecureRandom());
            SecretKey key = generator.generateKey();
            return key;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static Provider getProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            if (ServerDetector.isWebSphere() && PROVIDER_CLASS.equals(SUN_PROVIDER_CLASS)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"WebSphere does not have com.sun.crypto.provider.SunJCE, using com.ibm.crypto.provider.IBMJCE instead");
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            if (System.getProperty("java.vm.vendor").equals("IBM Corporation")) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"IBM JVM does not have com.sun.crypto.provider.SunJCE, using com.ibm.crypto.provider.IBMJCE instead");
                }
                providerClass = Class.forName(IBM_PROVIDER_CLASS);
            }
            throw cnfe;
        }
        return (Provider)providerClass.newInstance();
    }

    public static String decrypt(Key key, String encryptedString) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] encryptedBytes = Base64.decode((String)encryptedString);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            String decryptedString = new String(decryptedBytes, ENCODING);
            return decryptedString;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    public static String digest(String text) {
        return Digester.digest((String)text);
    }

    public static String digest(String algorithm, String text) {
        return Digester.digest((String)algorithm, (String)text);
    }

    public static String encrypt(Key key, String plainText) throws EncryptorException {
        try {
            Security.addProvider(Encryptor.getProvider());
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(1, key);
            byte[] decryptedBytes = plainText.getBytes(ENCODING);
            byte[] encryptedBytes = cipher.doFinal(decryptedBytes);
            String encryptedString = Base64.encode((byte[])encryptedBytes);
            return encryptedString;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$com$liferay$util$Encryptor;
        if (clazz == null) {
            clazz = class$com$liferay$util$Encryptor = Encryptor.class("[Lcom.liferay.util.Encryptor;", false);
        }
        PROVIDER_CLASS = GetterUtil.getString(SystemProperties.get(stringBuffer.append(clazz.getName()).append(".provider.class").toString()), SUN_PROVIDER_CLASS);
        Class clazz2 = class$com$liferay$util$Encryptor;
        if (clazz2 == null) {
            clazz2 = class$com$liferay$util$Encryptor = Encryptor.class("[Lcom.liferay.util.Encryptor;", false);
        }
        _log = LogFactory.getLog((Class)clazz2);
    }
}

