/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;

public class ParameterSelectionChoice
implements IParameterSelectionChoice,
Cloneable {
    protected Locale locale;
    protected SelectionChoiceHandle handle;
    protected String label;
    protected String labelKey;
    protected Object value;
    protected Logger log = Logger.getLogger(ParameterSelectionChoice.class.getName());

    public ParameterSelectionChoice(SelectionChoiceHandle handle) {
        this.handle = handle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLabel(String lableKey, String label) {
        this.label = label;
        this.labelKey = lableKey;
    }

    public void setValue(String value, int type) {
        try {
            switch (type) {
                case 5: {
                    this.value = DataTypeUtil.toBoolean(value);
                    break;
                }
                case 4: {
                    this.value = DataTypeUtil.toDate((Object)value);
                    break;
                }
                case 3: {
                    this.value = DataTypeUtil.toBigDecimal(value);
                    break;
                }
                case 2: {
                    this.value = DataTypeUtil.toDouble(value);
                    break;
                }
                case 6: {
                    this.value = DataTypeUtil.toInteger(value);
                    break;
                }
                case 7: {
                    this.value = DataTypeUtil.toSqlDate(value);
                    break;
                }
                case 8: {
                    this.value = DataTypeUtil.toSqlTime((Object)value);
                    break;
                }
                default: {
                    this.value = DataTypeUtil.toString(value);
                    break;
                }
            }
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.value = null;
        }
    }

    public String getLabel() {
        if (this.labelKey == null) {
            return this.label;
        }
        String ret = this.handle.getExternalizedValue("labelID", "label", this.locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)this.locale));
        return ret == null || ret.length() == 0 ? this.label : ret;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object getValue() {
        return this.value;
    }
}

