/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class OrderedDiskArray
extends ArrayList
implements IDiskArray {
    private static final long serialVersionUID = -8408837939375607822L;
    private int maxSize = -1;
    private boolean isTop = false;

    public OrderedDiskArray() {
    }

    public OrderedDiskArray(int maxSize, boolean isTop) {
        this.maxSize = maxSize;
        this.isTop = isTop;
    }

    public boolean add(Object o) {
        if (this.maxSize != 0) {
            this.orderInsert(o);
            return true;
        }
        return false;
    }

    private void orderInsert(Object value) {
        int i = this.size() - 1;
        while (i >= 0) {
            int ret = CompareUtil.compare(value, this.get(i));
            if (ret > 0 || !this.isTop && ret == 0) break;
            --i;
        }
        int pos = i + 1;
        if (this.maxSize < 0 || this.size() < this.maxSize) {
            super.add(value);
            int j = this.size() - 1;
            while (j > pos) {
                Object obj = this.get(j - 1);
                this.set(j, obj);
                --j;
            }
            this.set(pos, value);
        } else if (this.isTop) {
            if (pos > 0) {
                int j = 0;
                while (j < pos - 1) {
                    Object obj = this.get(j + 1);
                    this.set(j, obj);
                    ++j;
                }
                this.set(pos - 1, value);
            }
        } else if (pos < this.maxSize) {
            int j = this.size() - 1;
            while (j > pos) {
                Object obj = this.get(j - 1);
                this.set(j, obj);
                --j;
            }
            this.set(pos, value);
        }
    }

    public void close() throws IOException {
        super.clear();
    }
}

