/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.QueryDefinitionUtil;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.document.QueryDefnIOUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDSubQueryUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.BaseExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.EmptyExprResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDLoad {
    private int version;
    private StreamManager streamManager;
    private RDSubQueryUtil subQueryUtil;
    private QueryResultInfo queryResultInfo;
    private String tempDir;
    private DataEngineContext context;

    RDLoad(String tempDir, DataEngineContext context, QueryResultInfo queryResultInfo) throws DataException {
        this.tempDir = tempDir;
        this.queryResultInfo = queryResultInfo;
        this.context = context;
        if (!this.isEmptyQueryResultID(this.queryResultInfo.getSelfQueryResultID())) {
            this.subQueryUtil = new RDSubQueryUtil(context, QueryResultIDUtil.getRealStreamID(queryResultInfo.getRootQueryResultID(), queryResultInfo.getSelfQueryResultID()), queryResultInfo.getSubQueryName());
        }
        this.streamManager = new StreamManager(context, new QueryResultInfo(queryResultInfo.getRootQueryResultID(), queryResultInfo.getParentQueryResultID(), queryResultInfo.getSelfQueryResultID(), queryResultInfo.getSubQueryName(), queryResultInfo.getSubQueryName() == null ? 0 : this.getSubQueryIndex(queryResultInfo.getIndex())));
        this.version = this.streamManager.getVersion();
    }

    int getSubQueryIndex(int currParentIndex) throws DataException {
        return this.subQueryUtil == null ? 0 : this.subQueryUtil.getSubQueryIndex(currParentIndex);
    }

    public ResultMetaData loadResultMetaData() throws DataException {
        if (this.isEmptyQueryResultID(this.queryResultInfo.getSelfQueryResultID())) {
            return new ResultMetaData(new ResultClass(new ArrayList()));
        }
        return new ResultMetaData(this.loadResultClass());
    }

    IExprResultSet loadExprResultSet(int rowIdStartingIndex, IBaseQueryDefinition qd) throws DataException {
        if (this.streamManager.isSecondRD() && this.streamManager.isSubquery()) {
            return new ExprResultSet2(this.tempDir, this.streamManager, this.version, this.streamManager.isSecondRD(), rowIdStartingIndex);
        }
        if (this.isEmptyQueryResultID(this.queryResultInfo.getSelfQueryResultID())) {
            return new EmptyExprResultSet();
        }
        return new ExprResultSet(this.tempDir, this.streamManager, this.version, this.streamManager.isSecondRD(), this.streamManager.isSubquery() || this.version < 50 ? null : this.loadDataSetData(null, null, new HashMap()), this.streamManager.isSubquery() ? rowIdStartingIndex : 0, qd);
    }

    public IExprDataResultSet loadExprDataResultSet(boolean isSummary) throws DataException {
        if (this.version == 0) {
            throw new DataException("data.engine.wrongVersion");
        }
        ExprMetaInfo[] exprMetas = this.loadExprMetaInfo();
        BaseExprDataResultSet exprDataResultSet = null;
        exprDataResultSet = !this.streamManager.isBasedOnSecondRD() ? new ExprDataResultSet1(this.streamManager.getInStream(31, 0, 0), exprMetas, this.version, isSummary || this.version < 50 ? null : this.loadDataSetData(null, null, new HashMap())) : new ExprDataResultSet2(this.tempDir, this.streamManager.getInStream(31, 0, 0), this.streamManager.getInStream(33, 0, 0), this.streamManager.getInStream(51, 0, 1), exprMetas, this.version, this.version < 50 ? null : this.loadDataSetData(null, null, new HashMap()));
        return exprDataResultSet;
    }

    public ExprMetaInfo[] loadExprMetaInfo() throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(32, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream(inputStream);
        ExprMetaInfo[] exprMetas = ExprMetaUtil.loadExprMetaInfo(buffStream);
        try {
            buffStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {}
        return exprMetas;
    }

    public IResultClass loadResultClass() throws DataException {
        RAInputStream stream = this.streamManager.getInStream(22, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream(stream);
        ResultClass resultClass = new ResultClass(buffStream, this.version);
        try {
            buffStream.close();
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Class");
        }
        return resultClass;
    }

    public DataSetResultSet loadDataSetData(Set<Integer> preFilteredRowIds, Map<String, StringTable> stringTableMap, Map index) throws DataException {
        if (!this.streamManager.hasInStream(21, 0, 0)) {
            return null;
        }
        RAInputStream stream = this.streamManager.getInStream(21, 0, 0);
        RAInputStream lensStream = null;
        if (this.version >= 50) {
            lensStream = this.streamManager.getInStream(23, 0, 0);
        }
        int adjustedVersion = this.resolveVersionConflict();
        DataSetResultSet populator = new DataSetResultSet(stream, lensStream, this.loadResultClass(), preFilteredRowIds, stringTableMap, index, adjustedVersion);
        return populator;
    }

    public DataSetResultSet loadDataSetData(Set<Integer> preFilteredRowIds, Map<String, StringTable> stringTableMap, Map index, boolean includeInnerID) throws DataException {
        if (!this.streamManager.hasInStream(21, 0, 0)) {
            return null;
        }
        RAInputStream stream = this.streamManager.getInStream(21, 0, 0);
        RAInputStream lensStream = null;
        if (this.version >= 50) {
            lensStream = this.streamManager.getInStream(23, 0, 0);
        }
        int adjustedVersion = this.resolveVersionConflict();
        DataSetResultSet populator = new DataSetResultSet(stream, lensStream, this.loadResultClass(), preFilteredRowIds, stringTableMap, index, adjustedVersion, includeInnerID);
        return populator;
    }

    private int resolveVersionConflict() {
        if (this.version == 200 && ("4.2.0.v20120611".equals(this.context.getBundleVersion()) || "4.2.1.v20120820".equals(this.context.getBundleVersion()))) {
            return 210;
        }
        return this.version;
    }

    public IBaseQueryDefinition loadOriginalQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(44, streamPos, streamScope);
        return this.loadQueryDefn(inputStream);
    }

    public IBaseQueryDefinition loadQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(43, streamPos, streamScope);
        return this.loadQueryDefn(inputStream);
    }

    private IBaseQueryDefinition loadQueryDefn(InputStream inputStream) throws DataException {
        String bundleVersion = this.context.getBundleVersion();
        IQueryDefinition queryDefn = QueryDefnIOUtil.loadQueryDefn(inputStream, this.version, bundleVersion);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return queryDefn;
    }

    public List loadFilterDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getFilters();
    }

    public List loadGroupDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getGroups();
    }

    public ISubqueryDefinition loadSubQueryDefn(int streamPos, int streamScope, String subQueryName) throws DataException {
        if (subQueryName == null) {
            return null;
        }
        IBaseQueryDefinition baseQueryDefn = this.loadQueryDefn(streamPos, streamScope);
        return QueryDefinitionUtil.findSubQueryDefinition(subQueryName, baseQueryDefn);
    }

    public boolean isEmptyQueryResultID(String queryResultID) throws DataException {
        if (!this.context.hasInStream("DataEngine", null, 116)) {
            return false;
        }
        DataInputStream emptyQueryResultStream = new DataInputStream(this.context.getInputStream("DataEngine", null, 116));
        HashSet<String> emptyQueryResultID = new HashSet<String>();
        try {
            int count = IOUtil.readInt(emptyQueryResultStream);
            int i = 0;
            while (i < count) {
                String temp = IOUtil.readString(emptyQueryResultStream);
                emptyQueryResultID.add(temp);
                ++i;
            }
            emptyQueryResultStream.close();
            return emptyQueryResultID.contains(queryResultID);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }
}

