/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client;

import com.mockrunner.mock.web.MockHttpServletRequest;
import edu.yale.its.tp.cas.client.Util;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;

public class UtilTest
extends TestCase {
    private static final String requestServerName = "requestProvided.com";
    private static final String requestUri = "/app/servlet";
    private static final String serverName = "someplace.com";

    public UtilTest(String name) {
        super(name);
    }

    public void testGetServiceBasics() throws ServletException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setQueryString("param=value&ticket=splat");
        mockRequest.setRequestURI(requestUri);
        mockRequest.setServerName(requestServerName);
        String response = Util.getService((HttpServletRequest)mockRequest, serverName);
        String expectedResponseCaps = "http%3A%2F%2Fsomeplace.com%2Fapp%2Fservlet%3Fparam%3Dvalue";
        String expectedResponseLowercase = "http%3a%2f%2fsomeplace.com%2fapp%2fservlet%3fparam%3dvalue";
        boolean passed = expectedResponseCaps.equals(response);
        passed = passed || expectedResponseLowercase.equals(response);
        UtilTest.assertTrue((boolean)passed);
    }

    public void testGetServiceOddButLegalQueryString() throws ServletException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setQueryString("param1=aaa&param2=bbb&param1=aaa");
        mockRequest.setRequestURI(requestUri);
        mockRequest.setServerName(requestServerName);
        String response = Util.getService((HttpServletRequest)mockRequest, serverName);
        String expectedResponseCaps = "http%3A%2F%2Fsomeplace.com%2Fapp%2Fservlet%3Fparam1%3Daaa%26param2%3Dbbb%26param1%3Daaa";
        String expectedResponseLowercase = "http%3a%2f%2fsomeplace.com%2fapp%2fservlet%3fparam1%3daaa%26param2%3dbbb%26param1%3daaa";
        boolean passed = expectedResponseCaps.equals(response);
        passed = passed || expectedResponseLowercase.equals(response);
        UtilTest.assertTrue((boolean)passed);
    }
}

