/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client;

import edu.yale.its.tp.cas.client.CASAuthenticationException;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CASReceipt {
    private static Log log = LogFactory.getLog((Class)(class$edu$yale$its$tp$cas$client$CASReceipt == null ? (class$edu$yale$its$tp$cas$client$CASReceipt = CASReceipt.class$("edu.yale.its.tp.cas.client.CASReceipt")) : class$edu$yale$its$tp$cas$client$CASReceipt));
    private String casValidateUrl;
    private String pgtIou;
    private boolean primaryAuthentication = false;
    private String proxyCallbackUrl;
    private List proxyList = new ArrayList();
    private String userName;
    static /* synthetic */ Class class$edu$yale$its$tp$cas$client$CASReceipt;

    public static CASReceipt getReceipt(ProxyTicketValidator ptv) throws CASAuthenticationException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getReceipt(ProxyTicketValidator=[" + ptv + "])"));
        }
        if (!ptv.isAuthenticationSuccesful()) {
            try {
                ptv.validate();
            }
            catch (Exception e) {
                CASAuthenticationException casException = new CASAuthenticationException("Unable to validate ProxyTicketValidator [" + ptv + "]", e);
                log.error((Object)casException);
                throw casException;
            }
        }
        if (!ptv.isAuthenticationSuccesful()) {
            log.error((Object)("validation of [" + ptv + "] was not successful."));
            throw new CASAuthenticationException("Unable to validate ProxyTicketValidator [" + ptv + "]");
        }
        CASReceipt receipt = new CASReceipt();
        receipt.casValidateUrl = ptv.getCasValidateUrl();
        receipt.pgtIou = ptv.getPgtIou();
        receipt.userName = ptv.getUser();
        receipt.proxyCallbackUrl = ptv.getProxyCallbackUrl();
        receipt.proxyList = ptv.getProxyList();
        receipt.primaryAuthentication = ptv.isRenew();
        if (!receipt.validate()) {
            throw new CASAuthenticationException("Validation of [" + ptv + "] did not result in an internally consistent CASReceipt.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getReceipt() with return value [" + receipt + "]"));
        }
        return receipt;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public List getProxyList() {
        return Collections.unmodifiableList(this.proxyList);
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isPrimaryAuthentication() {
        return this.primaryAuthentication;
    }

    public boolean isProxied() {
        return !this.proxyList.isEmpty();
    }

    public String getProxyingService() {
        if (this.proxyList.isEmpty()) {
            return null;
        }
        return (String)this.proxyList.get(0);
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public void setPgtIou(String pgtIou) {
        this.pgtIou = pgtIou;
    }

    public void setPrimaryAuthentication(boolean primaryAuthentication) {
        this.primaryAuthentication = primaryAuthentication;
    }

    public void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public void setProxyList(List proxyList) {
        this.proxyList = proxyList;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append((class$edu$yale$its$tp$cas$client$CASReceipt == null ? (class$edu$yale$its$tp$cas$client$CASReceipt = CASReceipt.class$("edu.yale.its.tp.cas.client.CASReceipt")) : class$edu$yale$its$tp$cas$client$CASReceipt).getName());
        sb.append(" userName=[");
        sb.append(this.userName);
        sb.append("]");
        sb.append(" casValidateUrl=[");
        sb.append(this.casValidateUrl);
        sb.append("]");
        sb.append(" proxyCallbackUrl=[");
        sb.append(this.proxyCallbackUrl);
        sb.append("]");
        sb.append(" pgtIou=[");
        sb.append(this.pgtIou);
        sb.append("]");
        sb.append(" casValidateUrl=[");
        sb.append(this.casValidateUrl);
        sb.append("]");
        sb.append(" proxyList=[");
        sb.append(this.proxyList);
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    private boolean validate() {
        boolean valid = true;
        if (this.userName == null) {
            log.error((Object)("Receipt was invalid because userName was null. Receipt:[" + this + "]"));
            valid = false;
        }
        if (this.casValidateUrl == null) {
            log.error((Object)("Receipt was invalid because casValidateUrl was null.  Receipt:[" + this + "]"));
            valid = false;
        }
        if (this.proxyList == null) {
            log.error((Object)("receipt was invalid because proxyList was null.  Receipt:[" + this + "]"));
            valid = false;
        }
        if (this.primaryAuthentication && !this.proxyList.isEmpty()) {
            log.error((Object)("If authentication was by primary credentials then it could not have been proxied. Yet, primaryAuthentication is true where proxyList is not empty.  Receipt:[" + this + "]"));
            valid = false;
        }
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

