/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.filters.strip;

import com.liferay.filters.strip.StripResponse;
import com.liferay.util.GetterUtil;
import com.liferay.util.Http;
import com.liferay.util.ParamUtil;
import com.liferay.util.SystemProperties;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StripFilter
implements Filter {
    public static final boolean USE_STRIP_FILTER;
    public static final String ENCODING;
    private static final String _ALREADY_FILTERED;
    private static final String _STRIP = "strip";
    private static final String _INCLUDE = "javax.servlet.include.request_uri";
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$filters$strip$StripFilter;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            if (USE_STRIP_FILTER) {
                _log.debug((Object)"Strip is enabled");
            } else {
                _log.debug((Object)"Strip is disabled");
            }
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        httpReq.setCharacterEncoding(ENCODING);
        String completeURL = Http.getCompleteURL((HttpServletRequest)httpReq);
        if (USE_STRIP_FILTER && this.isStrip(httpReq) && !this.isInclude(httpReq) && !this.isAlreadyFiltered(httpReq)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Stripping " + completeURL));
            }
            httpReq.setAttribute(_ALREADY_FILTERED, (Object)Boolean.TRUE);
            StripResponse stripResponse = new StripResponse(httpRes);
            chain.doFilter(req, (ServletResponse)stripResponse);
            String contentType = GetterUtil.getString((String)stripResponse.getContentType());
            byte[] oldByteArray = stripResponse.getData();
            if (oldByteArray != null && oldByteArray.length > 0) {
                byte[] newByteArray = new byte[oldByteArray.length];
                int newByteArrayPos = 0;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Stripping content of type " + contentType));
                }
                if (contentType.toLowerCase().indexOf("text/") != -1) {
                    boolean ignore = false;
                    int prevChar = 10;
                    int i = 0;
                    while (i < oldByteArray.length) {
                        byte b = oldByteArray[i];
                        char c = (char)b;
                        if (c == '<') {
                            char c9;
                            char c8;
                            char c7;
                            char c6;
                            char c5;
                            char c4;
                            char c3;
                            char c2;
                            char c1;
                            if (!ignore) {
                                if (i + 4 < oldByteArray.length) {
                                    c1 = (char)oldByteArray[i + 1];
                                    c2 = (char)oldByteArray[i + 2];
                                    c3 = (char)oldByteArray[i + 3];
                                    c4 = (char)oldByteArray[i + 4];
                                    if (!(c1 != 'p' && c1 != 'P' || c2 != 'r' && c2 != 'R' || c3 != 'e' && c3 != 'E' || c4 != '>')) {
                                        ignore = true;
                                    }
                                }
                                if (!ignore && i + 9 < oldByteArray.length) {
                                    c1 = (char)oldByteArray[i + 1];
                                    c2 = (char)oldByteArray[i + 2];
                                    c3 = (char)oldByteArray[i + 3];
                                    c4 = (char)oldByteArray[i + 4];
                                    c5 = (char)oldByteArray[i + 5];
                                    c6 = (char)oldByteArray[i + 6];
                                    c7 = (char)oldByteArray[i + 7];
                                    c8 = (char)oldByteArray[i + 8];
                                    c9 = (char)oldByteArray[i + 9];
                                    if (!(c1 != 't' && c1 != 'T' || c2 != 'e' && c2 != 'E' || c3 != 'x' && c3 != 'X' || c4 != 't' && c4 != 'T' || c5 != 'a' && c5 != 'A' || c6 != 'r' && c6 != 'R' || c7 != 'e' && c7 != 'E' || c8 != 'a' && c8 != 'A' || c9 != ' ')) {
                                        ignore = true;
                                    }
                                }
                            } else if (ignore) {
                                if (i + 5 < oldByteArray.length) {
                                    c1 = (char)oldByteArray[i + 1];
                                    c2 = (char)oldByteArray[i + 2];
                                    c3 = (char)oldByteArray[i + 3];
                                    c4 = (char)oldByteArray[i + 4];
                                    c5 = (char)oldByteArray[i + 5];
                                    if (!(c1 != '/' || c2 != 'p' && c2 != 'P' || c3 != 'r' && c3 != 'R' || c4 != 'e' && c4 != 'E' || c5 != '>')) {
                                        ignore = false;
                                    }
                                }
                                if (ignore && i + 10 < oldByteArray.length) {
                                    c1 = (char)oldByteArray[i + 1];
                                    c2 = (char)oldByteArray[i + 2];
                                    c3 = (char)oldByteArray[i + 3];
                                    c4 = (char)oldByteArray[i + 4];
                                    c5 = (char)oldByteArray[i + 5];
                                    c6 = (char)oldByteArray[i + 6];
                                    c7 = (char)oldByteArray[i + 7];
                                    c8 = (char)oldByteArray[i + 8];
                                    c9 = (char)oldByteArray[i + 9];
                                    char c10 = (char)oldByteArray[i + 10];
                                    if (!(c1 != '/' || c2 != 't' && c2 != 'T' || c3 != 'e' && c3 != 'E' || c4 != 'x' && c4 != 'X' || c5 != 't' && c5 != 'T' || c6 != 'a' && c6 != 'A' || c7 != 'r' && c7 != 'R' || c8 != 'e' && c8 != 'E' || c9 != 'a' && c9 != 'A' || c10 != '>')) {
                                        ignore = false;
                                    }
                                }
                            }
                        }
                        if (!(ignore || c != '\n' && c != '\r' && c != '\t')) {
                            int cfr_ignored_0 = oldByteArray.length;
                            if (prevChar != 10 && prevChar != 13) {
                                if (c != '\t') {
                                    prevChar = c;
                                }
                                newByteArray[newByteArrayPos++] = b;
                            }
                        } else {
                            prevChar = c;
                            newByteArray[newByteArrayPos++] = b;
                        }
                        ++i;
                    }
                } else {
                    newByteArray = oldByteArray;
                    newByteArrayPos = oldByteArray.length;
                }
                ServletResponseUtil.write((HttpServletResponse)httpRes, (byte[])newByteArray, (int)newByteArrayPos);
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not stripping " + completeURL));
            }
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    protected boolean isAlreadyFiltered(HttpServletRequest req) {
        return req.getAttribute(_ALREADY_FILTERED) != null;
    }

    protected boolean isInclude(HttpServletRequest req) {
        String uri = (String)req.getAttribute(_INCLUDE);
        return uri != null;
    }

    protected boolean isStrip(HttpServletRequest req) {
        if (!ParamUtil.get((ServletRequest)req, (String)_STRIP, (boolean)true)) {
            return false;
        }
        boolean action = ParamUtil.getBoolean((ServletRequest)req, (String)"p_p_action");
        String windowState = ParamUtil.getString((ServletRequest)req, (String)"p_p_state");
        return !action || !windowState.equals("exclusive");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$liferay$filters$strip$StripFilter;
        if (clazz == null) {
            clazz = class$com$liferay$filters$strip$StripFilter = StripFilter.class("[Lcom.liferay.filters.strip.StripFilter;", false);
        }
        USE_STRIP_FILTER = GetterUtil.getBoolean((String)SystemProperties.get((String)clazz.getName()), (boolean)true);
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz2 = class$com$liferay$filters$strip$StripFilter;
        if (clazz2 == null) {
            clazz2 = class$com$liferay$filters$strip$StripFilter = StripFilter.class("[Lcom.liferay.filters.strip.StripFilter;", false);
        }
        ENCODING = GetterUtil.getString((String)SystemProperties.get((String)stringBuffer.append(clazz2.getName()).append(".encoding").toString()), (String)"UTF-8");
        StringBuffer stringBuffer2 = new StringBuffer();
        Class clazz3 = class$com$liferay$filters$strip$StripFilter;
        if (clazz3 == null) {
            clazz3 = class$com$liferay$filters$strip$StripFilter = StripFilter.class("[Lcom.liferay.filters.strip.StripFilter;", false);
        }
        _ALREADY_FILTERED = stringBuffer2.append(clazz3).append("_ALREADY_FILTERED").toString();
        Class clazz4 = class$com$liferay$filters$strip$StripFilter;
        if (clazz4 == null) {
            clazz4 = class$com$liferay$filters$strip$StripFilter = StripFilter.class("[Lcom.liferay.filters.strip.StripFilter;", false);
        }
        _log = LogFactory.getLog((Class)clazz4);
    }
}

