/*
 * Decompiled with CFR 0.152.
 */
package com.proveo.web.authenticator;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenewSessionValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(RenewSessionValve.class);

    public RenewSessionValve() {
        log.trace((Object)"created");
    }

    public String getInfo() {
        return "RenewSessionValve";
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("invoke: " + request.getRequestURI()));
        }
        if (request.getRequestURI().contains("/portal/j_security_check")) {
            log.trace((Object)("loginURI found: " + request.getRequestURI()));
            Session oldSession = request.getSessionInternal(true);
            SavedRequest saved = (SavedRequest)oldSession.getNote("org.apache.catalina.authenticator.REQUEST");
            request.getSession(true).invalidate();
            request.setRequestedSessionId(null);
            request.clearCookies();
            Session newSession = request.getSessionInternal(true);
            request.setRequestedSessionId(newSession.getId());
            if (saved != null) {
                newSession.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
            }
        }
        this.getNext().invoke(request, response);
    }
}

