/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.authentication.PasswordChange;
import com.sshtools.common.authentication.PublicKeyAuthenticationPrompt;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.mru.MRUAction;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.mru.MRUMenu;
import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.EditAction;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NewAction;
import com.sshtools.common.ui.OpenAction;
import com.sshtools.common.ui.RecordAction;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SaveAction;
import com.sshtools.common.ui.SaveAsAction;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SessionProviderAction;
import com.sshtools.common.ui.SessionProviderFactory;
import com.sshtools.common.ui.SessionProviderFrame;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.StopAction;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingIOChannel;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalPanel;
import com.sshtools.sshvnc.ClipboardAction;
import com.sshtools.sshvnc.CtrlAltDelAction;
import com.sshtools.sshvnc.HexASCII;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.SshVNCViewer;
import com.sshtools.sshvnc.VNCAdvancedTab;
import com.sshtools.sshvnc.VNCTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshVNCPanel
extends SshToolsApplicationClientPanel
implements ActionListener {
    public static final String PROFILE_PROPERTY_VNC_HOST = "VNC_HOST";
    public static final String PROFILE_PROPERTY_VNC_DISPLAY = "VNC_DISPLAY";
    public static final String PROFILE_PRE_VNC_COMMAND = "PRE_VNC_COMMAND";
    public static final String PROFILE_POST_VNC_COMMAND = "POST_VNC_COMMAND";
    public static final String PROFILE_PROPERTY_PREFERRED_ENCODING = "PREFERRED_ENCODING";
    public static final String PROFILE_PROPERTY_USE_COPY_RECT = "USE_COPY_RECT";
    public static final String PROFILE_PROPERTY_COMPRESS_LEVEL = "COMPRESS_LEVEL";
    public static final String PROFILE_PROPERTY_JPEG_QUALITY = "JPEG_QUALITY";
    public static final String PROFILE_PROPERTY_CURSOR_UPDATES = "CURSOR_UPDATES";
    public static final String PROFILE_PROPERTY_EIGHT_BIT_COLORS = "EIGHT_BIT_COLORS";
    public static final String PROFILE_PROPERTY_REVERSE_MOUSE_BUTTONS_2_AND_3 = "REVERSE_MOUSE_BUTTONS_2_AND_3";
    public static final String PROFILE_PROPERTY_SHARE_DESKTOP = "SHARE_DESKTOP";
    public static final String PROFILE_PROPERTY_VIEW_ONLY = "VIEW_ONLY";
    public static final String PROFILE_PROPERTY_ENCRYPTED_VNC_PASSWORD = "ENCRYPTED_VNC_PASSWORD";
    public static final String PROFILE_PROPERTY_SSH_PASSWORD = "SSH_PASSWORD";
    public static final String PROFILE_PROPERTY_SCREEN_SIZE_POLICY = "VNC_SCREEN_SIZE";
    public static final String PROFILE_PROPERTY_VNC_SERVER_OS = "VNC_SERVER_OS";
    public static final int PROFILE_SCREEN_NO_CHANGE = 0;
    public static final int PROFILE_SCREEN_REMOTE_DESKTOP = 1;
    public static final int PROFILE_VNC_SERVER_OS_WINDOWSMAC = 0;
    public static final int PROFILE_VNC_SERVER_OS_LINUX = 1;
    private TerminalPanel terminal;
    protected TerminalEmulation emulation;
    private Vector sessionFrames = new Vector();
    private HashMap sessionActions = new HashMap();
    protected static Log log = LogFactory.getLog(class$com$sshtools$sshvnc$SshVNC == null ? (class$com$sshtools$sshvnc$SshVNC = SshVNCPanel.class$("com.sshtools.sshvnc.SshVNC")) : class$com$sshtools$sshvnc$SshVNC);
    private SshVNCViewer vnc;
    private StandardAction newAction;
    private StandardAction closeAction;
    private StandardAction refreshAction;
    private StandardAction clipboardAction;
    private StandardAction ctrlAltDelAction;
    private StandardAction recordAction;
    private StandardAction stopAction;
    private Thread rfbThread;
    private JFileChooser recordingFileChooser;
    private VNCTab vncTab;
    private StatusBar statusBar;
    private Timer sendTimer;
    private Timer receiveTimer;
    private ForwardingClient.ClientForwardingListener forwardingConfig;
    private SshToolsConnectionTab[] additionalTabs;
    private OpenAction openAction;
    private EditAction editAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private MRUActionImpl mruAction;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private boolean closing = false;
    ForwardingIOChannel channel;
    private boolean fullScreenMode;
    public static final ResourceIcon SSHVNC_ICON = new ResourceIcon(class$com$sshtools$sshvnc$SshVNCPanel == null ? (class$com$sshtools$sshvnc$SshVNCPanel = SshVNCPanel.class$("com.sshtools.sshvnc.SshVNCPanel")) : class$com$sshtools$sshvnc$SshVNCPanel, "sshvncframeicon.gif");
    private static boolean debug = true;
    static /* synthetic */ Class class$com$sshtools$sshvnc$SshVNC;
    static /* synthetic */ Class class$com$sshtools$sshvnc$SshVNCPanel;
    static /* synthetic */ Class class$java$awt$Frame;

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        super.init(sshToolsApplication);
        this.setLayout(new BorderLayout());
        this.sendTimer = new Timer(500, this);
        this.sendTimer.setRepeats(false);
        this.receiveTimer = new Timer(500, this);
        this.receiveTimer.setRepeats(false);
        this.statusBar = new StatusBar();
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setConnected(false);
        this.setLayout(new BorderLayout());
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException iOException) {
            throw new SshToolsApplicationException(iOException);
        }
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation);
        this.terminal.requestFocus();
        try {
            this.vnc = new SshVNCViewer();
            this.additionalTabs = new SshToolsConnectionTab[]{new VNCTab(), new VNCAdvancedTab()};
            this.add((Component)this.vnc, "Center");
            this.initActions();
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(UIManager.getIcon("OptionPane.errorIcon"), new ErrorTextBox((throwable.getMessage() == null ? "<no message supplied>" : throwable.getMessage()) + (debug ? "\n\n" + stringWriter.getBuffer().toString() : "")));
            iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.add((Component)iconWrapperPanel, "Center");
            throw new SshToolsApplicationException("Failed to start SshVNC. ", throwable);
        }
    }

    public ResourceIcon getIcon() {
        return SSHVNC_ICON;
    }

    public boolean postConnection() {
        return true;
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.receiveTimer) {
            this.statusBar.setReceiving(false);
        } else if (actionEvent.getSource() == this.sendTimer) {
            this.statusBar.setSending(false);
        }
        if (this.sessionActions.containsKey(actionEvent.getActionCommand())) {
            SessionProviderFrame sessionProviderFrame;
            SessionProviderAction sessionProviderAction = (SessionProviderAction)this.sessionActions.get(actionEvent.getActionCommand());
            Iterator iterator = this.sessionFrames.iterator();
            while (iterator.hasNext()) {
                sessionProviderFrame = (SessionProviderFrame)iterator.next();
                if (!sessionProviderAction.getProvider().getProviderClass().isInstance(sessionProviderFrame)) continue;
                sessionProviderFrame.show();
                return;
            }
            try {
                sessionProviderFrame = new SessionProviderFrame(this.getCurrentConnectionProfile(), this.ssh, sessionProviderAction.getProvider());
                if (sessionProviderFrame.initFrame(this.getApplication())) {
                    sessionProviderFrame.show();
                    this.sessionFrames.add(sessionProviderFrame);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setFrameResizeable(boolean bl) {
        this.vnc.setFrameResizeable(bl);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVNC(InputStream inputStream, OutputStream outputStream, SshVNCOptions sshVNCOptions) {
        block7: {
            log.info("Initialising VNC");
            try {
                try {
                    this.vnc.init(inputStream, outputStream, this, sshVNCOptions);
                }
                catch (EOFException eOFException) {
                    if (this.isConnected() && !this.closing) {
                        SshToolsApplicationPanel.showErrorMessage(this, "The server closed the connection.", "Error", null);
                    }
                    Object var7_5 = null;
                    break block7;
                }
                catch (Exception exception) {
                    if (this.isConnected() && !this.closing) {
                        SshToolsApplicationPanel.showErrorMessage(this, "Error", exception);
                    }
                    Object var7_6 = null;
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void closeVNC() {
        this.vnc.closeConnection();
        this.setAvailableActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void closeConnection(boolean bl) {
        this.statusBar.setStatusText("Closing VNC");
        Iterator iterator = this.sessionFrames.iterator();
        while (iterator.hasNext()) {
            try {
                SessionProviderFrame sessionProviderFrame = (SessionProviderFrame)iterator.next();
                sessionProviderFrame.exit();
                sessionProviderFrame.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sessionFrames.clear();
        if (this.ssh != null && this.ssh.isConnected()) {
            block15: {
                super.closeConnection(bl);
                if (bl) {
                    this.closeVNC();
                }
                try {
                    String string = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_POST_VNC_COMMAND, null);
                    if (string == null || string.trim().length() <= 0) break block15;
                    this.statusBar.setStatusText("Executing command: " + string);
                    this.remove(this.vnc);
                    this.add((Component)this.terminal, "Center");
                    this.emulation.reset();
                    this.emulation.clearScreen();
                    this.emulation.setCursorPosition(0, 0);
                    this.terminal.refresh();
                    log.debug("Executing post VNC command " + string);
                    SessionChannelClient sessionChannelClient = this.ssh.openSessionChannel();
                    sessionChannelClient.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                    if (sessionChannelClient.executeCommand(string)) {
                        sessionChannelClient.bindInputStream(this.emulation.getTerminalInputStream());
                        sessionChannelClient.bindOutputStream(this.emulation.getTerminalOutputStream());
                    }
                    try {
                        try {
                            sessionChannelClient.getState().waitForState(3);
                        }
                        catch (InterruptedException interruptedException) {
                            Object var8_10 = null;
                            this.remove(this.terminal);
                            this.add((Component)this.vnc, "Center");
                            break block15;
                        }
                        Object var8_9 = null;
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.statusBar.setUser("");
            this.statusBar.setHost("");
            this.statusBar.setStatusText("Disconnected");
            this.statusBar.setConnected(false);
            this.setAvailableActions();
            this.ssh = null;
            this.forwardingConfig = null;
            this.setNeedSave(false);
            this.setContainerTitle(this.getCurrentConnectionFile());
            this.setAvailableActions();
        }
    }

    protected int showAuthenticationPrompt(SshAuthenticationClient sshAuthenticationClient) throws IOException {
        String string = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_SSH_PASSWORD, "");
        if (!string.equals("")) {
            ((PasswordAuthenticationClient)sshAuthenticationClient).setPassword(HexASCII.ToString(string));
        }
        sshAuthenticationClient.setUsername(this.getCurrentConnectionProfile().getUsername());
        if (sshAuthenticationClient instanceof PasswordAuthenticationClient) {
            PasswordAuthenticationDialog passwordAuthenticationDialog = new PasswordAuthenticationDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SshVNCPanel.class$("java.awt.Frame")) : class$java$awt$Frame, this));
            sshAuthenticationClient.setAuthenticationPrompt(passwordAuthenticationDialog);
            ((PasswordAuthenticationClient)sshAuthenticationClient).setPasswordChangePrompt(PasswordChange.getInstance());
            PasswordChange.getInstance().setParentComponent(this);
        } else if (sshAuthenticationClient instanceof PublicKeyAuthenticationClient) {
            PublicKeyAuthenticationPrompt publicKeyAuthenticationPrompt = new PublicKeyAuthenticationPrompt(this);
            sshAuthenticationClient.setAuthenticationPrompt(publicKeyAuthenticationPrompt);
        } else if (sshAuthenticationClient instanceof KBIAuthenticationClient) {
            KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
            ((KBIAuthenticationClient)sshAuthenticationClient).setKBIRequestHandler(new KBIRequestHandlerDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SshVNCPanel.class$("java.awt.Frame")) : class$java$awt$Frame, this)));
        }
        return this.ssh.authenticate(sshAuthenticationClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void authenticationComplete(boolean bl) throws SshException, IOException {
        Object object;
        XDisplay xDisplay;
        int n;
        block13: {
            this.statusBar.setStatusText("User authenticated");
            n = 0;
            String string = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_HOST, "localhost");
            String string2 = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_DISPLAY, "5900");
            xDisplay = new XDisplay(string + ":" + string2, 5900);
            String string3 = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PRE_VNC_COMMAND, null);
            if (string3 != null && string3.trim().length() > 0) {
                this.statusBar.setStatusText("Executing command: " + string3);
                this.remove(this.vnc);
                this.add((Component)this.terminal, "Center");
                this.emulation.reset();
                this.emulation.clearScreen();
                this.emulation.setCursorPosition(0, 0);
                this.terminal.refresh();
                log.debug("Executing pre VNC command" + string3);
                object = this.ssh.openSessionChannel();
                ((SessionChannelClient)object).requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                if (((SessionChannelClient)object).executeCommand(string3)) {
                    ((IOChannel)object).bindInputStream(this.emulation.getTerminalInputStream());
                    ((IOChannel)object).bindOutputStream(this.emulation.getTerminalOutputStream());
                }
                try {
                    try {
                        ((Channel)object).getState().waitForState(3);
                    }
                    catch (InterruptedException interruptedException) {
                        Object var11_9 = null;
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                        break block13;
                    }
                    Object var11_8 = null;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    this.remove(this.terminal);
                    this.add((Component)this.vnc, "Center");
                    throw throwable;
                }
                this.remove(this.terminal);
                this.add((Component)this.vnc, "Center");
            }
        }
        this.statusBar.setStatusText("Setting up VNC forwarding");
        if (log.isDebugEnabled()) {
            log.debug("Setting up forwarding on 0.0.0.0 (" + n + ") to " + xDisplay.getHost() + ":" + xDisplay.getPort());
        }
        object = new SshVNCOptions(this.getCurrentConnectionProfile());
        this.statusBar.setStatusText("Initialising VNC");
        ForwardingConfiguration forwardingConfiguration = new ForwardingConfiguration("VNC", "forwarded-channel", 0, xDisplay.getHost(), xDisplay.getPort());
        this.channel = new ForwardingIOChannel("direct-tcpip", "VNC", forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect(), "0.0.0.0", xDisplay.getPort());
        if (this.ssh.openChannel(this.channel)) {
            this.channel.addEventListener(new DataNotificationListener(this.statusBar));
            if (bl) {
                this.setNeedSave(true);
            }
            new SshThread(new Runnable((SshVNCOptions)object){
                private final /* synthetic */ SshVNCOptions val$options;
                {
                    this.val$options = sshVNCOptions;
                }

                public void run() {
                    SshVNCPanel.this.initVNC(SshVNCPanel.this.channel.getInputStream(), SshVNCPanel.this.channel.getOutputStream(), this.val$options);
                }
            }, "VNC", true).start();
            return;
        }
        try {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(SshVNCPanel.this, "SSHVnc failed to open a forwarding channel to " + xDisplay.toString(), "SSHVnc", 0);
                    }
                });
            }
            catch (Exception exception) {
                this.statusBar.setStatusText("Could not connect to local forwarding server");
                Object var13_16 = null;
                this.closeConnection(true);
                return;
            }
            Object var13_15 = null;
            this.closeConnection(true);
            return;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.closeConnection(true);
            throw throwable;
        }
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.vncTab = new VNCTab();
        this.newAction = new NewAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshToolsConnectionProfile sshToolsConnectionProfile = SshVNCPanel.this.newConnectionProfile(null);
                if (sshToolsConnectionProfile != null) {
                    SshVNCPanel.this.connect(sshToolsConnectionProfile, true);
                } else {
                    log.info("New connection cancelled");
                }
            }
        };
        this.registerAction(this.newAction);
        this.closeAction = new CloseAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshVNCPanel.this.closing = true;
                Thread thread = new Thread(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$100(this.this$1).closeConnection(true);
                    }
                };
                thread.start();
            }

            static /* synthetic */ SshVNCPanel access$100(4 var0) {
                return var0.SshVNCPanel.this;
            }
        };
        this.registerAction(this.closeAction);
        this.refreshAction = new RefreshAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshVNCPanel.this.refresh();
            }
        };
        this.registerAction(this.refreshAction);
        this.ctrlAltDelAction = new CtrlAltDelAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SshVNCPanel.this.vnc.sendCtrlAltDel();
                }
                catch (IOException iOException) {
                    SshVNCPanel.this.closeConnection(true);
                    SshToolsApplicationPanel.showErrorMessage(SshVNCPanel.this, "Error", iOException);
                }
            }
        };
        this.registerAction(this.ctrlAltDelAction);
        this.clipboardAction = new ClipboardAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshVNCPanel.this.vnc.setClipboardVisible(!SshVNCPanel.this.vnc.isClipboardVisible());
            }
        };
        this.registerAction(this.clipboardAction);
        if (this.getApplication().getMRUModel() != null) {
            this.mruAction = new MRUActionImpl(this.getApplication().getMRUModel());
            this.registerAction(this.mruAction);
        }
        this.connectionPropertiesAction = new ConnectionPropertiesAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshVNCPanel.this.editConnection(SshVNCPanel.this.getCurrentConnectionProfile());
            }
        };
        this.registerAction(this.connectionPropertiesAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.openAction = new OpenAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.open();
                }
            };
            this.registerAction(this.openAction);
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.saveAction = new SaveAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.saveConnection(false, SshVNCPanel.this.getCurrentConnectionFile(), SshVNCPanel.this.getCurrentConnectionProfile());
                }
            };
            this.registerAction(this.saveAction);
            this.saveAsAction = new SaveAsAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.saveConnection(true, SshVNCPanel.this.getCurrentConnectionFile(), SshVNCPanel.this.getCurrentConnectionProfile());
                }
            };
            this.registerAction(this.saveAsAction);
            this.recordAction = new RecordAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.startRecording();
                }
            };
            this.registerAction(this.recordAction);
            this.stopAction = new StopAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.stopRecording();
                }
            };
            this.registerAction(this.stopAction);
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.editAction = new EditAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SshVNCPanel.this.editConnection();
                }
            };
            this.registerAction(this.editAction);
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
        List list = SessionProviderFactory.getInstance().getSessionProviders();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SessionProvider sessionProvider = (SessionProvider)iterator.next();
            SessionProviderAction sessionProviderAction = new SessionProviderAction(sessionProvider);
            this.sessionActions.put(sessionProviderAction.getActionCommand(), sessionProviderAction);
            sessionProviderAction.addActionListener(this);
            this.registerAction(sessionProviderAction);
        }
    }

    private void startRecording() {
        if (this.recordingFileChooser == null) {
            this.recordingFileChooser = new JFileChooser(System.getProperty("user.home"));
        }
        int n = this.recordingFileChooser.showSaveDialog(this);
        int n2 = 1;
        File file = null;
        while (file == null) {
            File file2 = new File(this.recordingFileChooser.getCurrentDirectory(), "vncsession.fbs." + n2);
            if (!file2.exists()) {
                file = file2;
            }
            ++n2;
        }
        this.recordingFileChooser.setSelectedFile(file);
        if (n == 0) {
            file = this.recordingFileChooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File " + file.getName() + " already exists. Are you sure?", "File exists", 0, 2) == 1) {
                return;
            }
            this.vnc.setRecordingStatus(file.getAbsolutePath());
            this.setAvailableActions();
        }
    }

    private void stopRecording() {
        this.vnc.setRecordingStatus(null);
        this.setAvailableActions();
    }

    public void refresh() {
        try {
            this.vnc.refresh();
        }
        catch (IOException iOException) {
            this.closeConnection(true);
            SshToolsApplicationPanel.showErrorMessage(this, "Error", iOException);
        }
    }

    public void setAvailableActions() {
        boolean bl = this.isConnected();
        this.newAction.setEnabled(!bl);
        this.closeAction.setEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.ctrlAltDelAction.setEnabled(bl);
        this.clipboardAction.setEnabled(bl);
        String string = this.vnc.getRecordingStatus();
        Iterator iterator = this.sessionActions.values().iterator();
        while (iterator.hasNext()) {
            SessionProviderAction sessionProviderAction = (SessionProviderAction)iterator.next();
            sessionProviderAction.setEnabled(bl);
        }
        if (this.stopAction != null) {
            this.stopAction.setEnabled(bl && string != null);
        }
        if (this.recordAction != null) {
            this.recordAction.setEnabled(bl && string == null);
        }
        if (this.openAction != null) {
            this.openAction.setEnabled(true);
        }
        this.connectionPropertiesAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        if (this.saveAction != null) {
            this.saveAction.setEnabled(bl && this.isNeedSave());
        }
        if (this.saveAsAction != null) {
            this.saveAsAction.setEnabled(bl);
        }
    }

    public void close() {
        this.closeConnection(true);
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    public boolean canClose() {
        return !this.isConnected() || JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) != 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MRUActionImpl
    extends MRUAction {
        public MRUActionImpl(MRUListModel mRUListModel) {
            super(mRUListModel);
        }

        public void cleanUp() {
            ((MRUMenu)this.getValue("menu")).cleanUp();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshVNCPanel.this.open(new File(actionEvent.getActionCommand()));
        }
    }

    class IOConnector
    extends Thread {
        InputStream in;
        OutputStream out;

        IOConnector(InputStream inputStream, OutputStream outputStream) {
            super("IOConnector");
            this.in = inputStream;
            this.out = outputStream;
            this.start();
        }

        public void run() {
            IOStreamConnector iOStreamConnector = new IOStreamConnector(this.in, this.out);
        }
    }

    class ErrorTextBox
    extends JTextArea {
        ErrorTextBox(String string) {
            super(string);
            this.setOpaque(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setEditable(false);
        }
    }
}

