/*
 * Decompiled with CFR 0.152.
 */
package com.levelonelabs.aim;

import com.levelonelabs.aim.AIMBuddy;
import com.levelonelabs.aim.AIMListener;
import com.levelonelabs.aim.AIMSender;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class AIMClient
implements Runnable,
AIMSender {
    private static final long TIME_DELAY = 300000L;
    private static final String PING = "PING";
    private AimConnectionCheck watchdogCheck;
    private AimConnectionCheck watchdogVerify;
    boolean connectionVerified = false;
    private Timer connectionCheck = new Timer();
    static Logger logger = Logger.getLogger((class$com$levelonelabs$aim$AIMClient == null ? (class$com$levelonelabs$aim$AIMClient = AIMClient.class$("com.levelonelabs.aim.AIMClient")) : class$com$levelonelabs$aim$AIMClient).getName());
    private static final int MAX_POINTS = 10;
    private static final int RECOVER_RATE = 2200;
    private static final String REVISION = "\"TIC:TOC2\" 160";
    private String loginServer = "toc.oscar.aol.com";
    private int loginPort = 5190;
    private String authorizerServer = "login.oscar.aol.com";
    private int authorizerPort = 29999;
    private List aimListeners = new ArrayList();
    String name;
    private String pass;
    private String info;
    private String nonUserResponse;
    boolean online;
    private boolean autoAddUsers = false;
    private int seqNo;
    private Socket connection;
    private DataInputStream in;
    private DataOutputStream out;
    private Map buddyHash;
    private int sendLimit = 10;
    private long lastFrameSendTime = System.currentTimeMillis();
    private int permitMode = 1;
    private Set permitted;
    private Set denied;
    static /* synthetic */ Class class$com$levelonelabs$aim$AIMClient;

    public AIMClient(String name, String pass, String info, String response, boolean autoAddUsers) {
        this.nonUserResponse = response;
        this.buddyHash = new HashMap();
        this.permitted = new HashSet();
        this.denied = new HashSet();
        this.name = AIMClient.imNormalize(name);
        this.pass = pass;
        this.info = info;
        this.autoAddUsers = autoAddUsers;
        this.addBuddy(new AIMBuddy(name));
    }

    public AIMClient(String name, String pass, String info, boolean autoAddUsers) {
        this(name, pass, info, "Sorry, you must be a user of this system to send requests.", autoAddUsers);
    }

    public AIMClient(String name, String pass, String info) {
        this(name, pass, info, false);
    }

    public AIMClient(String name, String pass) {
        this(name, pass, "No info", false);
    }

    public static String stripHTML(String line) {
        StringBuffer sb = new StringBuffer(line);
        String out = "";
        block0: for (int i = 0; i < sb.length() - 1; ++i) {
            int j;
            if (sb.charAt(i) != '<') continue;
            if (sb.charAt(i + 1) == '/' || sb.charAt(i + 1) >= 'a' && sb.charAt(i + 1) <= 'z' || sb.charAt(i + 1) >= 'A' && sb.charAt(i + 1) <= 'Z') {
                for (j = i + 1; j < sb.length(); ++j) {
                    if (sb.charAt(j) != '>') continue;
                    sb = sb.replace(i, j + 1, "");
                    --i;
                    continue block0;
                }
                continue;
            }
            if (sb.charAt(i + 1) != '!') continue;
            for (j = i + 1; j < sb.length(); ++j) {
                if (sb.charAt(j) != '>' || sb.charAt(j - 1) != '-' || sb.charAt(j - 2) != '-') continue;
                sb = sb.replace(i, j + 1, "");
                --i;
                continue block0;
            }
        }
        out = sb.toString();
        return out;
    }

    private static String imRoast(String pass) {
        String roast = "Tic/Toc";
        String out = "";
        String in = pass;
        String out2 = "0x";
        for (int i = 0; i < in.length(); ++i) {
            out = Long.toHexString(in.charAt(i) ^ roast.charAt(i % 7));
            if (out.length() < 2) {
                out2 = out2 + "0";
            }
            out2 = out2 + out;
        }
        return out2;
    }

    private static String imNormalize(String in) {
        String out = "";
        in = in.toLowerCase();
        char[] arr = in.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == ' ') continue;
            out = out + "" + arr[i];
        }
        return out;
    }

    public AIMBuddy getBuddy(String buddyName) {
        return (AIMBuddy)this.buddyHash.get(AIMClient.imNormalize(buddyName));
    }

    public Iterator getBuddyNames() {
        return Arrays.asList(this.buddyHash.keySet().toArray()).iterator();
    }

    public void signOn() {
        new Thread(this).start();
        this.watchdogCheck = new AimConnectionCheck(this, true);
        this.watchdogVerify = new AimConnectionCheck(this, false);
        this.connectionCheck.scheduleAtFixedRate((TimerTask)this.watchdogCheck, 300000L, 300000L);
        this.connectionCheck.scheduleAtFixedRate((TimerTask)this.watchdogVerify, 305000L, 300000L);
        for (int i = 0; i < 10; ++i) {
            if (!this.online) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            return;
        }
    }

    public void signOff() {
        this.watchdogCheck.cancel();
        this.watchdogVerify.cancel();
        this.signoff("User request");
    }

    public void run() {
        short length;
        this.seqNo = (int)Math.floor(Math.random() * 65535.0);
        InetAddress[] loginIPs = null;
        try {
            loginIPs = InetAddress.getAllByName(this.loginServer);
        }
        catch (UnknownHostException e) {
            this.signoff("0");
            this.generateError("Signon err", e.getMessage());
            return;
        }
        for (int i = 0; i < loginIPs.length; ++i) {
            try {
                logger.fine("Attempting to logon using IP:" + loginIPs[i]);
                this.connection = new Socket(loginIPs[i], this.loginPort);
                this.connection.setSoTimeout(10000);
                this.in = new DataInputStream(this.connection.getInputStream());
                this.out = new DataOutputStream(new BufferedOutputStream(this.connection.getOutputStream()));
                logger.fine("Successfully connected using IP:" + loginIPs[i]);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (this.connection == null || this.in == null || this.out == null) {
            this.signoff("1");
            this.generateError("Signon err", "Unable to establish connection to logon server.");
            return;
        }
        logger.fine("*** Starting AIM CLIENT (SEQNO:" + this.seqNo + ") ***");
        try {
            this.out.writeBytes("FLAPON\r\n\r\n");
            this.out.flush();
            byte[] signon = new byte[10];
            this.in.readFully(signon);
            this.out.writeByte(42);
            this.out.writeByte(1);
            this.out.writeShort(this.seqNo);
            this.seqNo = this.seqNo + 1 & 0xFFFF;
            this.out.writeShort(this.name.length() + 8);
            this.out.writeInt(1);
            this.out.writeShort(1);
            this.out.writeShort(this.name.length());
            this.out.writeBytes(this.name);
            this.out.flush();
            this.frameSend("toc2_signon " + this.authorizerServer + " " + this.authorizerPort + " " + this.name + " " + AIMClient.imRoast(this.pass) + " English " + REVISION + " " + AIMClient.toc2MagicNumber(this.name, this.pass) + "\u0000");
            this.in.skip(4L);
            length = this.in.readShort();
            signon = new byte[length];
            this.in.readFully(signon);
            if (new String(signon).startsWith("ERROR")) {
                this.fromAIM(signon);
                logger.severe("Signon error");
                this.signoff("2");
                return;
            }
            this.in.skip(4L);
            length = this.in.readShort();
            signon = new byte[length];
            this.in.readFully(signon);
            this.frameSend("toc_init_done\u0000");
            this.online = true;
            this.generateConnected();
            this.frameSend("toc_set_info \"" + this.info + "\"\u0000");
            logger.fine("Done with AIM logon");
            this.connection.setSoTimeout(3000);
        }
        catch (InterruptedIOException e) {
            this.signoff("2.25");
        }
        catch (IOException e) {
            this.signoff("3");
        }
        while (true) {
            try {
                while (true) {
                    this.in.skip(4L);
                    length = this.in.readShort();
                    byte[] data = new byte[length];
                    this.in.readFully(data);
                    this.fromAIM(data);
                }
            }
            catch (InterruptedIOException e) {
                continue;
            }
            catch (IOException e) {
                logger.severe("*** AIM ERROR: " + e + " ***");
                this.signoff("Connection reset.");
                return;
            }
            break;
        }
    }

    private static int toc2MagicNumber(String username, String password) {
        int sn = username.charAt(0) - 96;
        int pw = password.charAt(0) - 96;
        int a = sn * 7696 + 738816;
        int b = sn * 746512;
        int c = pw * a;
        return c - a + b + 71665152;
    }

    public void addAIMListener(AIMListener listener) {
        this.aimListeners.add(listener);
    }

    public void sendMessage(AIMBuddy buddy, String text) {
        if (buddy == null || buddy.isBanned()) {
            return;
        }
        if (buddy.isOnline()) {
            this.sendMesg(buddy.getName(), text);
        } else {
            try {
                this.frameSend("toc_get_status " + AIMClient.imNormalize(buddy.getName()) + "\u0000");
            }
            catch (IOException e) {
                logger.severe("Error sending status request for offline buddy: " + e.getMessage());
            }
        }
    }

    public void addBuddy(AIMBuddy buddy) {
        if (buddy == null) {
            return;
        }
        if (this.getBuddy(buddy.getName()) != null) {
            return;
        }
        if (this.online) {
            String toBeSent = "toc2_new_buddies {g:" + buddy.getGroup() + "\nb:" + AIMClient.imNormalize(buddy.getName()) + "\n}";
            try {
                this.frameSend(toBeSent + "\u0000");
            }
            catch (IOException e) {
                logger.severe(e.toString());
                this.signoff("Error adding buddy");
            }
        }
        this.buddyHash.put(AIMClient.imNormalize(buddy.getName()), buddy);
    }

    public void addBuddies(List buddyList) {
        Map groupMap = this.createGroupMap(buddyList);
        Iterator groupIter = groupMap.keySet().iterator();
        while (groupIter.hasNext()) {
            String group = (String)groupIter.next();
            String currentlist = "toc2_new_buddies {g:" + group + "\n";
            List groupList = (List)groupMap.get(group);
            for (int i = 0; i < groupList.size(); ++i) {
                AIMBuddy buddy = (AIMBuddy)groupList.get(i);
                this.buddyHash.put(AIMClient.imNormalize(buddy.getName()), buddy);
                currentlist = currentlist + "b:" + AIMClient.imNormalize(buddy.getName()) + "\n";
                if (currentlist.length() <= 1800) continue;
                try {
                    this.frameSend(currentlist + "}\u0000");
                    currentlist = "toc2_new_buddies {g:" + group + "\n";
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.severe("ERROR adding buddies.");
                }
            }
            if (currentlist.length() <= ("toc2_new_buddies {g:" + group + "\n").length()) continue;
            try {
                this.frameSend(currentlist + "}\u0000");
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.severe("ERROR adding buddies.");
            }
        }
    }

    private Map createGroupMap(List buddyList) {
        HashMap<String, ArrayList<AIMBuddy>> groupMap = new HashMap<String, ArrayList<AIMBuddy>>();
        Iterator iter = buddyList.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof AIMBuddy)) continue;
            AIMBuddy buddy = (AIMBuddy)obj;
            String group = buddy.getGroup();
            ArrayList<AIMBuddy> groupList = (ArrayList<AIMBuddy>)groupMap.get(group);
            if (groupList == null) {
                groupList = new ArrayList<AIMBuddy>();
                groupMap.put(group, groupList);
            }
            groupList.add(buddy);
        }
        return groupMap;
    }

    public void removeBuddy(AIMBuddy buddy) {
        if (buddy == null) {
            return;
        }
        if (this.getBuddy(buddy.getName()) == null) {
            return;
        }
        String buddyname = AIMClient.imNormalize(buddy.getName());
        String toBeSent = "toc2_remove_buddy";
        try {
            this.frameSend(toBeSent + " " + buddyname + " " + buddy.getGroup() + "\u0000");
        }
        catch (IOException e) {
            logger.severe(e.toString());
            this.signoff("Error removing buddy.");
        }
        this.buddyHash.remove(AIMClient.imNormalize(buddy.getName()));
    }

    public void removeBuddies(List buddyList) {
        Map groupMap = this.createGroupMap(buddyList);
        Iterator groupIter = groupMap.keySet().iterator();
        while (groupIter.hasNext()) {
            String group = (String)groupIter.next();
            String currentlist = "toc2_remove_buddy";
            List groupList = (List)groupMap.get(group);
            for (int i = 0; i < groupList.size(); ++i) {
                AIMBuddy buddy = (AIMBuddy)groupList.get(i);
                this.buddyHash.remove(AIMClient.imNormalize(buddy.getName()));
                currentlist = currentlist + " " + AIMClient.imNormalize(buddy.getName());
                if (currentlist.length() <= 1800) continue;
                try {
                    this.frameSend(currentlist + " " + group + "\u0000");
                    currentlist = "toc2_remove_buddy";
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.severe("ERROR removing buddies.");
                }
            }
            if (currentlist.length() <= "toc2_remove_buddy".length()) continue;
            try {
                this.frameSend(currentlist + " " + group + "\u0000");
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.severe("ERROR adding buddies.");
            }
        }
    }

    public void sendWarning(AIMBuddy buddy) {
        if (buddy == null) {
            return;
        }
        logger.fine("Attempting to warn: " + buddy.getName() + ".");
        String work = "toc_evil ";
        work = work.concat(AIMClient.imNormalize(buddy.getName()));
        work = work.concat(" norm \u0000");
        try {
            this.frameSend(work);
        }
        catch (IOException e) {
            this.signoff("9");
        }
    }

    public void banBuddy(AIMBuddy buddy) {
        if (buddy == null || buddy.getName().length() == 0) {
            return;
        }
        if (this.getBuddy(buddy.getName()) == null) {
            return;
        }
        buddy.setBanned(true);
        this.sendDeny(AIMClient.imNormalize(buddy.getName()));
    }

    private void sendDeny(String buddyname) {
        if (buddyname.length() == 0) {
            logger.fine("Attempting to permit all.");
        } else {
            logger.fine("Attempting to deny: " + buddyname + ".");
        }
        String toBeSent = "toc2_add_deny";
        try {
            this.frameSend(toBeSent + " " + buddyname + "\u0000");
        }
        catch (IOException e) {
            logger.severe(e.toString());
            this.signoff("7.75");
        }
    }

    private void sendPermit(String buddyname) {
        logger.fine("Attempting to permit: " + buddyname + ".");
        String toBeSent = "toc2_add_permit";
        try {
            this.frameSend(toBeSent + " " + buddyname + "\u0000");
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            this.signoff("7.875");
        }
    }

    private void frameSend(String toBeSent) throws IOException {
        if (this.sendLimit < 10) {
            this.sendLimit = (int)((long)this.sendLimit + (System.currentTimeMillis() - this.lastFrameSendTime) / 2200L);
            this.sendLimit = Math.min(10, this.sendLimit);
            if (this.sendLimit < 10) {
                logger.fine("Current send limit=" + this.sendLimit + " out of " + 10);
                try {
                    int waitAmount = 10 - this.sendLimit;
                    logger.fine("Delaying send " + waitAmount + " units");
                    Thread.sleep(2200 * waitAmount);
                    this.sendLimit += waitAmount;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.out.writeByte(42);
        this.out.writeByte(2);
        this.out.writeShort(this.seqNo);
        this.seqNo = this.seqNo + 1 & 0xFFFF;
        this.out.writeShort(toBeSent.length());
        this.out.writeBytes(toBeSent);
        this.out.flush();
        int warnAmount = this.getBuddy(this.name).getWarningAmount();
        this.sendLimit = (int)((double)this.sendLimit - (1.0 + Math.pow(3 * warnAmount / 100, 2.0)));
        this.lastFrameSendTime = System.currentTimeMillis();
    }

    private void generateMessage(String from, String request) {
        AIMBuddy aimbud = this.getBuddy(from);
        if (aimbud == null) {
            if (this.autoAddUsers) {
                aimbud = new AIMBuddy(from);
                this.addBuddy(aimbud);
                aimbud.setOnline(true);
            } else {
                logger.info("MESSAGE FROM A NON BUDDY(" + from + ")");
                if (this.nonUserResponse != null && !this.nonUserResponse.equals("")) {
                    this.sendMesg(from, this.nonUserResponse);
                }
                return;
            }
        }
        if (aimbud.isBanned()) {
            logger.fine("Ignoring message from banned user (" + from + "):" + request);
        } else {
            for (int i = 0; i < this.aimListeners.size(); ++i) {
                try {
                    ((AIMListener)this.aimListeners.get(i)).handleMessage(aimbud, request);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void generateWarning(String from, int amount) {
        AIMBuddy aimbud = this.getBuddy(from);
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleWarning(aimbud, amount);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateConnected() {
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleConnected();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateDisconnected() {
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleDisconnected();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateError(String error, String message) {
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleError(error, message);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateBuddySignOn(String buddy, String message) {
        AIMBuddy aimbud = this.getBuddy(buddy);
        if (aimbud == null) {
            logger.severe("ERROR:  NOTIFICATION ABOUT NON BUDDY(" + buddy + ")");
            return;
        }
        if (!aimbud.isOnline()) {
            aimbud.setOnline(true);
            for (int i = 0; i < this.aimListeners.size(); ++i) {
                try {
                    ((AIMListener)this.aimListeners.get(i)).handleBuddySignOn(aimbud, message);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void generateBuddySignOff(String buddy, String message) {
        AIMBuddy aimbud = this.getBuddy(buddy);
        if (aimbud == null) {
            logger.severe("ERROR:  NOTIFICATION ABOUT NON BUDDY(" + buddy + ")");
            return;
        }
        aimbud.setOnline(false);
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleBuddySignOff(aimbud, message);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateBuddyAvailable(String buddy, String message) {
        AIMBuddy aimbud = this.getBuddy(buddy);
        if (aimbud == null) {
            logger.severe("ERROR:  NOTIFICATION ABOUT NON BUDDY(" + buddy + ")");
            return;
        }
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleBuddyAvailable(aimbud, message);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateBuddyUnavailable(String buddy, String message) {
        AIMBuddy aimbud = this.getBuddy(buddy);
        if (aimbud == null) {
            logger.severe("ERROR:  NOTIFICATION ABOUT NON BUDDY(" + buddy + ")");
            return;
        }
        for (int i = 0; i < this.aimListeners.size(); ++i) {
            try {
                ((AIMListener)this.aimListeners.get(i)).handleBuddyUnavailable(aimbud, message);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fromAIM(byte[] buffer) {
        try {
            String inString = new String(buffer);
            logger.fine("*** AIM: " + inString + " ***");
            StringTokenizer inToken = new StringTokenizer(inString, ":");
            String command = inToken.nextToken();
            if (command.equals("IM_IN2")) {
                this.connectionVerified = true;
                String from = AIMClient.imNormalize(inToken.nextToken());
                inToken.nextToken();
                inToken.nextToken();
                String mesg = inToken.nextToken();
                while (inToken.hasMoreTokens()) {
                    mesg = mesg + ":" + inToken.nextToken();
                }
                String request = AIMClient.stripHTML(mesg);
                if (from.equalsIgnoreCase(this.name) && request.equals(PING)) {
                    logger.fine("AIM CONNECTION VERIFIED(" + new Date() + ").");
                    return;
                }
                logger.fine("*** AIM MESSAGE: " + from + " > " + request + " ***");
                this.generateMessage(from, request.trim());
                return;
            }
            if (command.equals("CONFIG2")) {
                if (inToken.hasMoreElements()) {
                    String config = inToken.nextToken();
                    while (inToken.hasMoreTokens()) {
                        config = config + ":" + inToken.nextToken();
                    }
                    this.processConfig(config);
                    logger.fine("*** AIM CONFIG RECEIVED ***");
                } else {
                    this.setPermitMode(1);
                    logger.fine("*** AIM NO CONFIG RECEIVED ***");
                }
                return;
            }
            if (command.equals("EVILED")) {
                int amount = Integer.parseInt(inToken.nextToken());
                String from = "anonymous";
                if (inToken.hasMoreElements()) {
                    from = AIMClient.imNormalize(inToken.nextToken());
                }
                if (this.getBuddy(this.name).getWarningAmount() < amount) {
                    this.generateWarning(from, amount);
                }
                return;
            }
            if (command.equals("UPDATE_BUDDY2")) {
                String bname = AIMClient.imNormalize(inToken.nextToken());
                AIMBuddy aimbud = this.getBuddy(bname);
                if (aimbud == null) {
                    logger.severe("ERROR:  NOTIFICATION ABOUT NON BUDDY(" + bname + ")");
                    return;
                }
                String stat = inToken.nextToken();
                if (stat.equals("T")) {
                    this.generateBuddySignOn(bname, "INFO");
                } else if (stat.equals("F")) {
                    this.generateBuddySignOff(bname, "INFO");
                }
                int evilAmount = Integer.parseInt(inToken.nextToken());
                aimbud.setWarningAmount(evilAmount);
                if (stat.equals("T")) {
                    String signOnTime = inToken.nextToken();
                    String idleTime = inToken.nextToken();
                    if (-1 != inToken.nextToken().indexOf(85)) {
                        this.generateBuddyUnavailable(bname, "INFO");
                    } else {
                        this.generateBuddyAvailable(bname, "INFO");
                    }
                }
                return;
            }
            if (command.equals("ERROR")) {
                String error = inToken.nextToken();
                logger.severe("*** AIM ERROR: " + error + " ***");
                if (error.equals("901")) {
                    this.generateError(error, "Not currently available");
                    return;
                }
                if (error.equals("902")) {
                    this.generateError(error, "Warning not currently available");
                    return;
                }
                if (error.equals("903")) {
                    this.generateError(error, "Message dropped, sending too fast");
                    return;
                }
                if (error.equals("960")) {
                    String person = inToken.nextToken();
                    this.generateError(error, "Sending messages too fast to " + person);
                    return;
                }
                if (error.equals("961")) {
                    String person = inToken.nextToken();
                    this.generateError(error, person + " sent you too big a message");
                    return;
                }
                if (error.equals("962")) {
                    String person = inToken.nextToken();
                    this.generateError(error, person + " sent you a message too fast");
                    return;
                }
                if (error.equals("Signon err")) {
                    String text = inToken.nextToken();
                    this.generateError(error, "AIM Signon failure: " + text);
                    this.signoff("5");
                }
                return;
            }
        }
        catch (Exception e) {
            logger.severe("ERROR: failed to handle aim protocol properly");
            e.printStackTrace();
        }
    }

    private void processConfig(String config) {
        int new_permit_mode = 1;
        BufferedReader br = new BufferedReader(new StringReader(config));
        try {
            String line;
            String current_group = "TOC";
            while (null != (line = br.readLine()) && !line.equals("done")) {
                char type = line.charAt(0);
                String arg = line.substring(2);
                switch (type) {
                    case 'g': {
                        current_group = arg;
                        break;
                    }
                    case 'b': {
                        AIMBuddy buddy = null;
                        buddy = (AIMBuddy)this.buddyHash.get(AIMClient.imNormalize(arg));
                        if (buddy == null) {
                            buddy = new AIMBuddy(arg, current_group);
                            this.buddyHash.put(AIMClient.imNormalize(arg), buddy);
                            break;
                        }
                        buddy.setGroup(current_group);
                        break;
                    }
                    case 'p': {
                        this.permitted.add(AIMClient.imNormalize(arg));
                        break;
                    }
                    case 'd': {
                        this.denied.add(AIMClient.imNormalize(arg));
                        break;
                    }
                    case 'm': {
                        new_permit_mode = Integer.parseInt(arg);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warning("Error reading configuration.");
            this.signoff("2.25");
            return;
        }
        this.addBuddies(new ArrayList(this.buddyHash.values()));
        this.setPermitMode(new_permit_mode);
    }

    void sendMesg(String to, String text) {
        if (text.length() >= 1024) {
            text = text.substring(0, 1024);
        }
        logger.fine("Sending Message " + to + " > " + text);
        String work = "toc2_send_im ";
        work = work.concat(to);
        work = work.concat(" \"");
        block5: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    work = work.concat("\\" + text.charAt(i));
                    continue block5;
                }
                default: {
                    work = work.concat("" + text.charAt(i));
                }
            }
        }
        work = work.concat("\"\u0000");
        try {
            this.frameSend(work);
        }
        catch (IOException e) {
            logger.severe("*** AIM ERROR: sending message.");
            e.printStackTrace();
            this.signoff("9");
        }
    }

    private void sendAway(String reason) {
        String work = "toc_set_away \"" + reason + "\"\u0000";
        try {
            this.frameSend(work);
        }
        catch (IOException e) {
            this.signoff("10");
        }
    }

    private void signoff(String place) {
        this.online = false;
        logger.fine("Trying to close IM (" + place + ").....");
        try {
            if (null != this.out) {
                this.out.close();
            }
            if (null != this.in) {
                this.in.close();
            }
            if (null != this.connection) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            logger.severe(e.toString());
        }
        this.generateDisconnected();
        logger.fine("*** AIM CLIENT SIGNED OFF.");
    }

    public void denyBuddy(AIMBuddy buddy) {
        String bname = AIMClient.imNormalize(buddy.getName());
        this.permitted.remove(bname);
        this.denied.add(bname);
        this.sendDeny(bname);
    }

    public void permitBuddy(AIMBuddy buddy) {
        String bname = AIMClient.imNormalize(buddy.getName());
        this.denied.remove(bname);
        this.permitted.add(bname);
        this.sendPermit(bname);
    }

    public int getPermitMode() {
        return this.permitMode;
    }

    public void setPermitMode(int mode) {
        if (mode < 1 || mode > 5) {
            logger.info("Invalid permit mode, ignoring:" + mode);
            return;
        }
        if (mode == 4 && this.denied.size() == 0) {
            logger.info("Attempting to deny some, and none are denied, ignoring.");
            return;
        }
        if (mode == 3 && this.permitted.size() == 0) {
            logger.info("Attempting to permit some, and none are permitted, ignoring.");
            return;
        }
        logger.info("Setting permit mode to:" + mode);
        this.permitMode = mode;
        try {
            this.frameSend("toc2_set_pdmode " + this.permitMode + "\u0000");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.severe("ERROR setting permit mode!");
        }
    }

    public void setAvailable() {
        this.sendAway("");
    }

    public void setUnavailable(String reason) {
        this.sendAway(reason);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AimConnectionCheck
    extends TimerTask {
        AIMClient aim;
        private boolean sender;

        public AimConnectionCheck(AIMClient aim, boolean sender) {
            this.aim = aim;
            this.sender = sender;
        }

        public void run() {
            try {
                if (this.sender) {
                    this.aim.connectionVerified = false;
                    if (this.aim.online) {
                        this.aim.sendMesg(this.aim.name, AIMClient.PING);
                    }
                } else if (!this.aim.connectionVerified) {
                    logger.info("*** AIM -- CONNECTION PROBLEM(" + new Date() + "): Connection was not verified!");
                    logger.info("****** Assuming it was dropped, issuing restart.");
                    this.aim.signoff("Connection Dropped!");
                    new Thread(this.aim).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

