/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.context.ViewIdHolder;

public abstract class AjaxContext {
    public static final String AJAX_CONTEXT_KEY = "ajaxContext";
    public static final String SCRIPTS_PARAMETER = "org.ajax4jsf.framework.HEADER_SCRIPTS";
    public static final String STYLES_PARAMETER = "org.ajax4jsf.framework.HEADER_STYLES";
    public static final String RESPONSE_DATA_KEY = "_ajax:data";
    private static final String SERVICE_RESOURCE = "META-INF/services/" + (class$org$ajax4jsf$context$AjaxContext == null ? (class$org$ajax4jsf$context$AjaxContext = AjaxContext.class$("org.ajax4jsf.context.AjaxContext")) : class$org$ajax4jsf$context$AjaxContext).getName();
    private static final String DEFAULT_CONTEXT_CLASS = "org.ajax4jsf.context.AjaxContextImpl";
    private static Map ajaxContextClasses = new HashMap();
    static /* synthetic */ Class class$org$ajax4jsf$context$AjaxContext;

    public abstract Map getCommonAjaxParameters();

    public abstract String getAjaxActionURL(FacesContext var1);

    public abstract String getAjaxActionURL();

    public abstract void setResponseData(Object var1);

    public abstract Object getResponseData();

    public abstract void setOncomplete(Object var1);

    public abstract Object getOncomplete();

    public abstract void setViewIdHolder(ViewIdHolder var1);

    public abstract ViewIdHolder getViewIdHolder();

    public abstract boolean removeRenderedArea(String var1);

    public abstract void addRenderedArea(String var1);

    public abstract Set getAjaxRenderedAreas();

    public abstract void addComponentToAjaxRender(UIComponent var1, String var2);

    public abstract void addComponentToAjaxRender(UIComponent var1);

    public abstract void addRegionsFromComponent(UIComponent var1);

    public abstract Set getAjaxAreasToRender();

    public abstract boolean isAjaxRequest(FacesContext var1);

    public abstract boolean isAjaxRequest();

    public abstract void processHeadResources(FacesContext var1) throws FacesException;

    public abstract void encodeAjaxEnd(FacesContext var1, UIComponent var2) throws IOException;

    public abstract void encodeAjaxBegin(FacesContext var1, UIComponent var2) throws IOException;

    public abstract void renderAjaxRegion(FacesContext var1, UIComponent var2, boolean var3) throws FacesException;

    public abstract void renderSubmittedAjaxRegion(FacesContext var1, boolean var2);

    public abstract void renderSubmittedAjaxRegion(FacesContext var1);

    public static AjaxContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AjaxContext getCurrentInstance(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("FacesContext is null");
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        AjaxContext ajaxContext = (AjaxContext)requestMap.get(AJAX_CONTEXT_KEY);
        if (null == ajaxContext) {
            Class<?> clazz;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Map map = ajaxContextClasses;
            synchronized (map) {
                clazz = (Class<?>)ajaxContextClasses.get(contextClassLoader);
                if (null == clazz) {
                    String factoryClassName = DEFAULT_CONTEXT_CLASS;
                    InputStream input = null;
                    input = contextClassLoader.getResourceAsStream(SERVICE_RESOURCE);
                    if (input != null) {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                            factoryClassName = reader.readLine();
                        }
                        catch (Exception e) {
                            throw new FacesException("Error to create AjaxContext Instance", (Throwable)e);
                        }
                        finally {
                            try {
                                input.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    try {
                        clazz = Class.forName(factoryClassName, false, contextClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new FacesException("AjaxContext implementation class " + factoryClassName + " not found ", (Throwable)e);
                    }
                    ajaxContextClasses.put(contextClassLoader, clazz);
                }
            }
            try {
                ajaxContext = (AjaxContext)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new FacesException("Error to create AjaxContext Instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException("No access to AjaxContext constructor", (Throwable)e);
            }
            requestMap.put(AJAX_CONTEXT_KEY, ajaxContext);
        }
        return ajaxContext;
    }

    public abstract void release();

    public abstract Map getResponseDataMap();

    public abstract void setAjaxRequest(boolean var1);

    public abstract boolean isSelfRender();

    public abstract void setSelfRender(boolean var1);

    public abstract String getSubmittedRegionClientId(FacesContext var1);

    public abstract void saveViewState(FacesContext var1) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

