/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.InputStream;
import java.util.ArrayList;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.repository.Association;
import org.alfresco.webservice.repository.AssociationDirectionEnum;
import org.alfresco.webservice.repository.QueryResult;
import org.alfresco.webservice.repository.RepositoryServiceLocator;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLAddAspect;
import org.alfresco.webservice.types.CMLCopy;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.CMLDelete;
import org.alfresco.webservice.types.CMLUpdate;
import org.alfresco.webservice.types.CMLWriteContent;
import org.alfresco.webservice.types.ClassDefinition;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.NodeDefinition;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.PropertyDefinition;
import org.alfresco.webservice.types.Query;
import org.alfresco.webservice.types.QueryConfiguration;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.ResultSet;
import org.alfresco.webservice.types.ResultSetRow;
import org.alfresco.webservice.types.ResultSetRowNode;
import org.alfresco.webservice.types.Store;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;
import org.alfresco.webservice.util.Utils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(RepositoryServiceSystemTest.class);

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetStores() throws Exception {
        Store[] stores = WebServiceFactory.getRepositoryService().getStores();
        RepositoryServiceSystemTest.assertNotNull((String)"Stores array should not be null", (Object)stores);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least 1 store", (stores.length >= 1 ? 1 : 0) != 0);
    }

    public void testQuery() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        QueryResult queryResult = WebServiceFactory.getRepositoryService().query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        logger.debug((Object)("There are " + resultSet.getTotalRowCount() + " rows:"));
        if (resultSet.getTotalRowCount() > 0L) {
            ResultSetRow[] rows = resultSet.getRows();
            for (int x = 0; x < rows.length; ++x) {
                ResultSetRow row = rows[x];
                NamedValue[] columns = row.getColumns();
                for (int y = 0; y < columns.length; ++y) {
                    logger.debug((Object)("row " + x + ": " + row.getColumns(y).getName() + " = " + row.getColumns(y).getValue()));
                }
            }
        } else {
            logger.debug((Object)"The query returned no results");
            RepositoryServiceSystemTest.fail((String)"The query returned no results");
        }
    }

    public void testQuerySession() throws Exception {
        String querySession;
        Query query = new Query("lucene", "*");
        int batchSize = 5;
        QueryConfiguration queryCfg = new QueryConfiguration();
        queryCfg.setFetchSize(batchSize);
        WebServiceFactory.getRepositoryService().setHeader(new RepositoryServiceLocator().getServiceName().getNamespaceURI(), "QueryHeader", queryCfg);
        QueryResult queryResult = WebServiceFactory.getRepositoryService().query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        String origQuerySession = querySession = queryResult.getQuerySession();
        RepositoryServiceSystemTest.assertNotNull((String)"querySession should not be null", (Object)querySession);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        logger.debug((Object)("There are " + resultSet.getTotalRowCount() + " rows in total"));
        logger.debug((Object)("There are " + resultSet.getRows().length + " rows in the first set"));
        RepositoryServiceSystemTest.assertEquals((String)("The result set size should be " + batchSize), (int)batchSize, (int)resultSet.getRows().length);
        queryResult = WebServiceFactory.getRepositoryService().fetchMore(querySession);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        querySession = queryResult.getQuerySession();
        RepositoryServiceSystemTest.assertNotNull((String)"querySession should not be null", (Object)querySession);
        ResultSet resultSet2 = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The second result set should not be null", (Object)resultSet2);
        logger.debug((Object)("There are " + resultSet2.getRows().length + " rows in the second set"));
        RepositoryServiceSystemTest.assertEquals((String)("The result set size should be " + batchSize), (int)batchSize, (int)resultSet2.getRows().length);
        while (querySession != null) {
            queryResult = WebServiceFactory.getRepositoryService().fetchMore(querySession);
            RepositoryServiceSystemTest.assertNotNull((String)"queryResult returned in loop should not be null", (Object)queryResult);
            querySession = queryResult.getQuerySession();
            logger.debug((Object)("There were another " + queryResult.getResultSet().getRows().length + " rows returned"));
        }
        try {
            queryResult = WebServiceFactory.getRepositoryService().fetchMore(origQuerySession);
            RepositoryServiceSystemTest.fail((String)"We should have seen an error as all the results have been returned");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testQueryParents() throws Exception {
        Reference node = BaseWebServiceSystemTest.rootReference;
        String rootId = node.getUuid();
        QueryResult rootChildren = WebServiceFactory.getRepositoryService().queryChildren(node);
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildren should not be null", (Object)rootChildren);
        ResultSet rootChildrenResults = rootChildren.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"rootChildrenResults should not be null", (Object)rootChildrenResults);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one child of the root node", (rootChildrenResults.getRows().length > 0 ? 1 : 0) != 0);
        ResultSetRow firstRow = rootChildrenResults.getRows(0);
        RepositoryServiceSystemTest.assertNotNull((String)"getColumns() should not return null", (Object)firstRow.getColumns());
        String id = firstRow.getNode().getId();
        logger.debug((Object)("Retrieving parents for first node found: " + id + "...."));
        node = new Reference();
        node.setStore(BaseWebServiceSystemTest.store);
        node.setUuid(id);
        QueryResult parents = WebServiceFactory.getRepositoryService().queryParents(node);
        RepositoryServiceSystemTest.assertNotNull((String)"parents should not be null", (Object)parents);
        ResultSet parentsResults = parents.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"parentsResults should not be null", (Object)parentsResults);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one parent", (parentsResults.getRows().length > 0 ? 1 : 0) != 0);
        boolean rootFound = false;
        ResultSetRow[] rows = parentsResults.getRows();
        for (int x = 0; x < rows.length; ++x) {
            ResultSetRow row = rows[x];
            RepositoryServiceSystemTest.assertNotNull((String)"getColumns() should not return null", (Object)row.getColumns());
            ResultSetRowNode rowNode = row.getNode();
            String nodeId = rowNode.getId();
            logger.debug((Object)("parent node = " + nodeId + ", type = " + rowNode.getType()));
            if (!nodeId.equals(rootId)) continue;
            rootFound = true;
        }
        RepositoryServiceSystemTest.assertTrue((String)"The root node was not found as one of the parents!!", (boolean)rootFound);
    }

    public void testQueryAssociated() throws Exception {
        Association association = new Association(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "translations"), AssociationDirectionEnum.target);
        QueryResult result = WebServiceFactory.getRepositoryService().queryAssociated(BaseWebServiceSystemTest.contentReference, new Association[]{association});
        RepositoryServiceSystemTest.assertNotNull((Object)result);
        RepositoryServiceSystemTest.assertNotNull((Object)result.getResultSet());
        RepositoryServiceSystemTest.assertNotNull((Object)result.getResultSet().getRows());
        RepositoryServiceSystemTest.assertEquals((int)1, (int)result.getResultSet().getRows().length);
    }

    public void testDescribe() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        QueryResult queryResult = this.repositoryService.query(BaseWebServiceSystemTest.store, query, false);
        RepositoryServiceSystemTest.assertNotNull((String)"queryResult should not be null", (Object)queryResult);
        ResultSet resultSet = queryResult.getResultSet();
        RepositoryServiceSystemTest.assertNotNull((String)"The result set should not be null", (Object)resultSet);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (resultSet.getTotalRowCount() > 0L ? 1 : 0) != 0);
        String id = resultSet.getRows(0).getNode().getId();
        RepositoryServiceSystemTest.assertNotNull((String)"Id of Alfresco Tutorial PDF should not be null", (Object)id);
        Reference ref = new Reference();
        ref.setStore(BaseWebServiceSystemTest.store);
        ref.setUuid(id);
        Predicate predicate = new Predicate(new Reference[]{ref}, null, null);
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should only be one result", (nodeDefs.length == 1 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        RepositoryServiceSystemTest.assertEquals((String)"Type name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}content", (String)typeDef.getName());
        RepositoryServiceSystemTest.assertEquals((String)"Superclass type name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}cmobject", (String)typeDef.getSuperClass());
        RepositoryServiceSystemTest.assertEquals((String)"Type title is incorrect", (String)"Content", (String)typeDef.getTitle());
        RepositoryServiceSystemTest.assertEquals((String)"Type description is incorrect", (String)"Base Content Object", (String)typeDef.getDescription());
        RepositoryServiceSystemTest.assertFalse((String)"Type is an aspect and it shouldn't be", (boolean)typeDef.isIsAspect());
        RepositoryServiceSystemTest.assertNull((String)"There should not be any associations", (Object)typeDef.getAssociations());
        RepositoryServiceSystemTest.assertNotNull((String)"Properties should not be null", (Object)typeDef.getProperties());
        RepositoryServiceSystemTest.assertEquals((String)"There should be 2 properties", (int)2, (int)typeDef.getProperties().length);
        RepositoryServiceSystemTest.assertEquals((String)"Property1 name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}content", (String)typeDef.getProperties(0).getName());
        RepositoryServiceSystemTest.assertEquals((String)"Property1 type name is incorrect", (String)"{http://www.alfresco.org/model/dictionary/1.0}content", (String)typeDef.getProperties(0).getDataType());
        RepositoryServiceSystemTest.assertEquals((String)"Property5 name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}name", (String)typeDef.getProperties(1).getName());
        RepositoryServiceSystemTest.assertEquals((String)"Property5 type name is incorrect", (String)"{http://www.alfresco.org/model/dictionary/1.0}text", (String)typeDef.getProperties(1).getDataType());
        ClassDefinition[] aspects = nodeDef.getAspects();
        RepositoryServiceSystemTest.assertNotNull((String)"aspects should not be null", (Object)aspects);
        RepositoryServiceSystemTest.assertEquals((String)"There should be 2 aspects", (int)2, (int)aspects.length);
        ClassDefinition aspect1 = aspects[0];
        RepositoryServiceSystemTest.assertEquals((String)"Aspect1 name is incorrect", (String)"{http://www.alfresco.org/model/system/1.0}referenceable", (String)aspect1.getName());
        RepositoryServiceSystemTest.assertTrue((String)"Aspect1 should be an aspect", (boolean)aspect1.isIsAspect());
        RepositoryServiceSystemTest.assertNotNull((String)"Aspect1 should have properties", (Object)aspect1.getProperties());
        RepositoryServiceSystemTest.assertEquals((String)"Aspect1 has wrong number of properties", (int)4, (int)aspect1.getProperties().length);
        ClassDefinition aspect2 = aspects[1];
        RepositoryServiceSystemTest.assertEquals((String)"Aspect2 name is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}auditable", (String)aspect2.getName());
        RepositoryServiceSystemTest.assertTrue((String)"Aspect2 should be an aspect", (boolean)aspect2.isIsAspect());
        RepositoryServiceSystemTest.assertNotNull((String)"Aspect2 should have properties", (Object)aspect2.getProperties());
        RepositoryServiceSystemTest.assertEquals((String)"Aspect2 has wrong number of properties", (int)5, (int)aspect2.getProperties().length);
    }

    public void testPredicateQuery() throws Exception {
        Query query = new Query("lucene", "( +@\\{http\\://www.alfresco.org/1.0\\}name:test*) OR  TEXT:test*");
        Predicate predicate = new Predicate();
        predicate.setQuery(query);
        predicate.setStore(BaseWebServiceSystemTest.store);
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (nodeDefs.length > 0 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        logger.debug((Object)("type name = " + typeDef.getName()));
        logger.debug((Object)("is aspect = " + typeDef.isIsAspect()));
        PropertyDefinition[] propDefs = typeDef.getProperties();
        if (propDefs != null) {
            logger.debug((Object)("There are " + propDefs.length + " properties:"));
            for (int x = 0; x < propDefs.length; ++x) {
                PropertyDefinition propDef = propDefs[x];
                logger.debug((Object)("name = " + propDef.getName() + " type = " + propDef.getDataType()));
            }
        }
    }

    public void testPathReference() throws Exception {
        Reference ref = new Reference();
        ref.setStore(BaseWebServiceSystemTest.store);
        ref.setPath("//*[@cm:name = 'test folder']");
        Predicate predicate = new Predicate();
        predicate.setNodes(new Reference[]{ref});
        NodeDefinition[] nodeDefs = WebServiceFactory.getRepositoryService().describe(predicate);
        RepositoryServiceSystemTest.assertNotNull((String)"nodeDefs should not be null", (Object)nodeDefs);
        RepositoryServiceSystemTest.assertTrue((String)"There should be at least one result", (nodeDefs.length > 0 ? 1 : 0) != 0);
        NodeDefinition nodeDef = nodeDefs[0];
        RepositoryServiceSystemTest.assertNotNull((String)"The nodeDef should not be null", (Object)nodeDef);
        ClassDefinition typeDef = nodeDef.getType();
        RepositoryServiceSystemTest.assertNotNull((String)"Type definition should not be null", (Object)typeDef);
        logger.debug((Object)("type name = " + typeDef.getName()));
        RepositoryServiceSystemTest.assertEquals((String)"Type is incorrect", (String)"{http://www.alfresco.org/model/content/1.0}folder", (String)typeDef.getName());
        logger.debug((Object)("is aspect = " + typeDef.isIsAspect()));
        RepositoryServiceSystemTest.assertFalse((String)"Item should not be an aspect", (boolean)typeDef.isIsAspect());
        PropertyDefinition[] propDefs = typeDef.getProperties();
        if (propDefs != null) {
            logger.debug((Object)("There are " + propDefs.length + " properties:"));
            for (int x = 0; x < propDefs.length; ++x) {
                PropertyDefinition propDef = propDefs[x];
                logger.debug((Object)("name = " + propDef.getName() + " type = " + propDef.getDataType()));
            }
        }
    }

    public void testUpdate() throws Exception {
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(Constants.TYPE_CONTENT);
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(Constants.ASSOC_CHILDREN);
        parentReference.setChildName(Constants.ASSOC_CHILDREN);
        parentReference.setStore(BaseWebServiceSystemTest.store);
        parentReference.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        create.setParent(parentReference);
        create.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "name.txt", null)});
        CMLCreate createFolder = new CMLCreate();
        createFolder.setId("folder1");
        createFolder.setType(Constants.TYPE_FOLDER);
        createFolder.setParent(parentReference);
        createFolder.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "tempFolder", null)});
        CMLAddAspect aspect = new CMLAddAspect();
        aspect.setAspect(Constants.ASPECT_VERSIONABLE);
        aspect.setWhere_id("id1");
        ContentFormat format = new ContentFormat("text/plain", "UTF-8");
        CMLWriteContent write = new CMLWriteContent();
        write.setProperty(Constants.PROP_CONTENT);
        write.setContent("this is a test".getBytes());
        write.setFormat(format);
        write.setWhere_id("id1");
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create, createFolder});
        cml.setAddAspect(new CMLAddAspect[]{aspect});
        cml.setWriteContent(new CMLWriteContent[]{write});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        RepositoryServiceSystemTest.assertNotNull((Object)results);
        RepositoryServiceSystemTest.assertEquals((int)4, (int)results.length);
        Reference reference = results[0].getDestination();
        Reference folderReference = results[1].getDestination();
        Content[] content = WebServiceFactory.getContentService().read(new Predicate(new Reference[]{reference}, null, null), Constants.PROP_CONTENT);
        RepositoryServiceSystemTest.assertNotNull((Object)content);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)content.length);
        RepositoryServiceSystemTest.assertEquals((String)"this is a test", (String)ContentUtils.getContentAsString(content[0]));
        CMLCopy copy = new CMLCopy();
        copy.setTo(new ParentReference(folderReference.getStore(), folderReference.getUuid(), null, Constants.ASSOC_CONTAINS, "{test}name.txt"));
        copy.setWhere(new Predicate(new Reference[]{reference}, null, null));
        CML cmlCopy = new CML();
        cmlCopy.setCopy(new CMLCopy[]{copy});
        UpdateResult[] results2 = WebServiceFactory.getRepositoryService().update(cmlCopy);
        RepositoryServiceSystemTest.assertNotNull((Object)results2);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)results2.length);
        Reference newCopy = results2[0].getDestination();
        RepositoryServiceSystemTest.assertNotNull((Object)newCopy);
        QueryResult result = this.repositoryService.queryChildren(folderReference);
        RepositoryServiceSystemTest.assertEquals((long)1L, (long)result.getResultSet().getTotalRowCount());
    }

    public void testGet() throws Exception {
        Predicate predicate = new Predicate(null, BaseWebServiceSystemTest.store, null);
        Node[] nodes = WebServiceFactory.getRepositoryService().get(predicate);
        RepositoryServiceSystemTest.assertNotNull((Object)nodes);
        RepositoryServiceSystemTest.assertEquals((int)1, (int)nodes.length);
        Node rootNode = nodes[0];
        RepositoryServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.rootReference.getUuid(), (String)rootNode.getReference().getUuid());
        logger.debug((Object)("Root node type = " + rootNode.getType()));
        String aspects = "";
        for (String aspect : rootNode.getAspects()) {
            aspects = aspects + aspect + ", ";
        }
        logger.debug((Object)("Root node aspects = " + aspects));
        for (NamedValue prop : rootNode.getProperties()) {
            logger.debug((Object)("Root node property " + prop.getName() + " = " + prop.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertySetGet() throws Exception {
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "dictionaryModel"));
        ParentReference parentReference = new ParentReference(new Store("workspace", "SpacesStore"), null, "/app:company_home", Constants.ASSOC_CONTAINS, Constants.ASSOC_CONTAINS);
        create.setParent(parentReference);
        create.setProperty(new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "testModel.xml", null), new NamedValue(Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "modelActive"), false, "true", null)});
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] results = WebServiceFactory.getRepositoryService().update(cml);
        Reference model = results[0].getDestination();
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/propertymodel.xml");
        byte[] bytes = ContentUtils.convertToByteArray(viewStream);
        this.contentService.write(model, Constants.PROP_CONTENT, bytes, new ContentFormat("text/xml", "UTF-8"));
        try {
            ParentReference parentReference2 = new ParentReference();
            parentReference2.setAssociationType(Constants.ASSOC_CHILDREN);
            parentReference2.setChildName(Constants.ASSOC_CHILDREN);
            parentReference2.setStore(BaseWebServiceSystemTest.store);
            parentReference2.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
            create = new CMLCreate();
            create.setId("id1");
            create.setType(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "testproperties"));
            create.setParent(parentReference2);
            cml = new CML();
            cml.setCreate(new CMLCreate[]{create});
            UpdateResult[] results2 = WebServiceFactory.getRepositoryService().update(cml);
            Reference reference = results2[0].getDestination();
            ArrayList<String> list = new ArrayList<String>();
            list.add("Filrst sadf d");
            list.add("Seconf sdfasdf");
            System.out.println(((Object)list).toString());
            System.out.println(new String[]{"firstValue", "secondValue", "thirdValue"}.toString());
            NamedValue[] properties = new NamedValue[]{Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "textProp"), "some text"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "intProp"), "12"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "longProp"), "1234567890"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "floatProp"), "12.345"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "doubleProp"), "12.345"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "dateProp"), "2005-09-16T00:00:00.000+00:00"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "datetimeProp"), "2005-09-16T17:01:03.456+01:00"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "booleanProp"), "false"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "qnameProp"), "{http://www.alfresco.org/model/webservicetestmodel/1.0}testProperties"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "noderefProp"), "workspace://SpacesStore/123123123"), Utils.createNamedValue(Constants.createQNameString("http://www.alfresco.org/model/webservicetestmodel/1.0", "textMultiProp"), new String[]{"firstValue", "secondValue", "thirdValue"})};
            CMLUpdate cmlUpdate = new CMLUpdate(properties, new Predicate(new Reference[]{reference}, null, null), null);
            cml = new CML();
            cml.setUpdate(new CMLUpdate[]{cmlUpdate});
            WebServiceFactory.getRepositoryService().update(cml);
            Node[] nodes = WebServiceFactory.getRepositoryService().get(new Predicate(new Reference[]{reference}, null, null));
            Node node = nodes[0];
            for (NamedValue namedValue : node.getProperties()) {
                if (namedValue.getIsMultiValue() == null || !namedValue.getIsMultiValue().booleanValue()) {
                    System.out.println(namedValue.getName() + " = " + namedValue.getValue());
                    continue;
                }
                System.out.print(namedValue.getName() + " = ");
                for (String value : namedValue.getValues()) {
                    System.out.print(value + " ");
                }
                System.out.println("");
            }
        }
        catch (Throwable throwable) {
            Predicate where = new Predicate(new Reference[]{model}, null, null);
            CMLDelete cmlDelete = new CMLDelete(where);
            cml = new CML();
            cml.setDelete(new CMLDelete[]{cmlDelete});
            WebServiceFactory.getRepositoryService().update(cml);
            throw throwable;
        }
        Predicate where = new Predicate(new Reference[]{model}, null, null);
        CMLDelete cmlDelete = new CMLDelete(where);
        cml = new CML();
        cml.setDelete(new CMLDelete[]{cmlDelete});
        WebServiceFactory.getRepositoryService().update(cml);
    }
}

