/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.File;
import java.io.InputStream;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;

public class ContentServiceSystemTest
extends BaseWebServiceSystemTest {
    private static final String CONTENT = "This is a small piece of content to test the create service call";
    private static final String UPDATED_CONTENT = "This is some updated content to test the write service call";
    private String fileName = "unit-test.txt";

    public void testContentService() throws Exception {
        ParentReference parentRef = new ParentReference();
        parentRef.setStore(BaseWebServiceSystemTest.store);
        parentRef.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        parentRef.setAssociationType(Constants.ASSOC_CHILDREN);
        parentRef.setChildName(Constants.ASSOC_CHILDREN);
        NamedValue[] properties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, this.fileName, null)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] result = this.repositoryService.update(cml);
        Reference newContentNode = result[0].getDestination();
        String property = Constants.PROP_CONTENT;
        Predicate predicate = new Predicate(new Reference[]{newContentNode}, BaseWebServiceSystemTest.store, null);
        Content[] contents1 = this.contentService.read(predicate, property);
        ContentServiceSystemTest.assertNotNull((Object)contents1);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents1.length);
        Content content1 = contents1[0];
        ContentServiceSystemTest.assertNotNull((Object)content1);
        ContentServiceSystemTest.assertEquals((long)0L, (long)content1.getLength());
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content1.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content1.getProperty());
        ContentServiceSystemTest.assertNull((Object)content1.getUrl());
        ContentServiceSystemTest.assertNull((Object)content1.getFormat());
        Content content2 = this.contentService.write(newContentNode, property, CONTENT.getBytes(), new ContentFormat("text/plain", "UTF-8"));
        ContentServiceSystemTest.assertNotNull((Object)content2);
        ContentServiceSystemTest.assertTrue((content2.getLength() > 0L ? 1 : 0) != 0);
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content2.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content2.getProperty());
        ContentServiceSystemTest.assertNotNull((Object)content2.getUrl());
        ContentServiceSystemTest.assertNotNull((Object)content2.getFormat());
        ContentFormat format2 = content2.getFormat();
        ContentServiceSystemTest.assertEquals((String)"text/plain", (String)format2.getMimetype());
        ContentServiceSystemTest.assertEquals((String)"UTF-8", (String)format2.getEncoding());
        ContentServiceSystemTest.assertEquals((String)CONTENT, (String)ContentUtils.getContentAsString(content2));
        Content[] contents3 = this.contentService.read(predicate, property);
        ContentServiceSystemTest.assertNotNull((Object)contents3);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents3.length);
        Content content3 = contents3[0];
        ContentServiceSystemTest.assertNotNull((Object)content3);
        ContentServiceSystemTest.assertTrue((content3.getLength() > 0L ? 1 : 0) != 0);
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content3.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content3.getProperty());
        ContentServiceSystemTest.assertNotNull((Object)content3.getUrl());
        ContentServiceSystemTest.assertNotNull((Object)content3.getFormat());
        ContentFormat format3 = content3.getFormat();
        ContentServiceSystemTest.assertEquals((String)"text/plain", (String)format3.getMimetype());
        ContentServiceSystemTest.assertEquals((String)"UTF-8", (String)format3.getEncoding());
        ContentServiceSystemTest.assertEquals((String)CONTENT, (String)ContentUtils.getContentAsString(content3));
        Content content4 = this.contentService.write(newContentNode, property, UPDATED_CONTENT.getBytes(), new ContentFormat("text/css", "UTF-8"));
        ContentServiceSystemTest.assertNotNull((Object)content4);
        ContentServiceSystemTest.assertTrue((content4.getLength() > 0L ? 1 : 0) != 0);
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content4.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content4.getProperty());
        ContentServiceSystemTest.assertNotNull((Object)content4.getUrl());
        ContentServiceSystemTest.assertNotNull((Object)content4.getFormat());
        ContentFormat format4 = content4.getFormat();
        ContentServiceSystemTest.assertEquals((String)"text/css", (String)format4.getMimetype());
        ContentServiceSystemTest.assertEquals((String)"UTF-8", (String)format4.getEncoding());
        ContentServiceSystemTest.assertEquals((String)UPDATED_CONTENT, (String)ContentUtils.getContentAsString(content4));
        Content[] contents5 = this.contentService.read(predicate, property);
        ContentServiceSystemTest.assertNotNull((Object)contents5);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents5.length);
        Content content5 = contents5[0];
        ContentServiceSystemTest.assertNotNull((Object)content5);
        ContentServiceSystemTest.assertTrue((content5.getLength() > 0L ? 1 : 0) != 0);
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content5.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content5.getProperty());
        ContentServiceSystemTest.assertNotNull((Object)content5.getUrl());
        ContentServiceSystemTest.assertNotNull((Object)content5.getFormat());
        ContentFormat format5 = content5.getFormat();
        ContentServiceSystemTest.assertEquals((String)"text/css", (String)format5.getMimetype());
        ContentServiceSystemTest.assertEquals((String)"UTF-8", (String)format5.getEncoding());
        ContentServiceSystemTest.assertEquals((String)UPDATED_CONTENT, (String)ContentUtils.getContentAsString(content5));
        Content[] contents6 = this.contentService.clear(predicate, property);
        ContentServiceSystemTest.assertNotNull((Object)contents6);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents6.length);
        Content content6 = contents6[0];
        ContentServiceSystemTest.assertNotNull((Object)content6);
        ContentServiceSystemTest.assertEquals((long)0L, (long)content6.getLength());
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content6.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content6.getProperty());
        ContentServiceSystemTest.assertNull((Object)content6.getUrl());
        ContentServiceSystemTest.assertNull((Object)content6.getFormat());
        Content[] contents7 = this.contentService.read(predicate, property);
        ContentServiceSystemTest.assertNotNull((Object)contents7);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents7.length);
        Content content7 = contents7[0];
        ContentServiceSystemTest.assertNotNull((Object)content7);
        ContentServiceSystemTest.assertEquals((long)0L, (long)content7.getLength());
        ContentServiceSystemTest.assertEquals((String)newContentNode.getUuid(), (String)content7.getNode().getUuid());
        ContentServiceSystemTest.assertEquals((String)property, (String)content7.getProperty());
        ContentServiceSystemTest.assertNull((Object)content7.getUrl());
        ContentServiceSystemTest.assertNull((Object)content7.getFormat());
    }

    public void testUploadContentFromFile() throws Exception {
        ParentReference parentRef = new ParentReference();
        parentRef.setStore(BaseWebServiceSystemTest.store);
        parentRef.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        parentRef.setAssociationType(Constants.ASSOC_CHILDREN);
        parentRef.setChildName(Constants.ASSOC_CHILDREN);
        NamedValue[] properties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "quick.doc", null)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] result = this.repositoryService.update(cml);
        Reference newContentNode = result[0].getDestination();
        ContentFormat format = new ContentFormat("application/msword", "UTF-8");
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/quick.doc");
        byte[] bytes = ContentUtils.convertToByteArray(viewStream);
        this.contentService.write(newContentNode, Constants.PROP_CONTENT, bytes, format);
        Content[] contents = this.contentService.read(this.convertToPredicate(newContentNode), Constants.PROP_CONTENT);
        ContentServiceSystemTest.assertNotNull((Object)contents);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents.length);
        Content content = contents[0];
        File tempFile = File.createTempFile("testDoc", ".doc");
        System.out.println(tempFile.getPath());
        ContentUtils.copyContentToFile(content, tempFile);
    }

    public void testUploadImageFromFile() throws Exception {
        ParentReference parentRef = new ParentReference();
        parentRef.setStore(BaseWebServiceSystemTest.store);
        parentRef.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        parentRef.setAssociationType(Constants.ASSOC_CHILDREN);
        parentRef.setChildName(Constants.ASSOC_CHILDREN);
        NamedValue[] properties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "test.jpg", null)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] result = this.repositoryService.update(cml);
        Reference newContentNode = result[0].getDestination();
        ContentFormat format = new ContentFormat("image/jpeg", "UTF-8");
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/test.jpg");
        byte[] bytes = ContentUtils.convertToByteArray(viewStream);
        this.contentService.write(newContentNode, Constants.PROP_CONTENT, bytes, format);
        Content[] contents = this.contentService.read(this.convertToPredicate(newContentNode), Constants.PROP_CONTENT);
        ContentServiceSystemTest.assertNotNull((Object)contents);
        ContentServiceSystemTest.assertEquals((int)1, (int)contents.length);
        Content content = contents[0];
        File tempFile = File.createTempFile("testImage", ".jpg");
        System.out.println(tempFile.getPath());
        ContentUtils.copyContentToFile(content, tempFile);
    }
}

